/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.muc.provider.MUCParserUtils;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityJid;

public class MUCUserProvider
extends ExtensionElementProvider<MUCUser> {
    @Override
    public MUCUser parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        MUCUser mucUser = new MUCUser();
        block20: while (true) {
            switch (parser2.next()) {
                case START_ELEMENT: {
                    switch (parser2.getName()) {
                        case "invite": {
                            mucUser.setInvite(MUCUserProvider.parseInvite(parser2));
                            break;
                        }
                        case "item": {
                            mucUser.setItem(MUCParserUtils.parseItem(parser2));
                            break;
                        }
                        case "password": {
                            mucUser.setPassword(parser2.nextText());
                            break;
                        }
                        case "status": {
                            String statusString = parser2.getAttributeValue("", "code");
                            mucUser.addStatusCode(MUCUser.Status.create(statusString));
                            break;
                        }
                        case "decline": {
                            mucUser.setDecline(MUCUserProvider.parseDecline(parser2));
                            break;
                        }
                        case "destroy": {
                            mucUser.setDestroy(MUCParserUtils.parseDestroy(parser2));
                        }
                    }
                    continue block20;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) continue block20;
                    break block20;
                }
                default: {
                    continue block20;
                }
            }
            break;
        }
        return mucUser;
    }

    private static MUCUser.Invite parseInvite(XmlPullParser parser2) throws XmlPullParserException, IOException {
        String reason2 = null;
        EntityBareJid to = ParserUtils.getBareJidAttribute(parser2, "to");
        EntityJid from = ParserUtils.getEntityJidAttribute(parser2, "from");
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser2.next()) == XmlPullParser.Event.START_ELEMENT) {
                if (!parser2.getName().equals("reason")) continue;
                reason2 = parser2.nextText();
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser2.getName().equals("invite")) break;
        }
        return new MUCUser.Invite(reason2, from, to);
    }

    private static MUCUser.Decline parseDecline(XmlPullParser parser2) throws XmlPullParserException, IOException {
        String reason2 = null;
        EntityBareJid to = ParserUtils.getBareJidAttribute(parser2, "to");
        EntityBareJid from = ParserUtils.getBareJidAttribute(parser2, "from");
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser2.next()) == XmlPullParser.Event.START_ELEMENT) {
                if (!parser2.getName().equals("reason")) continue;
                reason2 = parser2.nextText();
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser2.getName().equals("decline")) break;
        }
        return new MUCUser.Decline(reason2, from, to);
    }
}

