/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jivesoftware.smack.util.Objects;
import org.minidns.dnslabel.DnsLabel;
import org.minidns.dnsname.DnsName;
import org.minidns.dnsname.InvalidDnsNameException;
import org.minidns.util.InetAddressUtil;

public abstract class InternetAddress
implements CharSequence {
    protected final String originalString;

    protected InternetAddress(String originalString) {
        this.originalString = Objects.requireNonNull(originalString, "The 'originalString' argument must not be null");
    }

    public abstract InetAddress asInetAddress() throws UnknownHostException;

    @Override
    public String toString() {
        return this.originalString;
    }

    @Override
    public int length() {
        return this.originalString.length();
    }

    @Override
    public char charAt(int index) {
        return this.originalString.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.originalString.subSequence(start, end);
    }

    public static InternetAddress from(String address) {
        InternetAddress internetAddress;
        if (InetAddressUtil.isIpV4Address(address)) {
            internetAddress = new Ipv4(address);
        } else if (InetAddressUtil.isIpV6Address(address)) {
            internetAddress = new Ipv6(address);
        } else if (address.contains(".")) {
            NonNumericInternetAddress domainNameInternetAddress;
            try {
                DnsName dnsName = DnsName.from(address);
                domainNameInternetAddress = new DomainName(address, dnsName);
            }
            catch (InvalidDnsNameException e) {
                domainNameInternetAddress = new InvalidDomainName(address, e);
            }
            internetAddress = domainNameInternetAddress;
        } else {
            DnsLabel dnsLabel = DnsLabel.from(address);
            internetAddress = new DomainNameLabel(address, dnsLabel);
        }
        return internetAddress;
    }

    public static InternetAddress from(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            return new Ipv4(inetAddress.getHostAddress(), (Inet4Address)inetAddress);
        }
        if (inetAddress instanceof Inet6Address) {
            return new Ipv6(inetAddress.getHostAddress(), (Inet6Address)inetAddress);
        }
        throw new IllegalArgumentException("Unknown type " + inetAddress.getClass() + " of " + inetAddress);
    }

    public static final class InvalidDomainName
    extends NonNumericInternetAddress {
        private final InvalidDnsNameException invalidDnsNameException;

        private InvalidDomainName(String originalString, InvalidDnsNameException invalidDnsNameException) {
            super(originalString);
            this.invalidDnsNameException = invalidDnsNameException;
        }

        public InvalidDnsNameException getInvalidDnsNameException() {
            return this.invalidDnsNameException;
        }
    }

    public static final class DomainNameLabel
    extends NonNumericInternetAddress {
        private final DnsLabel dnsLabel;

        private DomainNameLabel(String originalString, DnsLabel dnsLabel) {
            super(originalString);
            this.dnsLabel = dnsLabel;
        }

        public DnsLabel getDnsLabel() {
            return this.dnsLabel;
        }
    }

    public static final class DomainName
    extends NonNumericInternetAddress {
        private final DnsName dnsName;

        private DomainName(String originalString, DnsName dnsName) {
            super(originalString);
            this.dnsName = dnsName;
        }

        public DnsName getDnsName() {
            return this.dnsName;
        }
    }

    private static class NonNumericInternetAddress
    extends InternetAddress {
        private boolean attemptedToResolveInetAddress;
        private InetAddress inetAddress;

        protected NonNumericInternetAddress(String originalString) {
            super(originalString);
        }

        @Override
        public InetAddress asInetAddress() throws UnknownHostException {
            if (this.inetAddress != null || this.attemptedToResolveInetAddress) {
                return this.inetAddress;
            }
            this.attemptedToResolveInetAddress = true;
            this.inetAddress = InetAddress.getByName(this.originalString);
            return this.inetAddress;
        }
    }

    public static final class Ipv6
    extends InetAddressInternetAddress {
        private Inet6Address inet6Address;

        private Ipv6(String originalString) {
            this(originalString, InetAddressUtil.ipv6From(originalString));
        }

        private Ipv6(String originalString, Inet6Address inet6Address) {
            super(originalString, inet6Address);
            this.inet6Address = inet6Address;
        }

        public Inet6Address getInet6Address() {
            return this.inet6Address;
        }
    }

    public static final class Ipv4
    extends InetAddressInternetAddress {
        private final Inet4Address inet4Address;

        private Ipv4(String originalString) {
            this(originalString, InetAddressUtil.ipv4From(originalString));
        }

        private Ipv4(String originalString, Inet4Address inet4Address) {
            super(originalString, inet4Address);
            this.inet4Address = inet4Address;
        }

        public Inet4Address getInet4Address() {
            return this.inet4Address;
        }
    }

    private static class InetAddressInternetAddress
    extends InternetAddress {
        private final InetAddress inetAddress;

        protected InetAddressInternetAddress(String originalString, InetAddress inetAddress) {
            super(originalString);
            this.inetAddress = inetAddress;
        }

        @Override
        public InetAddress asInetAddress() {
            return this.inetAddress;
        }
    }
}

