/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.muc.ChatRoomListener;
import org.jitsi.jicofo.xmpp.muc.ChatRoomMember;
import org.jitsi.jicofo.xmpp.muc.ChatRoomMemberImpl;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.event.SyncEventEmitter;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.PresenceListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCAdmin;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;

@SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="We intentionally synchronize on [members] (a ConcurrentHashMap).")
public class ChatRoomImpl
implements ChatRoom,
PresenceListener {
    private final Logger logger;
    @NotNull
    private final XmppProvider xmppProvider;
    @NotNull
    private final EntityBareJid roomJid;
    private final MemberListener memberListener = new MemberListener();
    private final LocalUserStatusListener userListener = new LocalUserStatusListener();
    private Consumer<PresenceBuilder> presenceInterceptor;
    private final MultiUserChat muc;
    private EntityFullJid myOccupantJid;
    private final java.util.function.Consumer<ChatRoomImpl> leaveCallback;
    private final Map<EntityFullJid, ChatRoomMemberImpl> members = new ConcurrentHashMap<EntityFullJid, ChatRoomMemberImpl>();
    private MemberRole role;
    private PresenceBuilder lastPresenceSent;
    private String meetingId = null;
    private boolean isBreakoutRoom = false;
    private String mainRoom = null;
    private final Map<MediaType, Boolean> avModerationEnabled = Collections.synchronizedMap(new HashMap());
    private Map<String, List<String>> whitelists = new HashMap<String, List<String>>();
    private final EventEmitter<ChatRoomListener> eventEmitter = new SyncEventEmitter<ChatRoomListener>();
    private int numAudioSenders;
    private int numVideoSenders;

    public ChatRoomImpl(@NotNull XmppProvider xmppProvider, @NotNull EntityBareJid roomJid, java.util.function.Consumer<ChatRoomImpl> leaveCallback) {
        this.logger = new LoggerImpl(this.getClass().getName());
        this.logger.addContext("room", roomJid.toString());
        this.xmppProvider = xmppProvider;
        this.roomJid = roomJid;
        this.leaveCallback = leaveCallback;
        MultiUserChatManager manager = MultiUserChatManager.getInstanceFor(xmppProvider.getXmppConnection());
        this.muc = manager.getMultiUserChat(this.roomJid);
        this.muc.addParticipantStatusListener(this.memberListener);
        this.muc.addUserStatusListener(this.userListener);
        this.muc.addParticipantListener(this);
    }

    @Override
    public String getMeetingId() {
        return this.meetingId;
    }

    @Override
    public void addListener(@NotNull ChatRoomListener listener) {
        this.eventEmitter.addHandler(listener);
    }

    @Override
    public void removeListener(@NotNull ChatRoomListener listener) {
        this.eventEmitter.removeHandler(listener);
    }

    @Override
    public void removeAllListeners() {
        ArrayList<ChatRoomListener> listeners = new ArrayList<ChatRoomListener>(this.eventEmitter.getEventHandlers());
        listeners.forEach(this.eventEmitter::removeHandler);
    }

    public void setStartMuted(boolean[] startMuted) {
        this.eventEmitter.fireEvent(handler -> {
            handler.startMutedChanged(startMuted[0], startMuted[1]);
            return Unit.INSTANCE;
        });
    }

    @Override
    public EntityBareJid getRoomJid() {
        return this.roomJid;
    }

    @Override
    public void join() throws SmackException, XMPPException, InterruptedException {
        this.resetState();
        this.joinAs(this.xmppProvider.getConfig().getUsername());
    }

    @Override
    @NotNull
    public XmppProvider getXmppProvider() {
        return this.xmppProvider;
    }

    @Override
    public boolean isBreakoutRoom() {
        return this.isBreakoutRoom;
    }

    @Override
    public String getMainRoom() {
        return this.mainRoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetState() {
        Object object = this.members;
        synchronized (object) {
            if (!this.members.isEmpty()) {
                this.logger.warn("Removing " + this.members.size() + " stale members.");
                this.members.clear();
            }
        }
        object = this;
        synchronized (object) {
            this.role = null;
            this.lastPresenceSent = null;
            this.meetingId = null;
            this.logger.addContext("meeting_id", "");
            this.isBreakoutRoom = false;
            this.mainRoom = null;
            this.avModerationEnabled.clear();
            this.whitelists.clear();
        }
    }

    private void joinAs(Resourcepart nickname) throws SmackException, XMPPException, InterruptedException {
        FormField meetingIdField;
        this.myOccupantJid = JidCreate.entityFullFrom(this.roomJid, nickname);
        this.presenceInterceptor = presenceBuilder -> {
            ChatRoomImpl chatRoomImpl = this;
            synchronized (chatRoomImpl) {
                Presence p = presenceBuilder.build();
                p.removeExtension("x", "http://jabber.org/protocol/muc");
                this.lastPresenceSent = p.asBuilder();
            }
        };
        if (this.muc.isJoined()) {
            this.muc.leave();
        }
        this.muc.addPresenceInterceptor(this.presenceInterceptor);
        this.muc.createOrJoin(nickname);
        Form config = this.muc.getConfigurationForm();
        FormField isBreakoutRoomField = config.getField("muc#roominfo_isbreakout");
        if (isBreakoutRoomField != null) {
            FormField mainRoomField;
            this.isBreakoutRoom = Boolean.parseBoolean(isBreakoutRoomField.getFirstValue());
            if (this.isBreakoutRoom && (mainRoomField = config.getField("muc#roominfo_breakout_main_room")) != null) {
                this.mainRoom = mainRoomField.getFirstValue();
            }
        }
        if ((meetingIdField = config.getField("muc#roominfo_meetingId")) != null) {
            this.meetingId = meetingIdField.getFirstValue();
            if (this.meetingId != null) {
                this.logger.addContext("meeting_id", this.meetingId);
            }
        }
        FillableForm answer = config.getFillableForm();
        answer.setAnswer("muc#roomconfig_whois", "anyone");
        this.muc.sendConfigurationForm(answer);
    }

    @Override
    public boolean isJoined() {
        return this.muc != null && this.muc.isJoined();
    }

    private void leave(String reason, EntityBareJid jid) {
        this.logger.info("Leave, reason: " + reason + " alt-jid: " + jid);
        this.leave();
    }

    @Override
    public void leave() {
        if (this.presenceInterceptor != null) {
            this.muc.removePresenceInterceptor(this.presenceInterceptor);
        }
        this.muc.removeParticipantStatusListener(this.memberListener);
        this.muc.removeUserStatusListener(this.userListener);
        this.muc.removeParticipantListener(this);
        if (this.leaveCallback != null) {
            this.leaveCallback.accept(this);
        }
        TaskPools.getIoPool().execute(() -> {
            block3: {
                AbstractXMPPConnection connection = this.xmppProvider.getXmppConnection();
                try {
                    if (this.isJoined()) {
                        this.muc.leave();
                    }
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | MultiUserChatException.MucNotJoinedException e) {
                    if (!connection.isConnected() && e instanceof SmackException.NotConnectedException) break block3;
                    this.logger.error("Failed to properly leave " + this.muc, e);
                }
            }
        });
    }

    @Override
    public MemberRole getUserRole() {
        if (this.role == null) {
            Occupant o = this.muc.getOccupant(this.myOccupantJid);
            if (o == null) {
                return null;
            }
            this.role = MemberRole.fromSmack(o.getRole(), o.getAffiliation());
        }
        return this.role;
    }

    private void resetCachedUserRole() {
        this.role = null;
    }

    private void resetRoleForOccupant(EntityFullJid occupantJid) {
        if (occupantJid.getResourcepart().equals(this.myOccupantJid.getResourcepart())) {
            this.resetCachedUserRole();
        } else {
            ChatRoomMemberImpl member = this.members.get(occupantJid);
            if (member != null) {
                member.resetCachedRole();
            } else {
                this.logger.error("Role reset for: " + occupantJid + " who does not exist");
            }
        }
    }

    private void setLocalUserRole(@NotNull MemberRole newRole) {
        MemberRole oldRole = this.role;
        this.role = newRole;
        if (oldRole != newRole) {
            this.eventEmitter.fireEvent(handler -> {
                handler.localRoleChanged(newRole, this.role);
                return Unit.INSTANCE;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChatRoomMember> getMembers() {
        Map<EntityFullJid, ChatRoomMemberImpl> map = this.members;
        synchronized (map) {
            return new ArrayList<ChatRoomMember>(this.members.values());
        }
    }

    @Override
    public ChatRoomMemberImpl getChatMember(EntityFullJid occupantJid) {
        if (occupantJid == null) {
            return null;
        }
        return this.members.get(occupantJid);
    }

    @Override
    public int getMembersCount() {
        return this.members.size();
    }

    @Override
    public synchronized boolean containsPresenceExtension(String elementName, String namespace) {
        return this.lastPresenceSent != null && this.lastPresenceSent.getExtension(new QName(namespace, elementName)) != null;
    }

    @Override
    public void grantOwnership(@NotNull ChatRoomMember member) {
        this.logger.debug("Grant owner to " + member);
        MUCAdmin admin = new MUCAdmin();
        admin.setType(IQ.Type.set);
        admin.setTo(this.roomJid);
        MUCItem item = new MUCItem(MUCAffiliation.owner, member.getJid().asBareJid());
        admin.addItem(item);
        AbstractXMPPConnection connection = this.xmppProvider.getXmppConnection();
        try {
            IQ reply = UtilKt.sendIqAndGetResponse(connection, admin);
            if (reply == null || reply.getType() != IQ.Type.result) {
                throw new RuntimeException("Failed to grant owner: " + (reply == null ? "" : reply.toXML()));
            }
        }
        catch (SmackException.NotConnectedException e) {
            throw new RuntimeException("Failed to grant owner - XMPP disconnected", e);
        }
    }

    public Occupant getOccupant(ChatRoomMemberImpl chatMember) {
        return this.muc.getOccupant(chatMember.getOccupantJid());
    }

    private MUCUser getMUCUserExtension(Presence packet) {
        if (packet != null) {
            return packet.getExtension(MUCUser.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPresenceExtension(ExtensionElement extension, boolean remove) {
        Presence presenceToSend = null;
        ChatRoomImpl chatRoomImpl = this;
        synchronized (chatRoomImpl) {
            if (this.lastPresenceSent == null) {
                this.logger.error("No presence packet obtained yet");
                return;
            }
            boolean presenceUpdated = false;
            ExtensionElement old = this.lastPresenceSent.getExtension(extension.getQName());
            if (old != null) {
                this.lastPresenceSent.removeExtension(old);
                presenceUpdated = true;
            }
            if (!remove) {
                this.lastPresenceSent.addExtension(extension);
                presenceUpdated = true;
            }
            if (presenceUpdated) {
                presenceToSend = this.lastPresenceSent.build();
            }
        }
        if (presenceToSend != null) {
            this.sendPresence(presenceToSend);
        }
    }

    @Override
    public synchronized Collection<ExtensionElement> getPresenceExtensions() {
        return this.lastPresenceSent != null ? new ArrayList<ExtensionElement>(this.lastPresenceSent.getExtensions()) : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyPresence(Collection<ExtensionElement> toRemove, Collection<ExtensionElement> toAdd) {
        Presence presenceToSend;
        ChatRoomImpl chatRoomImpl = this;
        synchronized (chatRoomImpl) {
            if (this.lastPresenceSent == null) {
                this.logger.error("No presence packet obtained yet");
                return;
            }
            if (toRemove != null) {
                toRemove.forEach(this.lastPresenceSent::removeExtension);
            }
            if (toAdd != null) {
                toAdd.forEach(this.lastPresenceSent::addExtension);
            }
            presenceToSend = this.lastPresenceSent.build();
        }
        this.sendPresence(presenceToSend);
    }

    private void sendPresence(Presence presence) {
        UtilKt.tryToSendStanza(this.xmppProvider.getXmppConnection(), presence);
    }

    @Override
    public int getAudioSendersCount() {
        return this.numAudioSenders;
    }

    @Override
    public int getVideoSendersCount() {
        return this.numVideoSenders;
    }

    public void addAudioSender() {
        ++this.numAudioSenders;
        this.logger.debug(() -> "The number of audio senders has increased to " + this.numAudioSenders + ".");
        this.eventEmitter.fireEvent(handler -> {
            handler.numAudioSendersChanged(this.numAudioSenders);
            return Unit.INSTANCE;
        });
    }

    public void removeAudioSender() {
        --this.numAudioSenders;
        this.logger.debug(() -> "The number of audio senders has decreased to " + this.numAudioSenders + ".");
        this.eventEmitter.fireEvent(handler -> {
            handler.numAudioSendersChanged(this.numAudioSenders);
            return Unit.INSTANCE;
        });
    }

    public void addVideoSender() {
        ++this.numVideoSenders;
        this.logger.debug(() -> "The number of video senders has increased to " + this.numVideoSenders + ".");
        this.eventEmitter.fireEvent(handler -> {
            handler.numVideoSendersChanged(this.numVideoSenders);
            return Unit.INSTANCE;
        });
    }

    public void removeVideoSender() {
        --this.numVideoSenders;
        this.logger.debug(() -> "The number of video senders has decreased to " + this.numVideoSenders + ".");
        this.eventEmitter.fireEvent(handler -> {
            handler.numVideoSendersChanged(this.numVideoSenders);
            return Unit.INSTANCE;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatRoomMemberImpl addMember(EntityFullJid jid) {
        Map<EntityFullJid, ChatRoomMemberImpl> map = this.members;
        synchronized (map) {
            if (this.members.containsKey(jid)) {
                return this.members.get(jid);
            }
            ChatRoomMemberImpl newMember = new ChatRoomMemberImpl(jid, this, this.logger);
            this.members.put(jid, newMember);
            if (!newMember.isAudioMuted()) {
                this.addAudioSender();
            }
            if (!newMember.isVideoMuted()) {
                this.addVideoSender();
            }
            return newMember;
        }
    }

    public Jid getJid(EntityFullJid occupantJid) {
        Occupant occupant = this.muc.getOccupant(occupantJid);
        if (occupant == null) {
            this.logger.error("Unable to get occupant for " + occupantJid);
            return null;
        }
        return occupant.getJid();
    }

    private void processOwnPresence(Presence presence) {
        MUCUser mucUser = this.getMUCUserExtension(presence);
        if (mucUser != null) {
            MUCAffiliation affiliation = mucUser.getItem().getAffiliation();
            MUCRole role = mucUser.getItem().getRole();
            MemberRole jitsiRole = MemberRole.fromSmack(role, affiliation);
            if (!presence.isAvailable() && MUCAffiliation.none == affiliation && MUCRole.none == role) {
                Destroy destroy = mucUser.getDestroy();
                if (destroy == null) {
                    this.leave();
                } else {
                    this.leave(destroy.getReason(), destroy.getJid());
                }
            } else {
                this.setLocalUserRole(jitsiRole);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processOtherPresence(Presence presence) {
        ChatRoomMemberImpl finalMember;
        EntityFullJid jid = presence.getFrom().asEntityFullJidIfPossible();
        if (jid == null) {
            this.logger.warn("Presence without a valid jid: " + presence.getFrom());
            return;
        }
        boolean memberJoined = false;
        boolean memberLeft = false;
        Map<EntityFullJid, ChatRoomMemberImpl> map = this.members;
        // MONITORENTER : map
        ChatRoomMemberImpl chatMember = this.getChatMember(jid);
        if (chatMember == null) {
            if (!presence.getType().equals((Object)Presence.Type.available)) {
                // MONITOREXIT : map
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Joined " + jid + " room: " + this.roomJid);
            }
            chatMember = this.addMember(jid);
            memberJoined = true;
        } else if (presence.getType().equals((Object)Presence.Type.unavailable)) {
            memberLeft = true;
        }
        // MONITOREXIT : map
        if (chatMember == null) return;
        chatMember.processPresence(presence);
        if (memberJoined) {
            finalMember = chatMember;
            this.eventEmitter.fireEvent(handler -> {
                handler.memberJoined(finalMember);
                return Unit.INSTANCE;
            });
        } else if (memberLeft) {
            this.memberListener.left(jid);
        }
        if (memberLeft) return;
        finalMember = chatMember;
        this.eventEmitter.fireEvent(handler -> {
            handler.memberPresenceChanged(finalMember);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void processPresence(Presence presence) {
        if (presence == null || presence.getError() != null) {
            this.logger.warn("Unable to handle packet: " + (presence == null ? "null" : presence.toXML()));
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Presence received " + presence.toXML());
        }
        if (this.myOccupantJid == null) {
            this.logger.error("Processing presence when we're not aware of our address");
        }
        if (this.myOccupantJid != null && this.myOccupantJid.equals(presence.getFrom())) {
            this.processOwnPresence(presence);
        } else {
            this.processOtherPresence(presence);
        }
    }

    @Override
    public boolean isAvModerationEnabled(MediaType mediaType) {
        Boolean value2 = this.avModerationEnabled.get((Object)mediaType);
        return value2 != null && value2 != false;
    }

    @Override
    public void setAvModerationEnabled(MediaType mediaType, boolean value2) {
        this.avModerationEnabled.put(mediaType, value2);
    }

    @Override
    public void updateAvModerationWhitelists(@NotNull Map<String, List<String>> whitelists) {
        this.whitelists = whitelists;
    }

    @Override
    public boolean isMemberAllowedToUnmute(Jid jid, MediaType mediaType) {
        if (!this.isAvModerationEnabled(mediaType)) {
            return true;
        }
        List<String> whitelist = this.whitelists.get(mediaType.toString());
        return whitelist != null && whitelist.contains(jid.toString());
    }

    @Override
    @NotNull
    public OrderedJsonObject getDebugState() {
        OrderedJsonObject o = new OrderedJsonObject();
        o.put("room_jid", this.roomJid.toString());
        o.put("my_occupant_jid", String.valueOf(this.myOccupantJid));
        OrderedJsonObject membersJson = new OrderedJsonObject();
        for (ChatRoomMemberImpl m : this.members.values()) {
            membersJson.put(m.getJid(), m.getDebugState());
        }
        o.put("members", membersJson);
        o.put("role", String.valueOf((Object)this.role));
        o.put("meeting_id", String.valueOf(this.meetingId));
        o.put("is_breakout_room", (Object)this.isBreakoutRoom);
        o.put("main_room", String.valueOf(this.mainRoom));
        o.put("num_audio_senders", (Object)this.numAudioSenders);
        o.put("num_video_senders", (Object)this.numVideoSenders);
        return o;
    }

    class LocalUserStatusListener
    implements UserStatusListener {
        LocalUserStatusListener() {
        }

        @Override
        public void roomDestroyed(MultiUserChat alternateMUC, String reason) {
            ChatRoomImpl.this.eventEmitter.fireEvent(handler -> {
                handler.roomDestroyed(reason);
                return Unit.INSTANCE;
            });
        }
    }

    class MemberListener
    implements ParticipantStatusListener {
        MemberListener() {
        }

        @Override
        public void joined(EntityFullJid mucJid) {
            if (ChatRoomImpl.this.logger.isDebugEnabled()) {
                ChatRoomImpl.this.logger.debug("Ignore a member joined event for " + mucJid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ChatRoomMemberImpl removeMember(EntityFullJid occupantJid) {
            Map<EntityFullJid, ChatRoomMemberImpl> map = ChatRoomImpl.this.members;
            synchronized (map) {
                ChatRoomMemberImpl removed = ChatRoomImpl.this.members.remove(occupantJid);
                if (removed == null) {
                    ChatRoomImpl.this.logger.error(occupantJid + " not in " + ChatRoomImpl.this.roomJid);
                } else {
                    if (!removed.isAudioMuted()) {
                        ChatRoomImpl.this.removeAudioSender();
                    }
                    if (!removed.isVideoMuted()) {
                        ChatRoomImpl.this.removeVideoSender();
                    }
                }
                return removed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void left(EntityFullJid occupantJid) {
            ChatRoomMemberImpl member;
            Map<EntityFullJid, ChatRoomMemberImpl> map = ChatRoomImpl.this.members;
            synchronized (map) {
                if (ChatRoomImpl.this.logger.isDebugEnabled()) {
                    ChatRoomImpl.this.logger.debug("Left " + occupantJid + " room: " + ChatRoomImpl.this.roomJid);
                }
                member = this.removeMember(occupantJid);
            }
            if (member != null) {
                ChatRoomImpl.this.eventEmitter.fireEvent(handler -> {
                    handler.memberLeft(member);
                    return Unit.INSTANCE;
                });
            } else {
                ChatRoomImpl.this.logger.info("Member left event for non-existing member: " + occupantJid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void kicked(EntityFullJid occupantJid, Jid actor, String reason) {
            ChatRoomMemberImpl member;
            Map<EntityFullJid, ChatRoomMemberImpl> map = ChatRoomImpl.this.members;
            synchronized (map) {
                if (ChatRoomImpl.this.logger.isDebugEnabled()) {
                    ChatRoomImpl.this.logger.debug("Kicked: " + occupantJid + ", " + actor + ", " + reason);
                }
                member = this.removeMember(occupantJid);
            }
            if (member == null) {
                ChatRoomImpl.this.logger.error("Kicked member does not exist: " + occupantJid);
                return;
            }
            ChatRoomImpl.this.eventEmitter.fireEvent(handler -> {
                handler.memberKicked(member);
                return Unit.INSTANCE;
            });
        }

        @Override
        public void voiceGranted(EntityFullJid s2) {
            if (ChatRoomImpl.this.logger.isTraceEnabled()) {
                ChatRoomImpl.this.logger.trace("Voice granted: " + s2);
            }
            ChatRoomImpl.this.resetRoleForOccupant(s2);
        }

        @Override
        public void voiceRevoked(EntityFullJid s2) {
            if (ChatRoomImpl.this.logger.isTraceEnabled()) {
                ChatRoomImpl.this.logger.trace("Voice revoked: " + s2);
            }
            ChatRoomImpl.this.resetRoleForOccupant(s2);
        }

        @Override
        public void banned(EntityFullJid s2, Jid actor, String reason) {
            if (ChatRoomImpl.this.logger.isTraceEnabled()) {
                ChatRoomImpl.this.logger.trace("Banned: " + s2 + ", " + actor + ", " + reason);
            }
            ChatRoomImpl.this.resetRoleForOccupant(s2);
        }

        @Override
        public void membershipGranted(EntityFullJid s2) {
            if (ChatRoomImpl.this.logger.isTraceEnabled()) {
                ChatRoomImpl.this.logger.trace("Membership granted: " + s2);
            }
            ChatRoomImpl.this.resetRoleForOccupant(s2);
        }

        @Override
        public void membershipRevoked(EntityFullJid s2) {
            if (ChatRoomImpl.this.logger.isTraceEnabled()) {
                ChatRoomImpl.this.logger.trace("Membership revoked: " + s2);
            }
            ChatRoomImpl.this.resetRoleForOccupant(s2);
        }

        @Override
        public void moderatorGranted(EntityFullJid s2) {
            if (ChatRoomImpl.this.logger.isTraceEnabled()) {
                ChatRoomImpl.this.logger.trace("Moderator granted: " + s2);
            }
            ChatRoomImpl.this.resetRoleForOccupant(s2);
        }

        @Override
        public void moderatorRevoked(EntityFullJid s2) {
            if (ChatRoomImpl.this.logger.isTraceEnabled()) {
                ChatRoomImpl.this.logger.trace("Moderator revoked: " + s2);
            }
            ChatRoomImpl.this.resetRoleForOccupant(s2);
        }

        @Override
        public void ownershipGranted(EntityFullJid s2) {
            if (ChatRoomImpl.this.logger.isTraceEnabled()) {
                ChatRoomImpl.this.logger.trace("Ownership granted: " + s2);
            }
            ChatRoomImpl.this.resetRoleForOccupant(s2);
        }

        @Override
        public void ownershipRevoked(EntityFullJid s2) {
            if (ChatRoomImpl.this.logger.isTraceEnabled()) {
                ChatRoomImpl.this.logger.trace("Ownership revoked: " + s2);
            }
            ChatRoomImpl.this.resetRoleForOccupant(s2);
        }

        @Override
        public void adminGranted(EntityFullJid s2) {
            if (ChatRoomImpl.this.logger.isTraceEnabled()) {
                ChatRoomImpl.this.logger.trace("Admin granted: " + s2);
            }
            ChatRoomImpl.this.resetRoleForOccupant(s2);
        }

        @Override
        public void adminRevoked(EntityFullJid s2) {
            if (ChatRoomImpl.this.logger.isTraceEnabled()) {
                ChatRoomImpl.this.logger.trace("Admin revoked: " + s2);
            }
            ChatRoomImpl.this.resetRoleForOccupant(s2);
        }

        @Override
        public void nicknameChanged(EntityFullJid oldNickname, Resourcepart newNickname) {
            ChatRoomImpl.this.logger.error("nicknameChanged - NOT IMPLEMENTED");
        }
    }

    private static class MucConfigFields {
        static final String IS_BREAKOUT_ROOM = "muc#roominfo_isbreakout";
        static final String MAIN_ROOM = "muc#roominfo_breakout_main_room";
        static final String MEETING_ID = "muc#roominfo_meetingId";
        static final String WHOIS = "muc#roomconfig_whois";

        private MucConfigFields() {
        }
    }
}

