/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.access;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.StatefulConnectionFilter;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.i2ptunnel.access.DestTracker;
import net.i2p.i2ptunnel.access.FilterDefinition;
import net.i2p.i2ptunnel.access.FilterDefinitionElement;
import net.i2p.i2ptunnel.access.Recorder;
import net.i2p.i2ptunnel.access.Threshold;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SimpleTimer2;

class AccessFilter
implements StatefulConnectionFilter {
    private static final long PURGE_INTERVAL = 1000L;
    private static final long SYNC_INTERVAL = 10000L;
    private static final ExecutorService DISK_WRITER = Executors.newSingleThreadExecutor();
    private final FilterDefinition definition;
    private final I2PAppContext context;
    private final AtomicBoolean timersRunning = new AtomicBoolean();
    private final Map<Hash, DestTracker> knownDests = new HashMap<Hash, DestTracker>();
    private final Map<Hash, DestTracker> unknownDests = new HashMap<Hash, DestTracker>();
    private volatile Syncer syncer;

    AccessFilter(I2PAppContext context, FilterDefinition definition) throws IOException {
        this.context = context;
        this.definition = definition;
        this.reload();
    }

    @Override
    public void start() {
        if (this.timersRunning.compareAndSet(false, true)) {
            new Purger();
            this.syncer = new Syncer();
        }
    }

    @Override
    public void stop() {
        this.timersRunning.set(false);
        this.syncer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allowDestination(Destination d) {
        DestTracker tracker;
        Hash hash = d.getHash();
        long now = this.context.clock().now();
        Map<Hash, DestTracker> map = this.knownDests;
        synchronized (map) {
            tracker = this.knownDests.get(hash);
        }
        if (tracker == null) {
            map = this.unknownDests;
            synchronized (map) {
                tracker = this.unknownDests.get(hash);
                if (tracker == null) {
                    tracker = new DestTracker(hash, this.definition.getDefaultThreshold());
                    this.unknownDests.put(hash, tracker);
                }
            }
        }
        return !tracker.recordAccess(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() throws IOException {
        HashMap<Hash, DestTracker> tmp = new HashMap<Hash, DestTracker>();
        for (FilterDefinitionElement element : this.definition.getElements()) {
            element.update(tmp);
        }
        Map<Hash, DestTracker> map = this.knownDests;
        synchronized (map) {
            this.knownDests.keySet().retainAll(tmp.keySet());
            for (Map.Entry e : tmp.entrySet()) {
                Hash newHash = (Hash)e.getKey();
                if (this.knownDests.containsKey(newHash)) continue;
                this.knownDests.put(newHash, (DestTracker)e.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void record() throws IOException {
        long now = this.context.clock().now();
        for (Recorder recorder : this.definition.getRecorders()) {
            Object b3222;
            Threshold threshold = recorder.getThreshold();
            File file = recorder.getFile();
            LinkedHashSet<Object> breached = new LinkedHashSet<Object>();
            if (file.exists() && file.isFile()) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(file));
                    while ((b3222 = reader.readLine()) != null) {
                        breached.add(b3222);
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException b3222) {}
                    }
                }
            }
            boolean newBreaches = false;
            b3222 = this.unknownDests;
            synchronized (b3222) {
                for (DestTracker destTracker : this.unknownDests.values()) {
                    if (!destTracker.getCounter().isBreached(threshold, now)) continue;
                    newBreaches |= breached.add(destTracker.getHash().toBase32());
                }
            }
            if (breached.isEmpty() || !newBreaches) continue;
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter(new SecureFileOutputStream(file)));
                for (String string : breached) {
                    writer.write(string);
                    writer.newLine();
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        long olderThan = this.context.clock().now() - (long)(this.definition.getPurgeSeconds() * 1000);
        Map<Hash, DestTracker> map = this.knownDests;
        synchronized (map) {
            for (DestTracker tracker : this.knownDests.values()) {
                tracker.purge(olderThan);
            }
        }
        map = this.unknownDests;
        synchronized (map) {
            Iterator<Map.Entry<Hash, DestTracker>> iter = this.unknownDests.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Hash, DestTracker> entry = iter.next();
                if (!entry.getValue().purge(olderThan)) continue;
                iter.remove();
            }
        }
    }

    private class Syncer
    extends SimpleTimer2.TimedEvent {
        Syncer() {
            super(AccessFilter.this.context.simpleTimer2(), 10000L);
        }

        @Override
        public void timeReached() {
            if (!AccessFilter.this.timersRunning.get()) {
                return;
            }
            DISK_WRITER.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        AccessFilter.this.record();
                        AccessFilter.this.reload();
                        Syncer syncer = AccessFilter.this.syncer;
                        if (syncer != null) {
                            syncer.schedule(10000L);
                        }
                    }
                    catch (IOException bad) {
                        Log log = AccessFilter.this.context.logManager().getLog(AccessFilter.class);
                        log.log(50, "syncing access list failed", bad);
                    }
                }
            });
        }
    }

    private class Purger
    extends SimpleTimer2.TimedEvent {
        Purger() {
            super(AccessFilter.this.context.simpleTimer2(), 1000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            if (!AccessFilter.this.timersRunning.get()) {
                Map map = AccessFilter.this.knownDests;
                synchronized (map) {
                    AccessFilter.this.knownDests.clear();
                }
                map = AccessFilter.this.unknownDests;
                synchronized (map) {
                    AccessFilter.this.unknownDests.clear();
                }
                return;
            }
            AccessFilter.this.purge();
            this.schedule(1000L);
        }
    }
}

