/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0007J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/name/NameUtils;", "", "()V", "CONTEXT_RECEIVER_PREFIX", "", "getCONTEXT_RECEIVER_PREFIX$annotations", "getCONTEXT_RECEIVER_PREFIX", "()Ljava/lang/String;", "SANITIZE_AS_JAVA_INVALID_CHARACTERS", "Lkotlin/text/Regex;", "capitalizeAsJavaClassName", "str", "contextReceiverName", "Lorg/jetbrains/kotlin/name/Name;", "index", "", "delegateFieldName", "getPackagePartClassNamePrefix", "shortFileName", "getScriptNameForFile", "filePath", "hasName", "", "name", "propertyDelegateName", "propertyName", "sanitizeAsJavaIdentifier", "compiler.common"})
public final class NameUtils {
    @NotNull
    public static final NameUtils INSTANCE = new NameUtils();
    @NotNull
    private static final Regex SANITIZE_AS_JAVA_INVALID_CHARACTERS = new Regex("[^\\p{L}\\p{Digit}]");
    @NotNull
    private static final String CONTEXT_RECEIVER_PREFIX = "$context_receiver";

    private NameUtils() {
    }

    @NotNull
    public static final String getCONTEXT_RECEIVER_PREFIX() {
        return CONTEXT_RECEIVER_PREFIX;
    }

    @JvmStatic
    public static /* synthetic */ void getCONTEXT_RECEIVER_PREFIX$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String sanitizeAsJavaIdentifier(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return SANITIZE_AS_JAVA_INVALID_CHARACTERS.replace((CharSequence)name2, "_");
    }

    @JvmStatic
    @NotNull
    public static final String getPackagePartClassNamePrefix(@NotNull String shortFileName) {
        Intrinsics.checkNotNullParameter((Object)shortFileName, (String)"shortFileName");
        return ((CharSequence)shortFileName).length() == 0 ? "_" : NameUtils.capitalizeAsJavaClassName(NameUtils.sanitizeAsJavaIdentifier(shortFileName));
    }

    @JvmStatic
    private static final String capitalizeAsJavaClassName(String str) {
        String string2;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string3 = String.valueOf(str.charAt(0));
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            StringBuilder stringBuilder3 = stringBuilder2.append(string4);
            String string5 = str.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            string2 = stringBuilder3.append(string5).toString();
        } else {
            string2 = '_' + str;
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final Name getScriptNameForFile(@NotNull String filePath2) {
        Intrinsics.checkNotNullParameter((Object)filePath2, (String)"filePath");
        Name name2 = Name.identifier(NameUtils.getPackagePartClassNamePrefix(StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)filePath2, (char)'/', null, (int)2, null), (char)'.', null, (int)2, null)));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(NameUtils.get\u2026ubstringBeforeLast('.')))");
        return name2;
    }

    @JvmStatic
    public static final boolean hasName(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return !Intrinsics.areEqual((Object)name2, (Object)SpecialNames.NO_NAME_PROVIDED) && !Intrinsics.areEqual((Object)name2, (Object)SpecialNames.ANONYMOUS);
    }

    @JvmStatic
    @NotNull
    public static final Name delegateFieldName(int index2) {
        Name name2 = Name.identifier("$$delegate_" + index2);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"\\$\\$delegate_$index\")");
        return name2;
    }

    @JvmStatic
    @NotNull
    public static final Name propertyDelegateName(@NotNull Name propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Name name2 = Name.identifier(propertyName.asString() + "$delegate");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"${propertyName.asString()}\\$delegate\")");
        return name2;
    }

    @JvmStatic
    @NotNull
    public static final Name contextReceiverName(int index2) {
        Name name2 = Name.identifier(CONTEXT_RECEIVER_PREFIX + '_' + index2);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"${CONTEXT_RECEIVER_PREFIX}_$index\")");
        return name2;
    }
}

