/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser;

import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingContext;
import org.jboss.galleon.util.formatparser.ParsingFormat;

public abstract class ParsingFormatBase
implements ParsingFormat {
    protected final String name;
    protected final String contentType;
    protected final boolean wrapper;

    protected ParsingFormatBase(String name) {
        this(name, false);
    }

    protected ParsingFormatBase(String name, String contentType) {
        this(name, contentType, false);
    }

    protected ParsingFormatBase(String name, boolean wrapper) {
        this(name, name, wrapper);
    }

    protected ParsingFormatBase(String name, String contentType, boolean wrapper) {
        this.name = name;
        this.contentType = contentType;
        this.wrapper = wrapper;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isWrapper() {
        return this.wrapper;
    }

    @Override
    public void pushed(ParsingContext ctx) throws FormatParsingException {
    }

    @Override
    public void react(ParsingContext ctx) throws FormatParsingException {
    }

    @Override
    public void deal(ParsingContext ctx) throws FormatParsingException {
    }

    @Override
    public void eol(ParsingContext ctx) throws FormatParsingException {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.wrapper ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParsingFormatBase other = (ParsingFormatBase)obj;
        if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.wrapper == other.wrapper;
    }

    public String toString() {
        return this.name;
    }
}

