"use strict";/*!-----------------------------------------------------------------------------
* Copyright (c) Microsoft Corporation. All rights reserved.
* Version: 0.34.0(9d278685b078158491964f8fd7ac9628fffa0f30)
* Released under the MIT license
* https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
*-----------------------------------------------------------------------------*/define("vs/language/typescript/tsMode",["require","require"],S=>{var Q=(()=>{var X=Object.create,v=Object.defineProperty,Y=Object.getOwnPropertyDescriptor,Z=Object.getOwnPropertyNames,q=Object.getPrototypeOf,ee=Object.prototype.hasOwnProperty,te=(e,t,i)=>t in e?v(e,t,{enumerable:!0,configurable:!0,writable:!0,value:i}):e[t]=i,P=(e=>typeof S<"u"?S:typeof Proxy<"u"?new Proxy(e,{get:(t,i)=>(typeof S<"u"?S:t)[i]}):e)(function(e){if(typeof S<"u")return S.apply(this,arguments);throw new Error('Dynamic require of "'+e+'" is not supported')}),ie=(e,t)=>()=>(t||e((t={exports:{}}).exports,t),t.exports),re=(e,t)=>{for(var i in t)v(e,i,{get:t[i],enumerable:!0})},C=(e,t,i,s)=>{if(t&&typeof t=="object"||typeof t=="function")for(let a of Z(t))!ee.call(e,a)&&a!==i&&v(e,a,{get:()=>t[a],enumerable:!(s=Y(t,a))||s.enumerable});return e},se=(e,t,i)=>(C(e,t,"default"),i&&C(i,t,"default")),T=(e,t,i)=>(i=e!=null?X(q(e)):{},C(t||!e||!e.__esModule?v(i,"default",{value:e,enumerable:!0}):i,e)),ne=e=>C(v({},"__esModule",{value:!0}),e),m=(e,t,i)=>(te(e,typeof t!="symbol"?t+"":t,i),i),ae=ie((e,t)=>{var i=T(P("vs/editor/editor.api"));t.exports=i}),O={};re(O,{Adapter:()=>y,CodeActionAdaptor:()=>$,DefinitionAdapter:()=>V,DiagnosticsAdapter:()=>M,FormatAdapter:()=>B,FormatHelper:()=>w,FormatOnTypeAdapter:()=>U,InlayHintsAdapter:()=>J,Kind:()=>l,LibFiles:()=>K,OccurrencesAdapter:()=>H,OutlineAdapter:()=>j,QuickInfoAdapter:()=>R,ReferenceAdapter:()=>W,RenameAdapter:()=>z,SignatureHelpAdapter:()=>F,SuggestAdapter:()=>x,WorkerManager:()=>N,flattenDiagnosticMessageText:()=>D,getJavaScriptWorker:()=>ue,getTypeScriptWorker:()=>ge,setupJavaScript:()=>de,setupTypeScript:()=>le});var r={};se(r,T(ae()));var N=class{constructor(e,t){this._modeId=e,this._defaults=t,this._worker=null,this._client=null,this._configChangeListener=this._defaults.onDidChange(()=>this._stopWorker()),this._updateExtraLibsToken=0,this._extraLibsChangeListener=this._defaults.onDidExtraLibsChange(()=>this._updateExtraLibs())}_configChangeListener;_updateExtraLibsToken;_extraLibsChangeListener;_worker;_client;dispose(){this._configChangeListener.dispose(),this._extraLibsChangeListener.dispose(),this._stopWorker()}_stopWorker(){this._worker&&(this._worker.dispose(),this._worker=null),this._client=null}async _updateExtraLibs(){if(!this._worker)return;let e=++this._updateExtraLibsToken,t=await this._worker.getProxy();this._updateExtraLibsToken===e&&t.updateExtraLibs(this._defaults.getExtraLibs())}_getClient(){return this._client||(this._client=(async()=>(this._worker=r.editor.createWebWorker({moduleId:"vs/language/typescript/tsWorker",label:this._modeId,keepIdleModels:!0,createData:{compilerOptions:this._defaults.getCompilerOptions(),extraLibs:this._defaults.getExtraLibs(),customWorkerPath:this._defaults.workerOptions.customWorkerPath,inlayHintsOptions:this._defaults.inlayHintsOptions}}),this._defaults.getEagerModelSync()?await this._worker.withSyncedResources(r.editor.getModels().filter(e=>e.getLanguageId()===this._modeId).map(e=>e.uri)):await this._worker.getProxy()))()),this._client}async getLanguageServiceWorker(...e){let t=await this._getClient();return this._worker&&await this._worker.withSyncedResources(e),t}},oe=P("./monaco.contribution"),o={};o["lib.d.ts"]=!0,o["lib.dom.d.ts"]=!0,o["lib.dom.iterable.d.ts"]=!0,o["lib.es2015.collection.d.ts"]=!0,o["lib.es2015.core.d.ts"]=!0,o["lib.es2015.d.ts"]=!0,o["lib.es2015.generator.d.ts"]=!0,o["lib.es2015.iterable.d.ts"]=!0,o["lib.es2015.promise.d.ts"]=!0,o["lib.es2015.proxy.d.ts"]=!0,o["lib.es2015.reflect.d.ts"]=!0,o["lib.es2015.symbol.d.ts"]=!0,o["lib.es2015.symbol.wellknown.d.ts"]=!0,o["lib.es2016.array.include.d.ts"]=!0,o["lib.es2016.d.ts"]=!0,o["lib.es2016.full.d.ts"]=!0,o["lib.es2017.d.ts"]=!0,o["lib.es2017.full.d.ts"]=!0,o["lib.es2017.intl.d.ts"]=!0,o["lib.es2017.object.d.ts"]=!0,o["lib.es2017.sharedmemory.d.ts"]=!0,o["lib.es2017.string.d.ts"]=!0,o["lib.es2017.typedarrays.d.ts"]=!0,o["lib.es2018.asyncgenerator.d.ts"]=!0,o["lib.es2018.asynciterable.d.ts"]=!0,o["lib.es2018.d.ts"]=!0,o["lib.es2018.full.d.ts"]=!0,o["lib.es2018.intl.d.ts"]=!0,o["lib.es2018.promise.d.ts"]=!0,o["lib.es2018.regexp.d.ts"]=!0,o["lib.es2019.array.d.ts"]=!0,o["lib.es2019.d.ts"]=!0,o["lib.es2019.full.d.ts"]=!0,o["lib.es2019.object.d.ts"]=!0,o["lib.es2019.string.d.ts"]=!0,o["lib.es2019.symbol.d.ts"]=!0,o["lib.es2020.bigint.d.ts"]=!0,o["lib.es2020.d.ts"]=!0,o["lib.es2020.full.d.ts"]=!0,o["lib.es2020.intl.d.ts"]=!0,o["lib.es2020.promise.d.ts"]=!0,o["lib.es2020.sharedmemory.d.ts"]=!0,o["lib.es2020.string.d.ts"]=!0,o["lib.es2020.symbol.wellknown.d.ts"]=!0,o["lib.es2021.d.ts"]=!0,o["lib.es2021.full.d.ts"]=!0,o["lib.es2021.intl.d.ts"]=!0,o["lib.es2021.promise.d.ts"]=!0,o["lib.es2021.string.d.ts"]=!0,o["lib.es2021.weakref.d.ts"]=!0,o["lib.es5.d.ts"]=!0,o["lib.es6.d.ts"]=!0,o["lib.esnext.d.ts"]=!0,o["lib.esnext.full.d.ts"]=!0,o["lib.esnext.intl.d.ts"]=!0,o["lib.esnext.promise.d.ts"]=!0,o["lib.esnext.string.d.ts"]=!0,o["lib.esnext.weakref.d.ts"]=!0,o["lib.scripthost.d.ts"]=!0,o["lib.webworker.d.ts"]=!0,o["lib.webworker.importscripts.d.ts"]=!0,o["lib.webworker.iterable.d.ts"]=!0;function D(e,t,i=0){if(typeof e=="string")return e;if(e===void 0)return"";let s="";if(i){s+=t;for(let a=0;a<i;a++)s+="  "}if(s+=e.messageText,i++,e.next)for(let a of e.next)s+=D(a,t,i);return s}function _(e){return e?e.map(t=>t.text).join(""):""}var y=class{constructor(e){this._worker=e}_textSpanToRange(e,t){let i=e.getPositionAt(t.start),s=e.getPositionAt(t.start+t.length),{lineNumber:a,column:c}=i,{lineNumber:u,column:n}=s;return{startLineNumber:a,startColumn:c,endLineNumber:u,endColumn:n}}},K=class{constructor(e){this._worker=e,this._libFiles={},this._hasFetchedLibFiles=!1,this._fetchLibFilesPromise=null}_libFiles;_hasFetchedLibFiles;_fetchLibFilesPromise;isLibFile(e){return e&&e.path.indexOf("/lib.")===0?!!o[e.path.slice(1)]:!1}getOrCreateModel(e){let t=r.Uri.parse(e),i=r.editor.getModel(t);if(i)return i;if(this.isLibFile(t)&&this._hasFetchedLibFiles)return r.editor.createModel(this._libFiles[t.path.slice(1)],"typescript",t);let s=oe.typescriptDefaults.getExtraLibs()[e];return s?r.editor.createModel(s.content,"typescript",t):null}_containsLibFile(e){for(let t of e)if(this.isLibFile(t))return!0;return!1}async fetchLibFilesIfNecessary(e){!this._containsLibFile(e)||await this._fetchLibFiles()}_fetchLibFiles(){return this._fetchLibFilesPromise||(this._fetchLibFilesPromise=this._worker().then(e=>e.getLibFiles()).then(e=>{this._hasFetchedLibFiles=!0,this._libFiles=e})),this._fetchLibFilesPromise}},M=class extends y{constructor(e,t,i,s){super(s),this._libFiles=e,this._defaults=t,this._selector=i;let a=n=>{if(n.getLanguageId()!==i)return;let d=()=>{let{onlyVisible:h}=this._defaults.getDiagnosticsOptions();h?n.isAttachedToEditor()&&this._doValidate(n):this._doValidate(n)},g,p=n.onDidChangeContent(()=>{clearTimeout(g),g=window.setTimeout(d,500)}),f=n.onDidChangeAttached(()=>{let{onlyVisible:h}=this._defaults.getDiagnosticsOptions();h&&(n.isAttachedToEditor()?d():r.editor.setModelMarkers(n,this._selector,[]))});this._listener[n.uri.toString()]={dispose(){p.dispose(),f.dispose(),clearTimeout(g)}},d()},c=n=>{r.editor.setModelMarkers(n,this._selector,[]);let d=n.uri.toString();this._listener[d]&&(this._listener[d].dispose(),delete this._listener[d])};this._disposables.push(r.editor.onDidCreateModel(n=>a(n))),this._disposables.push(r.editor.onWillDisposeModel(c)),this._disposables.push(r.editor.onDidChangeModelLanguage(n=>{c(n.model),a(n.model)})),this._disposables.push({dispose(){for(let n of r.editor.getModels())c(n)}});let u=()=>{for(let n of r.editor.getModels())c(n),a(n)};this._disposables.push(this._defaults.onDidChange(u)),this._disposables.push(this._defaults.onDidExtraLibsChange(u)),r.editor.getModels().forEach(n=>a(n))}_disposables=[];_listener=Object.create(null);dispose(){this._disposables.forEach(e=>e&&e.dispose()),this._disposables=[]}async _doValidate(e){let t=await this._worker(e.uri);if(e.isDisposed())return;let i=[],{noSyntaxValidation:s,noSemanticValidation:a,noSuggestionDiagnostics:c}=this._defaults.getDiagnosticsOptions();s||i.push(t.getSyntacticDiagnostics(e.uri.toString())),a||i.push(t.getSemanticDiagnostics(e.uri.toString())),c||i.push(t.getSuggestionDiagnostics(e.uri.toString()));let u=await Promise.all(i);if(!u||e.isDisposed())return;let n=u.reduce((g,p)=>p.concat(g),[]).filter(g=>(this._defaults.getDiagnosticsOptions().diagnosticCodesToIgnore||[]).indexOf(g.code)===-1),d=n.map(g=>g.relatedInformation||[]).reduce((g,p)=>p.concat(g),[]).map(g=>g.file?r.Uri.parse(g.file.fileName):null);await this._libFiles.fetchLibFilesIfNecessary(d),!e.isDisposed()&&r.editor.setModelMarkers(e,this._selector,n.map(g=>this._convertDiagnostics(e,g)))}_convertDiagnostics(e,t){let i=t.start||0,s=t.length||1,{lineNumber:a,column:c}=e.getPositionAt(i),{lineNumber:u,column:n}=e.getPositionAt(i+s),d=[];return t.reportsUnnecessary&&d.push(r.MarkerTag.Unnecessary),t.reportsDeprecated&&d.push(r.MarkerTag.Deprecated),{severity:this._tsDiagnosticCategoryToMarkerSeverity(t.category),startLineNumber:a,startColumn:c,endLineNumber:u,endColumn:n,message:D(t.messageText,`
`),code:t.code.toString(),tags:d,relatedInformation:this._convertRelatedInformation(e,t.relatedInformation)}}_convertRelatedInformation(e,t){if(!t)return[];let i=[];return t.forEach(s=>{let a=e;if(s.file&&(a=this._libFiles.getOrCreateModel(s.file.fileName)),!a)return;let c=s.start||0,u=s.length||1,{lineNumber:n,column:d}=a.getPositionAt(c),{lineNumber:g,column:p}=a.getPositionAt(c+u);i.push({resource:a.uri,startLineNumber:n,startColumn:d,endLineNumber:g,endColumn:p,message:D(s.messageText,`
`)})}),i}_tsDiagnosticCategoryToMarkerSeverity(e){switch(e){case 1:return r.MarkerSeverity.Error;case 3:return r.MarkerSeverity.Info;case 0:return r.MarkerSeverity.Warning;case 2:return r.MarkerSeverity.Hint}return r.MarkerSeverity.Info}},x=class extends y{get triggerCharacters(){return["."]}async provideCompletionItems(e,t,i,s){let a=e.getWordUntilPosition(t),c=new r.Range(t.lineNumber,a.startColumn,t.lineNumber,a.endColumn),u=e.uri,n=e.getOffsetAt(t),d=await this._worker(u);if(e.isDisposed())return;let g=await d.getCompletionsAtPosition(u.toString(),n);return!g||e.isDisposed()?void 0:{suggestions:g.entries.map(p=>{let f=c;if(p.replacementSpan){let A=e.getPositionAt(p.replacementSpan.start),k=e.getPositionAt(p.replacementSpan.start+p.replacementSpan.length);f=new r.Range(A.lineNumber,A.column,k.lineNumber,k.column)}let h=[];return p.kindModifiers?.indexOf("deprecated")!==-1&&h.push(r.languages.CompletionItemTag.Deprecated),{uri:u,position:t,offset:n,range:f,label:p.name,insertText:p.name,sortText:p.sortText,kind:x.convertKind(p.kind),tags:h}})}}async resolveCompletionItem(e,t){let i=e,s=i.uri,a=i.position,c=i.offset,u=await(await this._worker(s)).getCompletionEntryDetails(s.toString(),c,i.label);return u?{uri:s,position:a,label:u.name,kind:x.convertKind(u.kind),detail:_(u.displayParts),documentation:{value:x.createDocumentationString(u)}}:i}static convertKind(e){switch(e){case l.primitiveType:case l.keyword:return r.languages.CompletionItemKind.Keyword;case l.variable:case l.localVariable:return r.languages.CompletionItemKind.Variable;case l.memberVariable:case l.memberGetAccessor:case l.memberSetAccessor:return r.languages.CompletionItemKind.Field;case l.function:case l.memberFunction:case l.constructSignature:case l.callSignature:case l.indexSignature:return r.languages.CompletionItemKind.Function;case l.enum:return r.languages.CompletionItemKind.Enum;case l.module:return r.languages.CompletionItemKind.Module;case l.class:return r.languages.CompletionItemKind.Class;case l.interface:return r.languages.CompletionItemKind.Interface;case l.warning:return r.languages.CompletionItemKind.File}return r.languages.CompletionItemKind.Property}static createDocumentationString(e){let t=_(e.documentation);if(e.tags)for(let i of e.tags)t+=`

${E(i)}`;return t}};function E(e){let t=`*@${e.name}*`;if(e.name==="param"&&e.text){let[i,...s]=e.text;t+=`\`${i.text}\``,s.length>0&&(t+=` \u2014 ${s.map(a=>a.text).join(" ")}`)}else Array.isArray(e.text)?t+=` \u2014 ${e.text.map(i=>i.text).join(" ")}`:e.text&&(t+=` \u2014 ${e.text}`);return t}var F=class extends y{signatureHelpTriggerCharacters=["(",","];static _toSignatureHelpTriggerReason(e){switch(e.triggerKind){case r.languages.SignatureHelpTriggerKind.TriggerCharacter:return e.triggerCharacter?e.isRetrigger?{kind:"retrigger",triggerCharacter:e.triggerCharacter}:{kind:"characterTyped",triggerCharacter:e.triggerCharacter}:{kind:"invoked"};case r.languages.SignatureHelpTriggerKind.ContentChange:return e.isRetrigger?{kind:"retrigger"}:{kind:"invoked"};case r.languages.SignatureHelpTriggerKind.Invoke:default:return{kind:"invoked"}}}async provideSignatureHelp(e,t,i,s){let a=e.uri,c=e.getOffsetAt(t),u=await this._worker(a);if(e.isDisposed())return;let n=await u.getSignatureHelpItems(a.toString(),c,{triggerReason:F._toSignatureHelpTriggerReason(s)});if(!n||e.isDisposed())return;let d={activeSignature:n.selectedItemIndex,activeParameter:n.argumentIndex,signatures:[]};return n.items.forEach(g=>{let p={label:"",parameters:[]};p.documentation={value:_(g.documentation)},p.label+=_(g.prefixDisplayParts),g.parameters.forEach((f,h,A)=>{let k=_(f.displayParts),ce={label:k,documentation:{value:_(f.documentation)}};p.label+=k,p.parameters.push(ce),h<A.length-1&&(p.label+=_(g.separatorDisplayParts))}),p.label+=_(g.suffixDisplayParts),d.signatures.push(p)}),{value:d,dispose(){}}}},R=class extends y{async provideHover(e,t,i){let s=e.uri,a=e.getOffsetAt(t),c=await this._worker(s);if(e.isDisposed())return;let u=await c.getQuickInfoAtPosition(s.toString(),a);if(!u||e.isDisposed())return;let n=_(u.documentation),d=u.tags?u.tags.map(p=>E(p)).join(`  

`):"",g=_(u.displayParts);return{range:this._textSpanToRange(e,u.textSpan),contents:[{value:"```typescript\n"+g+"\n```\n"},{value:n+(d?`

`+d:"")}]}}},H=class extends y{async provideDocumentHighlights(e,t,i){let s=e.uri,a=e.getOffsetAt(t),c=await this._worker(s);if(e.isDisposed())return;let u=await c.getOccurrencesAtPosition(s.toString(),a);if(!(!u||e.isDisposed()))return u.map(n=>({range:this._textSpanToRange(e,n.textSpan),kind:n.isWriteAccess?r.languages.DocumentHighlightKind.Write:r.languages.DocumentHighlightKind.Text}))}},V=class extends y{constructor(e,t){super(t),this._libFiles=e}async provideDefinition(e,t,i){let s=e.uri,a=e.getOffsetAt(t),c=await this._worker(s);if(e.isDisposed())return;let u=await c.getDefinitionAtPosition(s.toString(),a);if(!u||e.isDisposed()||(await this._libFiles.fetchLibFilesIfNecessary(u.map(d=>r.Uri.parse(d.fileName))),e.isDisposed()))return;let n=[];for(let d of u){let g=this._libFiles.getOrCreateModel(d.fileName);g&&n.push({uri:g.uri,range:this._textSpanToRange(g,d.textSpan)})}return n}},W=class extends y{constructor(e,t){super(t),this._libFiles=e}async provideReferences(e,t,i,s){let a=e.uri,c=e.getOffsetAt(t),u=await this._worker(a);if(e.isDisposed())return;let n=await u.getReferencesAtPosition(a.toString(),c);if(!n||e.isDisposed()||(await this._libFiles.fetchLibFilesIfNecessary(n.map(g=>r.Uri.parse(g.fileName))),e.isDisposed()))return;let d=[];for(let g of n){let p=this._libFiles.getOrCreateModel(g.fileName);p&&d.push({uri:p.uri,range:this._textSpanToRange(p,g.textSpan)})}return d}},j=class extends y{async provideDocumentSymbols(e,t){let i=e.uri,s=await this._worker(i);if(e.isDisposed())return;let a=await s.getNavigationBarItems(i.toString());if(!a||e.isDisposed())return;let c=(n,d,g)=>{let p={name:d.text,detail:"",kind:b[d.kind]||r.languages.SymbolKind.Variable,range:this._textSpanToRange(e,d.spans[0]),selectionRange:this._textSpanToRange(e,d.spans[0]),tags:[]};if(g&&(p.containerName=g),d.childItems&&d.childItems.length>0)for(let f of d.childItems)c(n,f,p.name);n.push(p)},u=[];return a.forEach(n=>c(u,n)),u}},l=class{};m(l,"unknown",""),m(l,"keyword","keyword"),m(l,"script","script"),m(l,"module","module"),m(l,"class","class"),m(l,"interface","interface"),m(l,"type","type"),m(l,"enum","enum"),m(l,"variable","var"),m(l,"localVariable","local var"),m(l,"function","function"),m(l,"localFunction","local function"),m(l,"memberFunction","method"),m(l,"memberGetAccessor","getter"),m(l,"memberSetAccessor","setter"),m(l,"memberVariable","property"),m(l,"constructorImplementation","constructor"),m(l,"callSignature","call"),m(l,"indexSignature","index"),m(l,"constructSignature","construct"),m(l,"parameter","parameter"),m(l,"typeParameter","type parameter"),m(l,"primitiveType","primitive type"),m(l,"label","label"),m(l,"alias","alias"),m(l,"const","const"),m(l,"let","let"),m(l,"warning","warning");var b=Object.create(null);b[l.module]=r.languages.SymbolKind.Module,b[l.class]=r.languages.SymbolKind.Class,b[l.enum]=r.languages.SymbolKind.Enum,b[l.interface]=r.languages.SymbolKind.Interface,b[l.memberFunction]=r.languages.SymbolKind.Method,b[l.memberVariable]=r.languages.SymbolKind.Property,b[l.memberGetAccessor]=r.languages.SymbolKind.Property,b[l.memberSetAccessor]=r.languages.SymbolKind.Property,b[l.variable]=r.languages.SymbolKind.Variable,b[l.const]=r.languages.SymbolKind.Variable,b[l.localVariable]=r.languages.SymbolKind.Variable,b[l.variable]=r.languages.SymbolKind.Variable,b[l.function]=r.languages.SymbolKind.Function,b[l.localFunction]=r.languages.SymbolKind.Function;var w=class extends y{static _convertOptions(e){return{ConvertTabsToSpaces:e.insertSpaces,TabSize:e.tabSize,IndentSize:e.tabSize,IndentStyle:2,NewLineCharacter:`
`,InsertSpaceAfterCommaDelimiter:!0,InsertSpaceAfterSemicolonInForStatements:!0,InsertSpaceBeforeAndAfterBinaryOperators:!0,InsertSpaceAfterKeywordsInControlFlowStatements:!0,InsertSpaceAfterFunctionKeywordForAnonymousFunctions:!0,InsertSpaceAfterOpeningAndBeforeClosingNonemptyParenthesis:!1,InsertSpaceAfterOpeningAndBeforeClosingNonemptyBrackets:!1,InsertSpaceAfterOpeningAndBeforeClosingTemplateStringBraces:!1,PlaceOpenBraceOnNewLineForControlBlocks:!1,PlaceOpenBraceOnNewLineForFunctions:!1}}_convertTextChanges(e,t){return{text:t.newText,range:this._textSpanToRange(e,t.span)}}},B=class extends w{async provideDocumentRangeFormattingEdits(e,t,i,s){let a=e.uri,c=e.getOffsetAt({lineNumber:t.startLineNumber,column:t.startColumn}),u=e.getOffsetAt({lineNumber:t.endLineNumber,column:t.endColumn}),n=await this._worker(a);if(e.isDisposed())return;let d=await n.getFormattingEditsForRange(a.toString(),c,u,w._convertOptions(i));if(!(!d||e.isDisposed()))return d.map(g=>this._convertTextChanges(e,g))}},U=class extends w{get autoFormatTriggerCharacters(){return[";","}",`
`]}async provideOnTypeFormattingEdits(e,t,i,s,a){let c=e.uri,u=e.getOffsetAt(t),n=await this._worker(c);if(e.isDisposed())return;let d=await n.getFormattingEditsAfterKeystroke(c.toString(),u,i,w._convertOptions(s));if(!(!d||e.isDisposed()))return d.map(g=>this._convertTextChanges(e,g))}},$=class extends w{async provideCodeActions(e,t,i,s){let a=e.uri,c=e.getOffsetAt({lineNumber:t.startLineNumber,column:t.startColumn}),u=e.getOffsetAt({lineNumber:t.endLineNumber,column:t.endColumn}),n=w._convertOptions(e.getOptions()),d=i.markers.filter(f=>f.code).map(f=>f.code).map(Number),g=await this._worker(a);if(e.isDisposed())return;let p=await g.getCodeFixesAtPosition(a.toString(),c,u,d,n);return!p||e.isDisposed()?{actions:[],dispose:()=>{}}:{actions:p.filter(f=>f.changes.filter(h=>h.isNewFile).length===0).map(f=>this._tsCodeFixActionToMonacoCodeAction(e,i,f)),dispose:()=>{}}}_tsCodeFixActionToMonacoCodeAction(e,t,i){let s=[];for(let a of i.changes)for(let c of a.textChanges)s.push({resource:e.uri,versionId:void 0,textEdit:{range:this._textSpanToRange(e,c.span),text:c.newText}});return{title:i.description,edit:{edits:s},diagnostics:t.markers,kind:"quickfix"}}},z=class extends y{constructor(e,t){super(t),this._libFiles=e}async provideRenameEdits(e,t,i,s){let a=e.uri,c=a.toString(),u=e.getOffsetAt(t),n=await this._worker(a);if(e.isDisposed())return;let d=await n.getRenameInfo(c,u,{allowRenameOfImportPath:!1});if(d.canRename===!1)return{edits:[],rejectReason:d.localizedErrorMessage};if(d.fileToRename!==void 0)throw new Error("Renaming files is not supported.");let g=await n.findRenameLocations(c,u,!1,!1,!1);if(!g||e.isDisposed())return;let p=[];for(let f of g){let h=this._libFiles.getOrCreateModel(f.fileName);if(h)p.push({resource:h.uri,versionId:void 0,textEdit:{range:this._textSpanToRange(h,f.textSpan),text:i}});else throw new Error(`Unknown file ${f.fileName}.`)}return{edits:p}}},J=class extends y{async provideInlayHints(e,t,i){let s=e.uri,a=s.toString(),c=e.getOffsetAt({lineNumber:t.startLineNumber,column:t.startColumn}),u=e.getOffsetAt({lineNumber:t.endLineNumber,column:t.endColumn}),n=await this._worker(s);return e.isDisposed()?null:{hints:(await n.provideInlayHints(a,c,u)).map(d=>({...d,label:d.text,position:e.getPositionAt(d.position),kind:this._convertHintKind(d.kind)})),dispose:()=>{}}}_convertHintKind(e){switch(e){case"Parameter":return r.languages.InlayHintKind.Parameter;case"Type":return r.languages.InlayHintKind.Type;default:return r.languages.InlayHintKind.Type}}},I,L;function le(e){L=G(e,"typescript")}function de(e){I=G(e,"javascript")}function ue(){return new Promise((e,t)=>{if(!I)return t("JavaScript not registered!");e(I)})}function ge(){return new Promise((e,t)=>{if(!L)return t("TypeScript not registered!");e(L)})}function G(e,t){let i=new N(t,e),s=(...c)=>i.getLanguageServiceWorker(...c),a=new K(s);return r.languages.registerCompletionItemProvider(t,new x(s)),r.languages.registerSignatureHelpProvider(t,new F(s)),r.languages.registerHoverProvider(t,new R(s)),r.languages.registerDocumentHighlightProvider(t,new H(s)),r.languages.registerDefinitionProvider(t,new V(a,s)),r.languages.registerReferenceProvider(t,new W(a,s)),r.languages.registerDocumentSymbolProvider(t,new j(s)),r.languages.registerDocumentRangeFormattingEditProvider(t,new B(s)),r.languages.registerOnTypeFormattingEditProvider(t,new U(s)),r.languages.registerCodeActionProvider(t,new $(s)),r.languages.registerRenameProvider(t,new z(a,s)),r.languages.registerInlayHintsProvider(t,new J(s)),new M(a,e,t,s),s}return ne(O)})();return Q});

//# sourceMappingURL=tsMode.js.map