/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class TrvProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().expression("[A-Z]{2,3}").expression("[A-Z]P").number("dd").number("(dd)(dd)(dd)").expression("([AV])").number("(dd)(dd.d+)").expression("([NS])").number("(ddd)(dd.d+)").expression("([EW])").number("(ddd.d)").number("(dd)(dd)(dd)").number("([d.]{6})").number("(ddd)").number("(ddd)").number("(ddd)").number("(d)").number("(dd)").number("(dd)").number("(?:d{3,5})?,").number("(d+),").number("(d+),").number("(d+),").number("(d+)").groupBegin().text(",").expression("(").groupBegin().expression("[^\\|]+").number("|xx-xx-xx-xx-xx-xx").number("|d+&?").groupEnd("+").expression(")").groupEnd("?").any().compile();
    private static final Pattern PATTERN_HEARTBEAT = new PatternBuilder().expression("[A-Z]{2,3}").text("CP01,").number("(ddd)").number("(ddd)").number("(ddd)").number("(d)").number("(dd)").number("(dd)").groupBegin().number("(ddd)").number("d").number("ddd").number("d").number("dddd").number("(d)").number("(d)").number("(d)").groupEnd("?").any().compile();
    private static final Pattern PATTERN_LBS = new PatternBuilder().expression("[A-Z]{2,3}").text("AP02,").expression("[^,]+,").number("[01],").number("d+,").number("(d+),").number("(d+),").expression("(").groupBegin().number("d+|").number("d+|").number("d+,").groupEnd("+").expression(")").number("d+,").expression("(.*)").compile();

    public TrvProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Boolean decodeOptionalValue(Parser parser, int activeValue) {
        int value = parser.nextInt();
        if (value != 0) {
            return value == activeValue;
        }
        return null;
    }

    private void decodeCommon(Position position, Parser parser) {
        position.set("rssi", parser.nextInt());
        position.set("sat", parser.nextInt());
        position.set("battery", parser.nextInt());
        position.set("ignition", this.decodeOptionalValue(parser, 1));
        position.set("armed", this.decodeOptionalValue(parser, 1));
        int mode = parser.nextInt();
        if (mode != 0) {
            position.set("mode", mode);
        }
    }

    private void decodeWifi(Network network, String data) {
        for (String wifi : data.split("&")) {
            if (wifi.isEmpty()) continue;
            String[] values = wifi.split("\\|");
            network.addWifiAccessPoint(WifiAccessPoint.from(values[1].replace('-', ':'), Integer.parseInt(values[2])));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        String sentence = (String)msg;
        String id = sentence.startsWith("TRV") ? sentence.substring(0, 3) : sentence.substring(0, 2);
        String type = sentence.substring(id.length(), id.length() + 4);
        if (channel != null) {
            String responseHeader = id + (char)(type.charAt(0) + '\u0001') + type.substring(1);
            if (type.equals("AP00") && id.equals("IW")) {
                String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                channel.writeAndFlush((Object)new NetworkMessage(responseHeader + "," + time + ",0#", remoteAddress));
            } else if (type.equals("AP14")) {
                channel.writeAndFlush((Object)new NetworkMessage(responseHeader + ",0.000,0.000#", remoteAddress));
            } else {
                channel.writeAndFlush((Object)new NetworkMessage(responseHeader + "#", remoteAddress));
            }
        }
        if (type.equals("AP00")) {
            this.getDeviceSession(channel, remoteAddress, sentence.substring(id.length() + type.length()));
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        if (type.equals("CP01")) {
            parser = new Parser(PATTERN_HEARTBEAT, sentence);
            if (!parser.matches()) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            this.decodeCommon(position, parser);
            if (parser.hasNext(3)) {
                position.set("blocked", this.decodeOptionalValue(parser, 2));
                position.set("charge", this.decodeOptionalValue(parser, 1));
                position.set("motion", this.decodeOptionalValue(parser, 1));
            }
            return position;
        }
        if (type.equals("AP01") || type.equals("AP10") || type.equals("YP03") || type.equals("YP14")) {
            parser = new Parser(PATTERN, sentence);
            if (!parser.matches()) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setDate(parser.nextInt(), parser.nextInt(), parser.nextInt());
            position.setValid(parser.next().equals("A"));
            position.setLatitude(parser.nextCoordinate());
            position.setLongitude(parser.nextCoordinate());
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
            dateBuilder.setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
            position.setTime(dateBuilder.getDate());
            position.setCourse(parser.nextDouble());
            this.decodeCommon(position, parser);
            Network network = new Network();
            network.addCellTower(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextInt(), parser.nextInt().intValue()));
            if (parser.hasNext()) {
                this.decodeWifi(network, parser.next());
            }
            position.setNetwork(network);
            return position;
        }
        if (type.equals("AP02")) {
            parser = new Parser(PATTERN_LBS, sentence);
            if (!parser.matches()) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            int mcc = parser.nextInt();
            int mnc = parser.nextInt();
            Network network = new Network();
            for (String cell : parser.next().split(",")) {
                if (cell.isEmpty()) continue;
                String[] values = cell.split("\\|");
                network.addCellTower(CellTower.from(mcc, mnc, Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2])));
            }
            this.decodeWifi(network, parser.next());
            position.setNetwork(network);
            return position;
        }
        return null;
    }
}

