/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TrakMateProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_SRT = new PatternBuilder().text("^TMSRT|").expression("([^ ]+)|").number("(d+.d+)|").number("(d+.d+)|").number("(dd)(dd)(dd)|").number("(dd)(dd)(dd)|").number("(d+.d+)|").number("(d+.d+)|").any().compile();
    private static final Pattern PATTERN_PER = new PatternBuilder().text("^TM").expression("...|").expression("([^ ]+)|").number("(d+)|").number("(d+.d+)|").number("(d+.d+)|").number("(dd)(dd)(dd)|").number("(dd)(dd)(dd)|").number("(d+.d+)|").number("(d+.d+)|").number("(d+)|").optional().number("([01])|").groupBegin().number("(d+)|").number("(d+)|").number("(d+.d+)|").number("(d+.d+)|").or().number("-?d+ -?d+ -?d+|").number("([01])|").groupEnd().number("(d+.d+)|").number("(d+.d+)|").number("(d+.d+)|").optional().number("([01])|").number("([01])|").number("([01])|").any().compile();
    private static final Pattern PATTERN_ALT = new PatternBuilder().text("^TMALT|").expression("([^ ]+)|").number("(d+)|").number("(d+)|").number("(d+)|").number("(d+.d+)|").number("(d+.d+)|").number("(dd)(dd)(dd)|").number("(dd)(dd)(dd)|").number("(d+.d+)|").number("(d+.d+)|").any().compile();

    public TrakMateProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int value) {
        switch (value) {
            case 1: {
                return "sos";
            }
            case 3: {
                return "geofence";
            }
            case 4: {
                return "powerCut";
            }
        }
        return null;
    }

    private Object decodeSrt(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_SRT, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY));
        position.set("versionFw", parser.next());
        position.set("versionHw", parser.next());
        return position;
    }

    private Object decodeAlt(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_ALT, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        parser.next();
        position.set("alarm", this.decodeAlarm(parser.nextInt()));
        parser.next();
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY));
        position.setSpeed(parser.nextDouble());
        position.setCourse(parser.nextDouble());
        return position;
    }

    private Object decodePer(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN_PER, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        parser.next();
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY));
        position.setSpeed(parser.nextDouble());
        position.setCourse(parser.nextDouble());
        position.set("sat", parser.nextInt());
        position.set("ignition", parser.nextInt() > 0);
        if (parser.hasNext(4)) {
            position.set("dop1", parser.nextInt());
            position.set("dop2", parser.nextInt());
            position.set("adc1", parser.nextDouble());
            position.set("battery", parser.nextDouble());
        }
        if (parser.hasNext()) {
            position.set("motion", parser.nextInt(0) > 0);
        }
        position.set("power", parser.nextDouble());
        position.set("odometer", parser.nextDouble());
        position.set("pulseOdometer", parser.nextDouble());
        position.set("status", parser.nextInt());
        position.setValid(parser.nextInt() > 0);
        position.set("archive", parser.nextInt() > 0);
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String type;
        String sentence = (String)msg;
        int typeIndex = sentence.indexOf("^TM");
        if (typeIndex < 0) {
            return null;
        }
        switch (type = sentence.substring(typeIndex + 3, typeIndex + 6)) {
            case "ALT": {
                return this.decodeAlt(channel, remoteAddress, sentence);
            }
            case "SRT": {
                return this.decodeSrt(channel, remoteAddress, sentence);
            }
        }
        return this.decodePer(channel, remoteAddress, sentence);
    }
}

