/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TeraTrackProtocolDecoder
extends BaseProtocolDecoder {
    public TeraTrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String imei;
        JsonObject json = Json.createReader((Reader)new StringReader((String)msg)).readObject();
        String deviceId = json.getString("MDeviceID");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, deviceId, imei = json.getString("IMEI"));
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        position.setTime(dateFormat.parse(json.getString("DateTime")));
        position.setValid(true);
        position.setLatitude(Double.parseDouble(json.getString("Latitude")));
        position.setLongitude(Double.parseDouble(json.getString("Longitude")));
        position.setSpeed(UnitsConverter.knotsFromKph(Integer.parseInt(json.getString("Speed"))));
        position.set("odometer", Integer.parseInt(json.getString("Mileage")));
        position.set("lock", json.getString("LockOpen").equals("0"));
        position.set("driverUniqueId", json.getString("CardNo"));
        position.set("alarm", json.getString("LowPower").equals("1") ? "lowPower" : null);
        position.set("batteryLevel", Integer.parseInt(json.getString("Power")));
        position.set("rssi", Integer.parseInt(json.getString("GSM")));
        if (channel != null && json.getString("MessageAck").equals("1")) {
            channel.writeAndFlush((Object)new NetworkMessage("{01}", remoteAddress));
        }
        return position;
    }
}

