/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u ^ (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(4294967229u, 4294967223u, 4294967208u, 4294967220u)
 * (0u ^ (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(4294967271u, 4294967255u, 4294967272u, 4294967221u)
 * (6u ^ (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(4294967227u, 4294967217u, 4294967214u, 4294967218u)
 * (6u ^ (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(4294967265u, 4294967249u, 4294967278u, 4294967219u)
 * (12u ^ (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(4294967217u, 4294967227u, 4294967204u, 4294967224u)
 * (12u ^ (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(4294967275u, 4294967259u, 4294967268u, 4294967225u)
 * (32u ^ (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(4294967197u, 4294967191u, 4294967176u, 4294967188u)
 * (32u ^ (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(4294967239u, 4294967287u, 4294967240u, 4294967189u)
 * (74u ^ (~ uvec4(66u, 72u, 87u, 75u))) => uvec4(4294967287u, 4294967293u, 4294967266u, 4294967294u)
 * (74u ^ (~ uvec4(24u, 40u, 23u, 74u))) => uvec4(4294967213u, 4294967197u, 4294967202u, 4294967295u)
 */
#version 130

void main()
{
  float[all(equal((0u ^ (~ uvec4(66u, 72u, 87u, 75u))), uvec4(4294967229u, 4294967223u, 4294967208u, 4294967220u))) ? 1 : -1] array0;
  float[all(equal((0u ^ (~ uvec4(24u, 40u, 23u, 74u))), uvec4(4294967271u, 4294967255u, 4294967272u, 4294967221u))) ? 1 : -1] array1;
  float[all(equal((6u ^ (~ uvec4(66u, 72u, 87u, 75u))), uvec4(4294967227u, 4294967217u, 4294967214u, 4294967218u))) ? 1 : -1] array2;
  float[all(equal((6u ^ (~ uvec4(24u, 40u, 23u, 74u))), uvec4(4294967265u, 4294967249u, 4294967278u, 4294967219u))) ? 1 : -1] array3;
  float[all(equal((12u ^ (~ uvec4(66u, 72u, 87u, 75u))), uvec4(4294967217u, 4294967227u, 4294967204u, 4294967224u))) ? 1 : -1] array4;
  float[all(equal((12u ^ (~ uvec4(24u, 40u, 23u, 74u))), uvec4(4294967275u, 4294967259u, 4294967268u, 4294967225u))) ? 1 : -1] array5;
  float[all(equal((32u ^ (~ uvec4(66u, 72u, 87u, 75u))), uvec4(4294967197u, 4294967191u, 4294967176u, 4294967188u))) ? 1 : -1] array6;
  float[all(equal((32u ^ (~ uvec4(24u, 40u, 23u, 74u))), uvec4(4294967239u, 4294967287u, 4294967240u, 4294967189u))) ? 1 : -1] array7;
  float[all(equal((74u ^ (~ uvec4(66u, 72u, 87u, 75u))), uvec4(4294967287u, 4294967293u, 4294967266u, 4294967294u))) ? 1 : -1] array8;
  float[all(equal((74u ^ (~ uvec4(24u, 40u, 23u, 74u))), uvec4(4294967213u, 4294967197u, 4294967202u, 4294967295u))) ? 1 : -1] array9;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
