"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchRelevancePlugin = void 0;

var _operators = require("rxjs/operators");

var _routes = require("./routes");

var _metrics_service = require("./metrics/metrics_service");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class SearchRelevancePlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;

    _defineProperty(this, "config$", void 0);

    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "metricsService", void 0);

    this.config$ = this.initializerContext.config.create();
    this.logger = this.initializerContext.logger.get();
    this.metricsService = new _metrics_service.MetricsService(this.logger.get('metrics-service'));
  }

  async setup(core) {
    this.logger.debug('SearchRelevance: Setup');
    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const metricsService = this.metricsService.setup(config.metrics.metricInterval, config.metrics.windowSize);
    const router = core.http.createRouter();
    const opensearchSearchRelevanceClient = core.opensearch.legacy.createClient('opensearch_search_relevance'); // @ts-ignore

    core.http.registerRouteHandlerContext('searchRelevance', (context, request) => {
      return {
        logger: this.logger,
        relevancyWorkbenchClient: opensearchSearchRelevanceClient,
        metricsService: metricsService
      };
    }); // Register server side APIs

    (0, _routes.defineRoutes)(router);
    return {};
  }

  start(core) {
    this.logger.debug('SearchRelevance: Started');
    return {};
  }

  stop() {}

}

exports.SearchRelevancePlugin = SearchRelevancePlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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