"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MOCK_DATA = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const mockChime = {
  name: 'Chime test channel',
  description: 'test description',
  config_type: 'chime',
  is_enabled: true,
  chime: {
    url: 'https://chimehook'
  },
  config_id: 'test-chime',
  created_time_ms: 1622670451891,
  last_updated_time_ms: 1622670451891
};
const mockSlack = {
  name: 'Slack test channel',
  description: 'test description',
  config_type: 'slack',
  is_enabled: false,
  slack: {
    url: 'https://chimehook'
  },
  config_id: 'test-slack',
  created_time_ms: 1622670451891,
  last_updated_time_ms: 1622670451891
};
const mockEmail = {
  name: 'Email test channel',
  description: 'test description',
  config_type: 'email',
  is_enabled: true,
  email: {
    email_account_id: 'dj8etXkBCzVy9Vy-nsiL',
    recipient_list: [{
      recipient: 'custom@email.com'
    }, {
      recipient: 'email@test.com'
    }, {
      recipient: 'test@email.com'
    }],
    email_group_id_list: ['1l8hq3kB0XwiBlEbanSo', 'dz8etXkBCzVy9Vy-0sgh', 'eD8ktXkBCzVy9Vy-A8j-', '1V8gq3kB0XwiBlEbAXSI', 'dD_8tHkBCzVy9Vy-5si0', '52XGr3kBqFjWrmvL43mv'],
    email_account_name: 'name1',
    email_group_id_map: {
      '1l8hq3kB0XwiBlEbanSo': 'name1',
      'dz8etXkBCzVy9Vy-0sgh': 'name2',
      'eD8ktXkBCzVy9Vy-A8j-': 'name3',
      '1V8gq3kB0XwiBlEbAXSI': 'name4',
      'dD_8tHkBCzVy9Vy-5si0': 'name5',
      '52XGr3kBqFjWrmvL43mv': 'name6'
    },
    invalid_ids: [],
    sender_type: 'smtp_account'
  },
  config_id: 'DMG3zXkBPa6YFxmVfNmm',
  created_time_ms: 1622654024861,
  last_updated_time_ms: 1622656665674
};
const mockEmailWithSES = {
  name: 'Email test channel',
  description: 'test description',
  config_type: 'email',
  is_enabled: true,
  email: {
    email_account_id: 'dj8etXkBCzVy9Vy-nsiL',
    recipient_list: [{
      recipient: 'custom@email.com'
    }, {
      recipient: 'email@test.com'
    }, {
      recipient: 'test@email.com'
    }],
    email_group_id_list: ['1y8ud3xO0KjvOyRonaFb', 'qm8rgKxOPmIl9Il-0ftu', 'rQ8xgKxOPmIl9Il-N8w-', '1I8td3xO0KjvOyRoNKFV', 'qQ_8gUxOPmIl9Il-5fv0', '52KTe3xOdSwJeziY43zi'],
    email_account_name: 'name1',
    email_group_id_map: {
      '1y8ud3xO0KjvOyRonaFb': 'name1',
      'qm8rgKxOPmIl9Il-0ftu': 'name2',
      'rQ8xgKxOPmIl9Il-N8w-': 'name3',
      '1I8td3xO0KjvOyRoNKFV': 'name4',
      'qQ_8gUxOPmIl9Il-5fv0': 'name5',
      '52KTe3xOdSwJeziY43zi': 'name6'
    },
    invalid_ids: ['52KTe3xOdSwJeziY43zi'],
    sender_type: 'ses_account'
  },
  config_id: 'QZT3mKxOCn6LSkzIsAzz',
  created_time_ms: 1622654024861,
  last_updated_time_ms: 1622656665674
};
const mockWebhook = {
  name: 'Webhook test channel',
  description: 'test description',
  config_type: 'webhook',
  is_enabled: true,
  webhook: {
    url: 'https://host:23/path?key1=%23%404&key2=&key3=value3',
    header_params: {
      key1: 'value1',
      key2: 'value2',
      key3: '',
      key4: 'value4',
      key5: 'value5',
      key6: 'value6'
    },
    method: 'POST'
  },
  config_id: '7mUjsHkBqFjWrmvLc3nl',
  created_time_ms: 1622157784037,
  last_updated_time_ms: 1622581084050
};
const mockSNS = {
  name: 'SNS test channel',
  description: 'test description',
  config_type: 'sns',
  is_enabled: true,
  sns: {
    topic_arn: 'arn:aws:sns:us-west-2:012345678912:notifications-test',
    role_arn: 'arn:aws:iam::012345678912:role/NotificationsSNSRole'
  },
  config_id: 'erCDYHsBUMRLC5PZXfPN',
  created_time_ms: 1622157784037,
  last_updated_time_ms: 1622581084050
};
const mockSender = {
  name: 'test-sender',
  description: 'test description',
  config_id: '72UysHkBqFjWrmvLFXkB',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  smtp_account: {
    host: 'example.com',
    port: '23',
    method: 'start_tls',
    from_address: 'sample@email.com'
  }
};
const mockMicrosoftTeams = {
  name: 'Microsoft Teams test channel',
  description: 'test description',
  config_type: 'microsoft_teams',
  is_enabled: false,
  microsoft_teams: {
    url: 'https://chimehook'
  },
  config_id: 'test-slack',
  created_time_ms: 1622670451891,
  last_updated_time_ms: 1622670451891
};
const mockSESSender = {
  name: 'test-ses-sender',
  description: 'test description',
  config_id: '72HlfUxOdSwJeziYSKxO',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  ses_account: {
    from_address: 'sample@email.com',
    region: 'us-west-2',
    role_arn: 'arn:aws:iam::012345678912:role/TestNotificationsSESRole'
  }
};
const mockRecipientGroup = {
  name: 'Test recipient group',
  description: 'test description',
  config_id: '72UysHkBqVjWrmvLFXkB',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  email_group: {
    recipient_list: [{
      recipient: 'test1@email.com'
    }, {
      recipient: 'test2@email.com'
    }, {
      recipient: 'test3@email.com'
    }, {
      recipient: 'test4@email.com'
    }, {
      recipient: 'test5@email.com'
    }, {
      recipient: 'test6@email.com'
    }]
  }
};
const MOCK_DATA = {
  channels: {
    items: [mockChime, mockSlack, mockEmail, mockEmailWithSES, mockWebhook, mockSNS, mockMicrosoftTeams],
    total: 7
  },
  chime: mockChime,
  slack: mockSlack,
  email: mockEmail,
  emailWithSES: mockEmailWithSES,
  webhook: mockWebhook,
  sns: mockSNS,
  microsoftTeams: mockMicrosoftTeams,
  sender: mockSender,
  sesSender: mockSESSender,
  senders: {
    items: [mockSender],
    total: 1
  },
  sesSenders: {
    items: [mockSESSender],
    total: 1
  },
  recipientGroup: mockRecipientGroup,
  recipientGroups: {
    items: [mockRecipientGroup],
    total: 1
  }
};
exports.MOCK_DATA = MOCK_DATA;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1vY2tEYXRhLnRzIl0sIm5hbWVzIjpbIm1vY2tDaGltZSIsIm5hbWUiLCJkZXNjcmlwdGlvbiIsImNvbmZpZ190eXBlIiwiaXNfZW5hYmxlZCIsImNoaW1lIiwidXJsIiwiY29uZmlnX2lkIiwiY3JlYXRlZF90aW1lX21zIiwibGFzdF91cGRhdGVkX3RpbWVfbXMiLCJtb2NrU2xhY2siLCJzbGFjayIsIm1vY2tFbWFpbCIsImVtYWlsIiwiZW1haWxfYWNjb3VudF9pZCIsInJlY2lwaWVudF9saXN0IiwicmVjaXBpZW50IiwiZW1haWxfZ3JvdXBfaWRfbGlzdCIsImVtYWlsX2FjY291bnRfbmFtZSIsImVtYWlsX2dyb3VwX2lkX21hcCIsImludmFsaWRfaWRzIiwic2VuZGVyX3R5cGUiLCJtb2NrRW1haWxXaXRoU0VTIiwibW9ja1dlYmhvb2siLCJ3ZWJob29rIiwiaGVhZGVyX3BhcmFtcyIsImtleTEiLCJrZXkyIiwia2V5MyIsImtleTQiLCJrZXk1Iiwia2V5NiIsIm1ldGhvZCIsIm1vY2tTTlMiLCJzbnMiLCJ0b3BpY19hcm4iLCJyb2xlX2FybiIsIm1vY2tTZW5kZXIiLCJzbXRwX2FjY291bnQiLCJob3N0IiwicG9ydCIsImZyb21fYWRkcmVzcyIsIm1vY2tNaWNyb3NvZnRUZWFtcyIsIm1pY3Jvc29mdF90ZWFtcyIsIm1vY2tTRVNTZW5kZXIiLCJzZXNfYWNjb3VudCIsInJlZ2lvbiIsIm1vY2tSZWNpcGllbnRHcm91cCIsImVtYWlsX2dyb3VwIiwiTU9DS19EQVRBIiwiY2hhbm5lbHMiLCJpdGVtcyIsInRvdGFsIiwiZW1haWxXaXRoU0VTIiwibWljcm9zb2Z0VGVhbXMiLCJzZW5kZXIiLCJzZXNTZW5kZXIiLCJzZW5kZXJzIiwic2VzU2VuZGVycyIsInJlY2lwaWVudEdyb3VwIiwicmVjaXBpZW50R3JvdXBzIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFTQSxNQUFNQSxTQUEwQixHQUFHO0FBQ2pDQyxFQUFBQSxJQUFJLEVBQUUsb0JBRDJCO0FBRWpDQyxFQUFBQSxXQUFXLEVBQUUsa0JBRm9CO0FBR2pDQyxFQUFBQSxXQUFXLEVBQUUsT0FIb0I7QUFJakNDLEVBQUFBLFVBQVUsRUFBRSxJQUpxQjtBQUtqQ0MsRUFBQUEsS0FBSyxFQUFFO0FBQ0xDLElBQUFBLEdBQUcsRUFBRTtBQURBLEdBTDBCO0FBUWpDQyxFQUFBQSxTQUFTLEVBQUUsWUFSc0I7QUFTakNDLEVBQUFBLGVBQWUsRUFBRSxhQVRnQjtBQVVqQ0MsRUFBQUEsb0JBQW9CLEVBQUU7QUFWVyxDQUFuQztBQWFBLE1BQU1DLFNBQTBCLEdBQUc7QUFDakNULEVBQUFBLElBQUksRUFBRSxvQkFEMkI7QUFFakNDLEVBQUFBLFdBQVcsRUFBRSxrQkFGb0I7QUFHakNDLEVBQUFBLFdBQVcsRUFBRSxPQUhvQjtBQUlqQ0MsRUFBQUEsVUFBVSxFQUFFLEtBSnFCO0FBS2pDTyxFQUFBQSxLQUFLLEVBQUU7QUFDTEwsSUFBQUEsR0FBRyxFQUFFO0FBREEsR0FMMEI7QUFRakNDLEVBQUFBLFNBQVMsRUFBRSxZQVJzQjtBQVNqQ0MsRUFBQUEsZUFBZSxFQUFFLGFBVGdCO0FBVWpDQyxFQUFBQSxvQkFBb0IsRUFBRTtBQVZXLENBQW5DO0FBYUEsTUFBTUcsU0FBMEIsR0FBRztBQUNqQ1gsRUFBQUEsSUFBSSxFQUFFLG9CQUQyQjtBQUVqQ0MsRUFBQUEsV0FBVyxFQUFFLGtCQUZvQjtBQUdqQ0MsRUFBQUEsV0FBVyxFQUFFLE9BSG9CO0FBSWpDQyxFQUFBQSxVQUFVLEVBQUUsSUFKcUI7QUFLakNTLEVBQUFBLEtBQUssRUFBRTtBQUNMQyxJQUFBQSxnQkFBZ0IsRUFBRSxzQkFEYjtBQUVMQyxJQUFBQSxjQUFjLEVBQUUsQ0FDZDtBQUFFQyxNQUFBQSxTQUFTLEVBQUU7QUFBYixLQURjLEVBRWQ7QUFBRUEsTUFBQUEsU0FBUyxFQUFFO0FBQWIsS0FGYyxFQUdkO0FBQUVBLE1BQUFBLFNBQVMsRUFBRTtBQUFiLEtBSGMsQ0FGWDtBQU9MQyxJQUFBQSxtQkFBbUIsRUFBRSxDQUNuQixzQkFEbUIsRUFFbkIsc0JBRm1CLEVBR25CLHNCQUhtQixFQUluQixzQkFKbUIsRUFLbkIsc0JBTG1CLEVBTW5CLHNCQU5tQixDQVBoQjtBQWVMQyxJQUFBQSxrQkFBa0IsRUFBRSxPQWZmO0FBZ0JMQyxJQUFBQSxrQkFBa0IsRUFBRTtBQUNsQiw4QkFBd0IsT0FETjtBQUVsQiw4QkFBd0IsT0FGTjtBQUdsQiw4QkFBd0IsT0FITjtBQUlsQiw4QkFBd0IsT0FKTjtBQUtsQiw4QkFBd0IsT0FMTjtBQU1sQiw4QkFBd0I7QUFOTixLQWhCZjtBQXdCTEMsSUFBQUEsV0FBVyxFQUFFLEVBeEJSO0FBeUJMQyxJQUFBQSxXQUFXLEVBQUU7QUF6QlIsR0FMMEI7QUFnQ2pDZCxFQUFBQSxTQUFTLEVBQUUsc0JBaENzQjtBQWlDakNDLEVBQUFBLGVBQWUsRUFBRSxhQWpDZ0I7QUFrQ2pDQyxFQUFBQSxvQkFBb0IsRUFBRTtBQWxDVyxDQUFuQztBQXFDQSxNQUFNYSxnQkFBaUMsR0FBRztBQUN4Q3JCLEVBQUFBLElBQUksRUFBRSxvQkFEa0M7QUFFeENDLEVBQUFBLFdBQVcsRUFBRSxrQkFGMkI7QUFHeENDLEVBQUFBLFdBQVcsRUFBRSxPQUgyQjtBQUl4Q0MsRUFBQUEsVUFBVSxFQUFFLElBSjRCO0FBS3hDUyxFQUFBQSxLQUFLLEVBQUU7QUFDTEMsSUFBQUEsZ0JBQWdCLEVBQUUsc0JBRGI7QUFFTEMsSUFBQUEsY0FBYyxFQUFFLENBQ2Q7QUFBRUMsTUFBQUEsU0FBUyxFQUFFO0FBQWIsS0FEYyxFQUVkO0FBQUVBLE1BQUFBLFNBQVMsRUFBRTtBQUFiLEtBRmMsRUFHZDtBQUFFQSxNQUFBQSxTQUFTLEVBQUU7QUFBYixLQUhjLENBRlg7QUFPTEMsSUFBQUEsbUJBQW1CLEVBQUUsQ0FDbkIsc0JBRG1CLEVBRW5CLHNCQUZtQixFQUduQixzQkFIbUIsRUFJbkIsc0JBSm1CLEVBS25CLHNCQUxtQixFQU1uQixzQkFObUIsQ0FQaEI7QUFlTEMsSUFBQUEsa0JBQWtCLEVBQUUsT0FmZjtBQWdCTEMsSUFBQUEsa0JBQWtCLEVBQUU7QUFDbEIsOEJBQXdCLE9BRE47QUFFbEIsOEJBQXdCLE9BRk47QUFHbEIsOEJBQXdCLE9BSE47QUFJbEIsOEJBQXdCLE9BSk47QUFLbEIsOEJBQXdCLE9BTE47QUFNbEIsOEJBQXdCO0FBTk4sS0FoQmY7QUF3QkxDLElBQUFBLFdBQVcsRUFBRSxDQUFDLHNCQUFELENBeEJSO0FBeUJMQyxJQUFBQSxXQUFXLEVBQUU7QUF6QlIsR0FMaUM7QUFnQ3hDZCxFQUFBQSxTQUFTLEVBQUUsc0JBaEM2QjtBQWlDeENDLEVBQUFBLGVBQWUsRUFBRSxhQWpDdUI7QUFrQ3hDQyxFQUFBQSxvQkFBb0IsRUFBRTtBQWxDa0IsQ0FBMUM7QUFxQ0EsTUFBTWMsV0FBNEIsR0FBRztBQUNuQ3RCLEVBQUFBLElBQUksRUFBRSxzQkFENkI7QUFFbkNDLEVBQUFBLFdBQVcsRUFBRSxrQkFGc0I7QUFHbkNDLEVBQUFBLFdBQVcsRUFBRSxTQUhzQjtBQUluQ0MsRUFBQUEsVUFBVSxFQUFFLElBSnVCO0FBS25Db0IsRUFBQUEsT0FBTyxFQUFFO0FBQ1BsQixJQUFBQSxHQUFHLEVBQUUscURBREU7QUFFUG1CLElBQUFBLGFBQWEsRUFBRTtBQUNiQyxNQUFBQSxJQUFJLEVBQUUsUUFETztBQUViQyxNQUFBQSxJQUFJLEVBQUUsUUFGTztBQUdiQyxNQUFBQSxJQUFJLEVBQUUsRUFITztBQUliQyxNQUFBQSxJQUFJLEVBQUUsUUFKTztBQUtiQyxNQUFBQSxJQUFJLEVBQUUsUUFMTztBQU1iQyxNQUFBQSxJQUFJLEVBQUU7QUFOTyxLQUZSO0FBVVBDLElBQUFBLE1BQU0sRUFBRTtBQVZELEdBTDBCO0FBaUJuQ3pCLEVBQUFBLFNBQVMsRUFBRSxzQkFqQndCO0FBa0JuQ0MsRUFBQUEsZUFBZSxFQUFFLGFBbEJrQjtBQW1CbkNDLEVBQUFBLG9CQUFvQixFQUFFO0FBbkJhLENBQXJDO0FBc0JBLE1BQU13QixPQUF3QixHQUFHO0FBQy9CaEMsRUFBQUEsSUFBSSxFQUFFLGtCQUR5QjtBQUUvQkMsRUFBQUEsV0FBVyxFQUFFLGtCQUZrQjtBQUcvQkMsRUFBQUEsV0FBVyxFQUFFLEtBSGtCO0FBSS9CQyxFQUFBQSxVQUFVLEVBQUUsSUFKbUI7QUFLL0I4QixFQUFBQSxHQUFHLEVBQUU7QUFDSEMsSUFBQUEsU0FBUyxFQUFFLHVEQURSO0FBRUhDLElBQUFBLFFBQVEsRUFBRTtBQUZQLEdBTDBCO0FBUy9CN0IsRUFBQUEsU0FBUyxFQUFFLHNCQVRvQjtBQVUvQkMsRUFBQUEsZUFBZSxFQUFFLGFBVmM7QUFXL0JDLEVBQUFBLG9CQUFvQixFQUFFO0FBWFMsQ0FBakM7QUFjQSxNQUFNNEIsVUFBMEIsR0FBRztBQUNqQ3BDLEVBQUFBLElBQUksRUFBRSxhQUQyQjtBQUVqQ0MsRUFBQUEsV0FBVyxFQUFFLGtCQUZvQjtBQUdqQ0ssRUFBQUEsU0FBUyxFQUFFLHNCQUhzQjtBQUlqQ0MsRUFBQUEsZUFBZSxFQUFFLGFBSmdCO0FBS2pDQyxFQUFBQSxvQkFBb0IsRUFBRSxhQUxXO0FBTWpDNkIsRUFBQUEsWUFBWSxFQUFFO0FBQ1pDLElBQUFBLElBQUksRUFBRSxhQURNO0FBRVpDLElBQUFBLElBQUksRUFBRSxJQUZNO0FBR1pSLElBQUFBLE1BQU0sRUFBRSxXQUhJO0FBSVpTLElBQUFBLFlBQVksRUFBRTtBQUpGO0FBTm1CLENBQW5DO0FBY0EsTUFBTUMsa0JBQW1DLEdBQUc7QUFDMUN6QyxFQUFBQSxJQUFJLEVBQUUsOEJBRG9DO0FBRTFDQyxFQUFBQSxXQUFXLEVBQUUsa0JBRjZCO0FBRzFDQyxFQUFBQSxXQUFXLEVBQUUsaUJBSDZCO0FBSTFDQyxFQUFBQSxVQUFVLEVBQUUsS0FKOEI7QUFLMUN1QyxFQUFBQSxlQUFlLEVBQUU7QUFDZnJDLElBQUFBLEdBQUcsRUFBRTtBQURVLEdBTHlCO0FBUTFDQyxFQUFBQSxTQUFTLEVBQUUsWUFSK0I7QUFTMUNDLEVBQUFBLGVBQWUsRUFBRSxhQVR5QjtBQVUxQ0MsRUFBQUEsb0JBQW9CLEVBQUU7QUFWb0IsQ0FBNUM7QUFhQSxNQUFNbUMsYUFBZ0MsR0FBRztBQUN2QzNDLEVBQUFBLElBQUksRUFBRSxpQkFEaUM7QUFFdkNDLEVBQUFBLFdBQVcsRUFBRSxrQkFGMEI7QUFHdkNLLEVBQUFBLFNBQVMsRUFBRSxzQkFINEI7QUFJdkNDLEVBQUFBLGVBQWUsRUFBRSxhQUpzQjtBQUt2Q0MsRUFBQUEsb0JBQW9CLEVBQUUsYUFMaUI7QUFNdkNvQyxFQUFBQSxXQUFXLEVBQUU7QUFDWEosSUFBQUEsWUFBWSxFQUFFLGtCQURIO0FBRVhLLElBQUFBLE1BQU0sRUFBRSxXQUZHO0FBR1hWLElBQUFBLFFBQVEsRUFBRTtBQUhDO0FBTjBCLENBQXpDO0FBYUEsTUFBTVcsa0JBQTBDLEdBQUc7QUFDakQ5QyxFQUFBQSxJQUFJLEVBQUUsc0JBRDJDO0FBRWpEQyxFQUFBQSxXQUFXLEVBQUUsa0JBRm9DO0FBR2pESyxFQUFBQSxTQUFTLEVBQUUsc0JBSHNDO0FBSWpEQyxFQUFBQSxlQUFlLEVBQUUsYUFKZ0M7QUFLakRDLEVBQUFBLG9CQUFvQixFQUFFLGFBTDJCO0FBTWpEdUMsRUFBQUEsV0FBVyxFQUFFO0FBQ1hqQyxJQUFBQSxjQUFjLEVBQUUsQ0FDZDtBQUFFQyxNQUFBQSxTQUFTLEVBQUU7QUFBYixLQURjLEVBRWQ7QUFBRUEsTUFBQUEsU0FBUyxFQUFFO0FBQWIsS0FGYyxFQUdkO0FBQUVBLE1BQUFBLFNBQVMsRUFBRTtBQUFiLEtBSGMsRUFJZDtBQUFFQSxNQUFBQSxTQUFTLEVBQUU7QUFBYixLQUpjLEVBS2Q7QUFBRUEsTUFBQUEsU0FBUyxFQUFFO0FBQWIsS0FMYyxFQU1kO0FBQUVBLE1BQUFBLFNBQVMsRUFBRTtBQUFiLEtBTmM7QUFETDtBQU5vQyxDQUFuRDtBQW9CTyxNQUFNaUMsU0FBUyxHQUFHO0FBQ3ZCQyxFQUFBQSxRQUFRLEVBQUU7QUFDUkMsSUFBQUEsS0FBSyxFQUFFLENBQ0xuRCxTQURLLEVBRUxVLFNBRkssRUFHTEUsU0FISyxFQUlMVSxnQkFKSyxFQUtMQyxXQUxLLEVBTUxVLE9BTkssRUFPTFMsa0JBUEssQ0FEQztBQVVSVSxJQUFBQSxLQUFLLEVBQUU7QUFWQyxHQURhO0FBYXZCL0MsRUFBQUEsS0FBSyxFQUFFTCxTQWJnQjtBQWN2QlcsRUFBQUEsS0FBSyxFQUFFRCxTQWRnQjtBQWV2QkcsRUFBQUEsS0FBSyxFQUFFRCxTQWZnQjtBQWdCdkJ5QyxFQUFBQSxZQUFZLEVBQUUvQixnQkFoQlM7QUFpQnZCRSxFQUFBQSxPQUFPLEVBQUVELFdBakJjO0FBa0J2QlcsRUFBQUEsR0FBRyxFQUFFRCxPQWxCa0I7QUFtQnZCcUIsRUFBQUEsY0FBYyxFQUFFWixrQkFuQk87QUFvQnZCYSxFQUFBQSxNQUFNLEVBQUVsQixVQXBCZTtBQXFCdkJtQixFQUFBQSxTQUFTLEVBQUVaLGFBckJZO0FBc0J2QmEsRUFBQUEsT0FBTyxFQUFFO0FBQ1BOLElBQUFBLEtBQUssRUFBRSxDQUFDZCxVQUFELENBREE7QUFFUGUsSUFBQUEsS0FBSyxFQUFFO0FBRkEsR0F0QmM7QUEwQnZCTSxFQUFBQSxVQUFVLEVBQUU7QUFDVlAsSUFBQUEsS0FBSyxFQUFFLENBQUNQLGFBQUQsQ0FERztBQUVWUSxJQUFBQSxLQUFLLEVBQUU7QUFGRyxHQTFCVztBQThCdkJPLEVBQUFBLGNBQWMsRUFBRVosa0JBOUJPO0FBK0J2QmEsRUFBQUEsZUFBZSxFQUFFO0FBQ2ZULElBQUFBLEtBQUssRUFBRSxDQUFDSixrQkFBRCxDQURRO0FBRWZLLElBQUFBLEtBQUssRUFBRTtBQUZRO0FBL0JNLENBQWxCIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQge1xuICBDaGFubmVsSXRlbVR5cGUsXG4gIFJlY2lwaWVudEdyb3VwSXRlbVR5cGUsXG4gIFNlbmRlckl0ZW1UeXBlLFxuICBTRVNTZW5kZXJJdGVtVHlwZSxcbn0gZnJvbSAnLi4vLi4vbW9kZWxzL2ludGVyZmFjZXMnO1xuXG5jb25zdCBtb2NrQ2hpbWU6IENoYW5uZWxJdGVtVHlwZSA9IHtcbiAgbmFtZTogJ0NoaW1lIHRlc3QgY2hhbm5lbCcsXG4gIGRlc2NyaXB0aW9uOiAndGVzdCBkZXNjcmlwdGlvbicsXG4gIGNvbmZpZ190eXBlOiAnY2hpbWUnLFxuICBpc19lbmFibGVkOiB0cnVlLFxuICBjaGltZToge1xuICAgIHVybDogJ2h0dHBzOi8vY2hpbWVob29rJyxcbiAgfSxcbiAgY29uZmlnX2lkOiAndGVzdC1jaGltZScsXG4gIGNyZWF0ZWRfdGltZV9tczogMTYyMjY3MDQ1MTg5MSxcbiAgbGFzdF91cGRhdGVkX3RpbWVfbXM6IDE2MjI2NzA0NTE4OTEsXG59O1xuXG5jb25zdCBtb2NrU2xhY2s6IENoYW5uZWxJdGVtVHlwZSA9IHtcbiAgbmFtZTogJ1NsYWNrIHRlc3QgY2hhbm5lbCcsXG4gIGRlc2NyaXB0aW9uOiAndGVzdCBkZXNjcmlwdGlvbicsXG4gIGNvbmZpZ190eXBlOiAnc2xhY2snLFxuICBpc19lbmFibGVkOiBmYWxzZSxcbiAgc2xhY2s6IHtcbiAgICB1cmw6ICdodHRwczovL2NoaW1laG9vaycsXG4gIH0sXG4gIGNvbmZpZ19pZDogJ3Rlc3Qtc2xhY2snLFxuICBjcmVhdGVkX3RpbWVfbXM6IDE2MjI2NzA0NTE4OTEsXG4gIGxhc3RfdXBkYXRlZF90aW1lX21zOiAxNjIyNjcwNDUxODkxLFxufTtcblxuY29uc3QgbW9ja0VtYWlsOiBDaGFubmVsSXRlbVR5cGUgPSB7XG4gIG5hbWU6ICdFbWFpbCB0ZXN0IGNoYW5uZWwnLFxuICBkZXNjcmlwdGlvbjogJ3Rlc3QgZGVzY3JpcHRpb24nLFxuICBjb25maWdfdHlwZTogJ2VtYWlsJyxcbiAgaXNfZW5hYmxlZDogdHJ1ZSxcbiAgZW1haWw6IHtcbiAgICBlbWFpbF9hY2NvdW50X2lkOiAnZGo4ZXRYa0JDelZ5OVZ5LW5zaUwnLFxuICAgIHJlY2lwaWVudF9saXN0OiBbXG4gICAgICB7IHJlY2lwaWVudDogJ2N1c3RvbUBlbWFpbC5jb20nIH0sXG4gICAgICB7IHJlY2lwaWVudDogJ2VtYWlsQHRlc3QuY29tJyB9LFxuICAgICAgeyByZWNpcGllbnQ6ICd0ZXN0QGVtYWlsLmNvbScgfSxcbiAgICBdLFxuICAgIGVtYWlsX2dyb3VwX2lkX2xpc3Q6IFtcbiAgICAgICcxbDhocTNrQjBYd2lCbEViYW5TbycsXG4gICAgICAnZHo4ZXRYa0JDelZ5OVZ5LTBzZ2gnLFxuICAgICAgJ2VEOGt0WGtCQ3pWeTlWeS1BOGotJyxcbiAgICAgICcxVjhncTNrQjBYd2lCbEViQVhTSScsXG4gICAgICAnZERfOHRIa0JDelZ5OVZ5LTVzaTAnLFxuICAgICAgJzUyWEdyM2tCcUZqV3Jtdkw0M212JyxcbiAgICBdLFxuICAgIGVtYWlsX2FjY291bnRfbmFtZTogJ25hbWUxJyxcbiAgICBlbWFpbF9ncm91cF9pZF9tYXA6IHtcbiAgICAgICcxbDhocTNrQjBYd2lCbEViYW5Tbyc6ICduYW1lMScsXG4gICAgICAnZHo4ZXRYa0JDelZ5OVZ5LTBzZ2gnOiAnbmFtZTInLFxuICAgICAgJ2VEOGt0WGtCQ3pWeTlWeS1BOGotJzogJ25hbWUzJyxcbiAgICAgICcxVjhncTNrQjBYd2lCbEViQVhTSSc6ICduYW1lNCcsXG4gICAgICAnZERfOHRIa0JDelZ5OVZ5LTVzaTAnOiAnbmFtZTUnLFxuICAgICAgJzUyWEdyM2tCcUZqV3Jtdkw0M212JzogJ25hbWU2JyxcbiAgICB9LFxuICAgIGludmFsaWRfaWRzOiBbXSxcbiAgICBzZW5kZXJfdHlwZTogJ3NtdHBfYWNjb3VudCcsXG4gIH0sXG4gIGNvbmZpZ19pZDogJ0RNRzN6WGtCUGE2WUZ4bVZmTm1tJyxcbiAgY3JlYXRlZF90aW1lX21zOiAxNjIyNjU0MDI0ODYxLFxuICBsYXN0X3VwZGF0ZWRfdGltZV9tczogMTYyMjY1NjY2NTY3NCxcbn07XG5cbmNvbnN0IG1vY2tFbWFpbFdpdGhTRVM6IENoYW5uZWxJdGVtVHlwZSA9IHtcbiAgbmFtZTogJ0VtYWlsIHRlc3QgY2hhbm5lbCcsXG4gIGRlc2NyaXB0aW9uOiAndGVzdCBkZXNjcmlwdGlvbicsXG4gIGNvbmZpZ190eXBlOiAnZW1haWwnLFxuICBpc19lbmFibGVkOiB0cnVlLFxuICBlbWFpbDoge1xuICAgIGVtYWlsX2FjY291bnRfaWQ6ICdkajhldFhrQkN6Vnk5VnktbnNpTCcsXG4gICAgcmVjaXBpZW50X2xpc3Q6IFtcbiAgICAgIHsgcmVjaXBpZW50OiAnY3VzdG9tQGVtYWlsLmNvbScgfSxcbiAgICAgIHsgcmVjaXBpZW50OiAnZW1haWxAdGVzdC5jb20nIH0sXG4gICAgICB7IHJlY2lwaWVudDogJ3Rlc3RAZW1haWwuY29tJyB9LFxuICAgIF0sXG4gICAgZW1haWxfZ3JvdXBfaWRfbGlzdDogW1xuICAgICAgJzF5OHVkM3hPMEtqdk95Um9uYUZiJyxcbiAgICAgICdxbThyZ0t4T1BtSWw5SWwtMGZ0dScsXG4gICAgICAnclE4eGdLeE9QbUlsOUlsLU44dy0nLFxuICAgICAgJzFJOHRkM3hPMEtqdk95Um9OS0ZWJyxcbiAgICAgICdxUV84Z1V4T1BtSWw5SWwtNWZ2MCcsXG4gICAgICAnNTJLVGUzeE9kU3dKZXppWTQzemknLFxuICAgIF0sXG4gICAgZW1haWxfYWNjb3VudF9uYW1lOiAnbmFtZTEnLFxuICAgIGVtYWlsX2dyb3VwX2lkX21hcDoge1xuICAgICAgJzF5OHVkM3hPMEtqdk95Um9uYUZiJzogJ25hbWUxJyxcbiAgICAgICdxbThyZ0t4T1BtSWw5SWwtMGZ0dSc6ICduYW1lMicsXG4gICAgICAnclE4eGdLeE9QbUlsOUlsLU44dy0nOiAnbmFtZTMnLFxuICAgICAgJzFJOHRkM3hPMEtqdk95Um9OS0ZWJzogJ25hbWU0JyxcbiAgICAgICdxUV84Z1V4T1BtSWw5SWwtNWZ2MCc6ICduYW1lNScsXG4gICAgICAnNTJLVGUzeE9kU3dKZXppWTQzemknOiAnbmFtZTYnLFxuICAgIH0sXG4gICAgaW52YWxpZF9pZHM6IFsnNTJLVGUzeE9kU3dKZXppWTQzemknXSxcbiAgICBzZW5kZXJfdHlwZTogJ3Nlc19hY2NvdW50JyxcbiAgfSxcbiAgY29uZmlnX2lkOiAnUVpUM21LeE9DbjZMU2t6SXNBenonLFxuICBjcmVhdGVkX3RpbWVfbXM6IDE2MjI2NTQwMjQ4NjEsXG4gIGxhc3RfdXBkYXRlZF90aW1lX21zOiAxNjIyNjU2NjY1Njc0LFxufTtcblxuY29uc3QgbW9ja1dlYmhvb2s6IENoYW5uZWxJdGVtVHlwZSA9IHtcbiAgbmFtZTogJ1dlYmhvb2sgdGVzdCBjaGFubmVsJyxcbiAgZGVzY3JpcHRpb246ICd0ZXN0IGRlc2NyaXB0aW9uJyxcbiAgY29uZmlnX3R5cGU6ICd3ZWJob29rJyxcbiAgaXNfZW5hYmxlZDogdHJ1ZSxcbiAgd2ViaG9vazoge1xuICAgIHVybDogJ2h0dHBzOi8vaG9zdDoyMy9wYXRoP2tleTE9JTIzJTQwNCZrZXkyPSZrZXkzPXZhbHVlMycsXG4gICAgaGVhZGVyX3BhcmFtczoge1xuICAgICAga2V5MTogJ3ZhbHVlMScsXG4gICAgICBrZXkyOiAndmFsdWUyJyxcbiAgICAgIGtleTM6ICcnLFxuICAgICAga2V5NDogJ3ZhbHVlNCcsXG4gICAgICBrZXk1OiAndmFsdWU1JyxcbiAgICAgIGtleTY6ICd2YWx1ZTYnLFxuICAgIH0sXG4gICAgbWV0aG9kOiAnUE9TVCcsXG4gIH0sXG4gIGNvbmZpZ19pZDogJzdtVWpzSGtCcUZqV3JtdkxjM25sJyxcbiAgY3JlYXRlZF90aW1lX21zOiAxNjIyMTU3Nzg0MDM3LFxuICBsYXN0X3VwZGF0ZWRfdGltZV9tczogMTYyMjU4MTA4NDA1MCxcbn07XG5cbmNvbnN0IG1vY2tTTlM6IENoYW5uZWxJdGVtVHlwZSA9IHtcbiAgbmFtZTogJ1NOUyB0ZXN0IGNoYW5uZWwnLFxuICBkZXNjcmlwdGlvbjogJ3Rlc3QgZGVzY3JpcHRpb24nLFxuICBjb25maWdfdHlwZTogJ3NucycsXG4gIGlzX2VuYWJsZWQ6IHRydWUsXG4gIHNuczoge1xuICAgIHRvcGljX2FybjogJ2Fybjphd3M6c25zOnVzLXdlc3QtMjowMTIzNDU2Nzg5MTI6bm90aWZpY2F0aW9ucy10ZXN0JyxcbiAgICByb2xlX2FybjogJ2Fybjphd3M6aWFtOjowMTIzNDU2Nzg5MTI6cm9sZS9Ob3RpZmljYXRpb25zU05TUm9sZScsXG4gIH0sXG4gIGNvbmZpZ19pZDogJ2VyQ0RZSHNCVU1STEM1UFpYZlBOJyxcbiAgY3JlYXRlZF90aW1lX21zOiAxNjIyMTU3Nzg0MDM3LFxuICBsYXN0X3VwZGF0ZWRfdGltZV9tczogMTYyMjU4MTA4NDA1MCxcbn07XG5cbmNvbnN0IG1vY2tTZW5kZXI6IFNlbmRlckl0ZW1UeXBlID0ge1xuICBuYW1lOiAndGVzdC1zZW5kZXInLFxuICBkZXNjcmlwdGlvbjogJ3Rlc3QgZGVzY3JpcHRpb24nLFxuICBjb25maWdfaWQ6ICc3MlV5c0hrQnFGaldybXZMRlhrQicsXG4gIGNyZWF0ZWRfdGltZV9tczogMTYyMjE1ODc0Mjc4NCxcbiAgbGFzdF91cGRhdGVkX3RpbWVfbXM6IDE2MjIxNTg3NDI3ODQsXG4gIHNtdHBfYWNjb3VudDoge1xuICAgIGhvc3Q6ICdleGFtcGxlLmNvbScsXG4gICAgcG9ydDogJzIzJyxcbiAgICBtZXRob2Q6ICdzdGFydF90bHMnLFxuICAgIGZyb21fYWRkcmVzczogJ3NhbXBsZUBlbWFpbC5jb20nLFxuICB9LFxufTtcblxuY29uc3QgbW9ja01pY3Jvc29mdFRlYW1zOiBDaGFubmVsSXRlbVR5cGUgPSB7XG4gIG5hbWU6ICdNaWNyb3NvZnQgVGVhbXMgdGVzdCBjaGFubmVsJyxcbiAgZGVzY3JpcHRpb246ICd0ZXN0IGRlc2NyaXB0aW9uJyxcbiAgY29uZmlnX3R5cGU6ICdtaWNyb3NvZnRfdGVhbXMnLFxuICBpc19lbmFibGVkOiBmYWxzZSxcbiAgbWljcm9zb2Z0X3RlYW1zOiB7XG4gICAgdXJsOiAnaHR0cHM6Ly9jaGltZWhvb2snLFxuICB9LFxuICBjb25maWdfaWQ6ICd0ZXN0LXNsYWNrJyxcbiAgY3JlYXRlZF90aW1lX21zOiAxNjIyNjcwNDUxODkxLFxuICBsYXN0X3VwZGF0ZWRfdGltZV9tczogMTYyMjY3MDQ1MTg5MSxcbn07XG5cbmNvbnN0IG1vY2tTRVNTZW5kZXI6IFNFU1NlbmRlckl0ZW1UeXBlID0ge1xuICBuYW1lOiAndGVzdC1zZXMtc2VuZGVyJyxcbiAgZGVzY3JpcHRpb246ICd0ZXN0IGRlc2NyaXB0aW9uJyxcbiAgY29uZmlnX2lkOiAnNzJIbGZVeE9kU3dKZXppWVNLeE8nLFxuICBjcmVhdGVkX3RpbWVfbXM6IDE2MjIxNTg3NDI3ODQsXG4gIGxhc3RfdXBkYXRlZF90aW1lX21zOiAxNjIyMTU4NzQyNzg0LFxuICBzZXNfYWNjb3VudDoge1xuICAgIGZyb21fYWRkcmVzczogJ3NhbXBsZUBlbWFpbC5jb20nLFxuICAgIHJlZ2lvbjogJ3VzLXdlc3QtMicsXG4gICAgcm9sZV9hcm46ICdhcm46YXdzOmlhbTo6MDEyMzQ1Njc4OTEyOnJvbGUvVGVzdE5vdGlmaWNhdGlvbnNTRVNSb2xlJyxcbiAgfSxcbn07XG5cbmNvbnN0IG1vY2tSZWNpcGllbnRHcm91cDogUmVjaXBpZW50R3JvdXBJdGVtVHlwZSA9IHtcbiAgbmFtZTogJ1Rlc3QgcmVjaXBpZW50IGdyb3VwJyxcbiAgZGVzY3JpcHRpb246ICd0ZXN0IGRlc2NyaXB0aW9uJyxcbiAgY29uZmlnX2lkOiAnNzJVeXNIa0JxVmpXcm12TEZYa0InLFxuICBjcmVhdGVkX3RpbWVfbXM6IDE2MjIxNTg3NDI3ODQsXG4gIGxhc3RfdXBkYXRlZF90aW1lX21zOiAxNjIyMTU4NzQyNzg0LFxuICBlbWFpbF9ncm91cDoge1xuICAgIHJlY2lwaWVudF9saXN0OiBbXG4gICAgICB7IHJlY2lwaWVudDogJ3Rlc3QxQGVtYWlsLmNvbScgfSxcbiAgICAgIHsgcmVjaXBpZW50OiAndGVzdDJAZW1haWwuY29tJyB9LFxuICAgICAgeyByZWNpcGllbnQ6ICd0ZXN0M0BlbWFpbC5jb20nIH0sXG4gICAgICB7IHJlY2lwaWVudDogJ3Rlc3Q0QGVtYWlsLmNvbScgfSxcbiAgICAgIHsgcmVjaXBpZW50OiAndGVzdDVAZW1haWwuY29tJyB9LFxuICAgICAgeyByZWNpcGllbnQ6ICd0ZXN0NkBlbWFpbC5jb20nIH0sXG4gICAgXSxcbiAgfSxcbn07XG5cblxuXG5leHBvcnQgY29uc3QgTU9DS19EQVRBID0ge1xuICBjaGFubmVsczoge1xuICAgIGl0ZW1zOiBbXG4gICAgICBtb2NrQ2hpbWUsXG4gICAgICBtb2NrU2xhY2ssXG4gICAgICBtb2NrRW1haWwsXG4gICAgICBtb2NrRW1haWxXaXRoU0VTLFxuICAgICAgbW9ja1dlYmhvb2ssXG4gICAgICBtb2NrU05TLFxuICAgICAgbW9ja01pY3Jvc29mdFRlYW1zXG4gICAgXSxcbiAgICB0b3RhbDogN1xuICB9LFxuICBjaGltZTogbW9ja0NoaW1lLFxuICBzbGFjazogbW9ja1NsYWNrLFxuICBlbWFpbDogbW9ja0VtYWlsLFxuICBlbWFpbFdpdGhTRVM6IG1vY2tFbWFpbFdpdGhTRVMsXG4gIHdlYmhvb2s6IG1vY2tXZWJob29rLFxuICBzbnM6IG1vY2tTTlMsXG4gIG1pY3Jvc29mdFRlYW1zOiBtb2NrTWljcm9zb2Z0VGVhbXMsXG4gIHNlbmRlcjogbW9ja1NlbmRlcixcbiAgc2VzU2VuZGVyOiBtb2NrU0VTU2VuZGVyLFxuICBzZW5kZXJzOiB7XG4gICAgaXRlbXM6IFttb2NrU2VuZGVyXSxcbiAgICB0b3RhbDogMSxcbiAgfSxcbiAgc2VzU2VuZGVyczoge1xuICAgIGl0ZW1zOiBbbW9ja1NFU1NlbmRlcl0sXG4gICAgdG90YWw6IDEsXG4gIH0sXG4gIHJlY2lwaWVudEdyb3VwOiBtb2NrUmVjaXBpZW50R3JvdXAsXG4gIHJlY2lwaWVudEdyb3Vwczoge1xuICAgIGl0ZW1zOiBbbW9ja1JlY2lwaWVudEdyb3VwXSxcbiAgICB0b3RhbDogMSxcbiAgfSxcbn07XG4iXX0=