/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Function;
import org.jboss.resteasy.cdi.i18n.LogMessages;
import org.jboss.resteasy.cdi.i18n.Messages;
import org.jboss.resteasy.core.PropertyInjectorImpl;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.util.Types;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;
import org.jboss.resteasy.util.GetRestful;

public class JaxrsInjectionTarget<T>
implements InjectionTarget<T> {
    private final InjectionTarget<T> delegate;
    private final Class<T> clazz;
    private PropertyInjector propertyInjector;
    private final boolean hasPostConstruct;
    private static final Function<Method, Boolean> validatePostConstructParameters = m -> {
        if (m.getParameterCount() == 0) {
            return true;
        }
        return m.getParameterCount() == 1 && InvocationContext.class.equals(m.getParameterTypes()[0]) && m.getAnnotation(AroundInvoke.class) != null;
    };

    public JaxrsInjectionTarget(InjectionTarget<T> delegate, Class<T> clazz) {
        this.delegate = delegate;
        this.clazz = clazz;
        this.hasPostConstruct = Types.hasPostConstruct(clazz, validatePostConstructParameters);
    }

    public void inject(T instance, CreationalContext<T> ctx) {
        this.delegate.inject(instance, ctx);
        if (this.propertyInjector == null) {
            this.propertyInjector = this.getPropertyInjector();
        }
        HttpRequest request = (HttpRequest)ResteasyContext.getContextData(HttpRequest.class);
        HttpResponse response = (HttpResponse)ResteasyContext.getContextData(HttpResponse.class);
        if (request != null && response != null) {
            this.propertyInjector.inject(request, response, instance, false);
        } else {
            this.propertyInjector.inject(instance, false);
        }
        if (request != null && !this.hasPostConstruct) {
            this.validate(request, instance);
        } else {
            LogMessages.LOGGER.debug(Messages.MESSAGES.skippingValidationOutsideResteasyContext());
        }
    }

    public void postConstruct(T instance) {
        this.delegate.postConstruct(instance);
        if (this.hasPostConstruct) {
            HttpRequest request = (HttpRequest)ResteasyContext.getContextData(HttpRequest.class);
            if (request != null) {
                this.validate(request, instance);
            } else {
                LogMessages.LOGGER.debug(Messages.MESSAGES.skippingValidationOutsideResteasyContext());
            }
        }
    }

    public void preDestroy(T instance) {
        this.delegate.preDestroy(instance);
    }

    public void dispose(T instance) {
        this.delegate.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.delegate.getInjectionPoints();
    }

    public T produce(CreationalContext<T> ctx) {
        return (T)this.delegate.produce(ctx);
    }

    private PropertyInjector getPropertyInjector() {
        return new PropertyInjectorImpl(this.clazz, ResteasyProviderFactory.getInstance());
    }

    private void validate(HttpRequest request, T instance) {
        if (GetRestful.isRootResource(this.clazz)) {
            ResteasyProviderFactory providerFactory = ResteasyProviderFactory.getInstance();
            ContextResolver resolver = providerFactory.getContextResolver(GeneralValidatorCDI.class, MediaType.WILDCARD_TYPE);
            GeneralValidatorCDI validator = null;
            if (resolver != null) {
                validator = (GeneralValidatorCDI)providerFactory.getContextResolver(GeneralValidatorCDI.class, MediaType.WILDCARD_TYPE).getContext(null);
            }
            if (validator != null && validator.isValidatableFromCDI(this.clazz)) {
                validator.validate(request, instance, new Class[0]);
                validator.checkViolationsfromCDI(request);
            }
        }
    }
}

