/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TypedQuery;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SharedSessionContract;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.query.BindableType;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.transform.ResultTransformer;

@Incubating
public interface Query<R>
extends SelectionQuery<R>,
MutationQuery,
TypedQuery<R> {
    @Override
    public List<R> list();

    @Override
    default public List<R> getResultList() {
        return this.list();
    }

    @Override
    public ScrollableResults<R> scroll();

    @Override
    public ScrollableResults<R> scroll(ScrollMode var1);

    @Override
    default public Stream<R> getResultStream() {
        return this.stream();
    }

    @Override
    default public Stream<R> stream() {
        return this.getResultStream();
    }

    @Override
    public R uniqueResult();

    @Override
    public R getSingleResult();

    @Override
    public Optional<R> uniqueResultOptional();

    @Override
    public int executeUpdate();

    public SharedSessionContract getSession();

    public String getQueryString();

    public Query<R> applyGraph(RootGraph var1, GraphSemantic var2);

    default public Query<R> applyFetchGraph(RootGraph graph) {
        return this.applyGraph(graph, GraphSemantic.FETCH);
    }

    default public Query<R> applyLoadGraph(RootGraph graph) {
        return this.applyGraph(graph, GraphSemantic.LOAD);
    }

    @Override
    public String getComment();

    @Override
    public Query<R> setComment(String var1);

    public Query<R> addQueryHint(String var1);

    @Override
    public LockOptions getLockOptions();

    public Query<R> setLockOptions(LockOptions var1);

    @Override
    public Query<R> setLockMode(String var1, LockMode var2);

    public <T> Query<T> setTupleTransformer(TupleTransformer<T> var1);

    public Query<R> setResultListTransformer(ResultListTransformer<R> var1);

    public QueryOptions getQueryOptions();

    public ParameterMetadata getParameterMetadata();

    @Override
    public Query<R> setParameter(String var1, Object var2);

    @Override
    public <P> Query<R> setParameter(String var1, P var2, Class<P> var3);

    @Override
    public <P> Query<R> setParameter(String var1, P var2, BindableType<P> var3);

    @Override
    public Query<R> setParameter(String var1, Instant var2, TemporalType var3);

    @Override
    public Query<R> setParameter(String var1, Calendar var2, TemporalType var3);

    @Override
    public Query<R> setParameter(String var1, Date var2, TemporalType var3);

    @Override
    public Query<R> setParameter(int var1, Object var2);

    @Override
    public <P> Query<R> setParameter(int var1, P var2, Class<P> var3);

    @Override
    public <P> Query<R> setParameter(int var1, P var2, BindableType<P> var3);

    @Override
    public Query<R> setParameter(int var1, Instant var2, TemporalType var3);

    @Override
    public Query<R> setParameter(int var1, Date var2, TemporalType var3);

    @Override
    public Query<R> setParameter(int var1, Calendar var2, TemporalType var3);

    @Override
    public <T> Query<R> setParameter(QueryParameter<T> var1, T var2);

    @Override
    public <P> Query<R> setParameter(QueryParameter<P> var1, P var2, Class<P> var3);

    @Override
    public <P> Query<R> setParameter(QueryParameter<P> var1, P var2, BindableType<P> var3);

    @Override
    public <T> Query<R> setParameter(Parameter<T> var1, T var2);

    @Override
    public Query<R> setParameter(Parameter<Calendar> var1, Calendar var2, TemporalType var3);

    @Override
    public Query<R> setParameter(Parameter<Date> var1, Date var2, TemporalType var3);

    @Override
    public Query<R> setParameterList(String var1, Collection var2);

    @Override
    public <P> Query<R> setParameterList(String var1, Collection<? extends P> var2, Class<P> var3);

    @Override
    public <P> Query<R> setParameterList(String var1, Collection<? extends P> var2, BindableType<P> var3);

    @Override
    public Query<R> setParameterList(String var1, Object[] var2);

    @Override
    public <P> Query<R> setParameterList(String var1, P[] var2, Class<P> var3);

    @Override
    public <P> Query<R> setParameterList(String var1, P[] var2, BindableType<P> var3);

    @Override
    public Query<R> setParameterList(int var1, Collection var2);

    @Override
    public <P> Query<R> setParameterList(int var1, Collection<? extends P> var2, Class<P> var3);

    @Override
    public <P> Query<R> setParameterList(int var1, Collection<? extends P> var2, BindableType<P> var3);

    @Override
    public Query<R> setParameterList(int var1, Object[] var2);

    @Override
    public <P> Query<R> setParameterList(int var1, P[] var2, Class<P> var3);

    @Override
    public <P> Query<R> setParameterList(int var1, P[] var2, BindableType<P> var3);

    @Override
    public <P> Query<R> setParameterList(QueryParameter<P> var1, Collection<? extends P> var2);

    @Override
    public <P> Query<R> setParameterList(QueryParameter<P> var1, Collection<? extends P> var2, Class<P> var3);

    @Override
    public <P> Query<R> setParameterList(QueryParameter<P> var1, Collection<? extends P> var2, BindableType<P> var3);

    @Override
    public <P> Query<R> setParameterList(QueryParameter<P> var1, P[] var2);

    @Override
    public <P> Query<R> setParameterList(QueryParameter<P> var1, P[] var2, Class<P> var3);

    @Override
    public <P> Query<R> setParameterList(QueryParameter<P> var1, P[] var2, BindableType<P> var3);

    @Override
    public Query<R> setProperties(Object var1);

    @Override
    public Query<R> setProperties(Map var1);

    @Override
    public Query<R> setHibernateFlushMode(FlushMode var1);

    @Override
    public Query<R> setCacheable(boolean var1);

    @Override
    public Query<R> setCacheRegion(String var1);

    @Override
    public Query<R> setCacheMode(CacheMode var1);

    @Override
    public Query<R> setCacheStoreMode(CacheStoreMode var1);

    @Override
    public Query<R> setCacheRetrieveMode(CacheRetrieveMode var1);

    @Override
    public Query<R> setTimeout(int var1);

    @Override
    public Query<R> setFetchSize(int var1);

    @Override
    public Query<R> setReadOnly(boolean var1);

    @Override
    public Query<R> setMaxResults(int var1);

    @Override
    public Query<R> setFirstResult(int var1);

    @Override
    public Query<R> setHint(String var1, Object var2);

    @Override
    public Query<R> setFlushMode(FlushModeType var1);

    @Override
    public Query<R> setLockMode(LockModeType var1);

    @Deprecated(since="5.2")
    default public <T> Query<T> setResultTransformer(ResultTransformer<T> transformer) {
        return this.setTupleTransformer(transformer).setResultListTransformer(transformer);
    }
}

