/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.List;
import java.util.function.Consumer;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;
import org.infinispan.util.logging.events.Messages;

@Listener(sync=true)
public class EventLoggerViewListener {
    private final EventLogManager manager;
    private final Consumer<ViewChangedEvent> afterChange;

    public EventLoggerViewListener(EventLogManager manager, Consumer<ViewChangedEvent> afterChange) {
        this.manager = manager;
        this.afterChange = afterChange;
    }

    public EventLoggerViewListener(EventLogManager manager) {
        this(manager, ignore -> {});
    }

    @Merged
    @ViewChanged
    public void handleViewChange(ViewChangedEvent event) {
        EventLogger eventLogger = this.manager.getEventLogger().scope(event.getLocalAddress());
        this.logNodeJoined(eventLogger, event.getNewMembers(), event.getOldMembers());
        this.logNodeLeft(eventLogger, event.getNewMembers(), event.getOldMembers());
        this.afterChange.accept(event);
    }

    private void logNodeJoined(EventLogger logger2, List<Address> newMembers, List<Address> oldMembers) {
        newMembers.stream().filter(address -> !oldMembers.contains(address)).forEach(address -> logger2.info(EventLogCategory.CLUSTER, Messages.MESSAGES.nodeJoined((Address)address)));
    }

    private void logNodeLeft(EventLogger logger2, List<Address> newMembers, List<Address> oldMembers) {
        oldMembers.stream().filter(address -> !newMembers.contains(address)).forEach(address -> logger2.info(EventLogCategory.CLUSTER, Messages.MESSAGES.nodeLeft((Address)address)));
    }
}

