/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.reflections.Configuration;
import org.reflections.ReflectionsException;

public class Store {
    private transient boolean concurrent;
    private final Map<String, Multimap<String, String>> storeMap = new HashMap<String, Multimap<String, String>>();

    protected Store() {
        this.concurrent = false;
    }

    public Store(Configuration configuration) {
        this.concurrent = configuration.getExecutorService() != null;
    }

    public Set<String> keySet() {
        return this.storeMap.keySet();
    }

    public Multimap<String, String> getOrCreate(String index) {
        Multimap<String, String> mmap = this.storeMap.get(index);
        if (mmap == null) {
            SetMultimap<String, String> multimap = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<String>>(){

                @Override
                public Set<String> get() {
                    return Sets.newSetFromMap(new ConcurrentHashMap());
                }
            });
            mmap = this.concurrent ? Multimaps.synchronizedSetMultimap(multimap) : multimap;
            this.storeMap.put(index, mmap);
        }
        return mmap;
    }

    public Multimap<String, String> get(String index) {
        Multimap<String, String> mmap = this.storeMap.get(index);
        if (mmap == null) {
            throw new ReflectionsException("Scanner " + index + " was not configured");
        }
        return mmap;
    }

    public Iterable<String> get(String index, String ... keys2) {
        return this.get(index, Arrays.asList(keys2));
    }

    public Iterable<String> get(String index, Iterable<String> keys2) {
        Multimap<String, String> mmap = this.get(index);
        IterableChain<String> result2 = new IterableChain<String>();
        for (String key : keys2) {
            ((IterableChain)result2).addAll(mmap.get(key));
        }
        return result2;
    }

    private Iterable<String> getAllIncluding(String index, Iterable<String> keys2, IterableChain<String> result2) {
        ((IterableChain)result2).addAll(keys2);
        for (String key : keys2) {
            Iterable<String> values2 = this.get(index, key);
            if (!values2.iterator().hasNext()) continue;
            this.getAllIncluding(index, values2, result2);
        }
        return result2;
    }

    public Iterable<String> getAll(String index, String key) {
        return this.getAllIncluding(index, this.get(index, key), new IterableChain<String>());
    }

    public Iterable<String> getAll(String index, Iterable<String> keys2) {
        return this.getAllIncluding(index, this.get(index, keys2), new IterableChain<String>());
    }

    private static class IterableChain<T>
    implements Iterable<T> {
        private final List<Iterable<T>> chain = Lists.newArrayList();

        private IterableChain() {
        }

        private void addAll(Iterable<T> iterable) {
            this.chain.add(iterable);
        }

        @Override
        public Iterator<T> iterator() {
            return Iterables.concat(this.chain).iterator();
        }
    }
}

