/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.nio.charset.Charset;
import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;

public final class Dot11SsidElement
extends Dot11InformationElement {
    private static final long serialVersionUID = 2213115521616826185L;
    private static final Charset ENCODING = Charset.forName("UTF-8");
    private final String ssid;

    public static Dot11SsidElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11SsidElement(rawData, offset, length);
    }

    private Dot11SsidElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.SSID);
        this.ssid = new String(rawData, offset + 2, this.getLengthAsInt(), ENCODING);
    }

    private Dot11SsidElement(Builder builder2) {
        super(builder2);
        if (builder2.ssid.getBytes(ENCODING).length > 255) {
            throw new IllegalArgumentException("Too long ssid: " + builder2.ssid);
        }
        this.ssid = builder2.ssid;
    }

    public String getSsid() {
        return this.ssid;
    }

    @Override
    public int length() {
        return 2 + this.ssid.getBytes(ENCODING).length;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawSsid = this.ssid.getBytes(ENCODING);
        byte[] rawData = new byte[2 + rawSsid.length];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        System.arraycopy(rawSsid, 0, rawData, 2, rawSsid.length);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.ssid.hashCode();
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Dot11SsidElement other = (Dot11SsidElement)obj;
        return this.ssid.equals(other.ssid);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("SSID:").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        sb.append(indent).append("  SSID: ").append(this.ssid).append(ls);
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private String ssid;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.SSID.value()));
        }

        private Builder(Dot11SsidElement elem) {
            super(elem);
            this.ssid = elem.ssid;
        }

        public Builder ssid(String ssid) {
            this.ssid = ssid;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot11SsidElement build() {
            if (this.ssid == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("ssid: ").append(this.ssid);
                throw new NullPointerException(sb.toString());
            }
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)this.ssid.getBytes(ENCODING).length);
            }
            return new Dot11SsidElement(this);
        }
    }
}

