/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Session;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.UnparsedIQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.parsing.StandardExtensionElementProvider;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.xml.SmackXmlParser;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.Jid;
import org.jxmpp.stringprep.XmppStringprepException;

public class PacketParserUtils {
    private static final Logger LOGGER = Logger.getLogger(PacketParserUtils.class.getName());

    public static XmlPullParser getParserFor(String stanza) throws XmlPullParserException, IOException {
        return PacketParserUtils.getParserFor(new StringReader(stanza));
    }

    public static XmlPullParser getParserFor(InputStream inputStream) throws XmlPullParserException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        return SmackXmlParser.newXmlParser(inputStreamReader);
    }

    public static XmlPullParser getParserFor(Reader reader) throws XmlPullParserException, IOException {
        XmlPullParser parser2 = SmackXmlParser.newXmlParser(reader);
        ParserUtils.forwardToStartElement(parser2);
        return parser2;
    }

    public static <S extends Stanza> S parseStanza(String stanza) throws XmlPullParserException, SmackParsingException, IOException {
        return (S)PacketParserUtils.parseStanza(PacketParserUtils.getParserFor(stanza), XmlEnvironment.EMPTY);
    }

    public static Stanza parseStanza(XmlPullParser parser2, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, SmackParsingException, IOException {
        String name;
        ParserUtils.assertAtStartTag(parser2);
        switch (name = parser2.getName()) {
            case "message": {
                return PacketParserUtils.parseMessage(parser2, outerXmlEnvironment);
            }
            case "iq": {
                return PacketParserUtils.parseIQ(parser2, outerXmlEnvironment);
            }
            case "presence": {
                return PacketParserUtils.parsePresence(parser2, outerXmlEnvironment);
            }
        }
        throw new IllegalArgumentException("Can only parse message, iq or presence, not " + name);
    }

    private static <SB extends StanzaBuilder<?>> SB parseCommonStanzaAttributes(StanzaBuilderSupplier<SB> stanzaBuilderSupplier, XmlPullParser parser2, XmlEnvironment xmlEnvironment) throws XmppStringprepException {
        String id = parser2.getAttributeValue("id");
        SB stanzaBuilder = stanzaBuilderSupplier.get(id);
        Jid to = ParserUtils.getJidAttribute(parser2, "to");
        ((StanzaBuilder)stanzaBuilder).to(to);
        Jid from = ParserUtils.getJidAttribute(parser2, "from");
        ((StanzaBuilder)stanzaBuilder).from(from);
        String language = ParserUtils.getXmlLang(parser2, xmlEnvironment);
        ((StanzaBuilder)stanzaBuilder).setLanguage(language);
        return stanzaBuilder;
    }

    public static Message parseMessage(XmlPullParser parser2) throws XmlPullParserException, IOException, SmackParsingException {
        return PacketParserUtils.parseMessage(parser2, XmlEnvironment.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Message parseMessage(XmlPullParser parser2, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser2);
        assert (parser2.getName().equals("message"));
        XmlEnvironment messageXmlEnvironment = XmlEnvironment.from(parser2, outerXmlEnvironment);
        int initialDepth = parser2.getDepth();
        MessageBuilder message = PacketParserUtils.parseCommonStanzaAttributes(id -> StanzaBuilder.buildMessage(id), parser2, outerXmlEnvironment);
        String typeString = parser2.getAttributeValue("", "type");
        if (typeString != null) {
            message.ofType(Message.Type.fromString(typeString));
        }
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String elementName = parser2.getName();
                    String namespace = parser2.getNamespace();
                    switch (elementName) {
                        case "error": {
                            message.setError(PacketParserUtils.parseError(parser2, messageXmlEnvironment));
                            break block0;
                        }
                    }
                    ExtensionElement extensionElement = PacketParserUtils.parseExtensionElement(elementName, namespace, parser2, messageXmlEnvironment);
                    message.addExtension(extensionElement);
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return message.build();
                }
            }
        }
    }

    public static String parseElementText(XmlPullParser parser2) throws XmlPullParserException, IOException {
        assert (parser2.getEventType() == XmlPullParser.Event.START_ELEMENT);
        XmlPullParser.Event event = parser2.next();
        if (event != XmlPullParser.Event.TEXT_CHARACTERS) {
            if (event == XmlPullParser.Event.END_ELEMENT) {
                return "";
            }
            throw new XmlPullParserException("Non-empty element tag not followed by text, while Mixed Content (XML 3.2.2) is disallowed");
        }
        String res = parser2.getText();
        event = parser2.next();
        if (event != XmlPullParser.Event.END_ELEMENT) {
            throw new XmlPullParserException("Non-empty element tag contains child-elements, while Mixed Content (XML 3.2.2) is disallowed");
        }
        return res;
    }

    public static CharSequence parseElement(XmlPullParser parser2) throws XmlPullParserException, IOException {
        return PacketParserUtils.parseElement(parser2, false);
    }

    public static CharSequence parseElement(XmlPullParser parser2, boolean fullNamespaces) throws XmlPullParserException, IOException {
        assert (parser2.getEventType() == XmlPullParser.Event.START_ELEMENT);
        return PacketParserUtils.parseContentDepth(parser2, parser2.getDepth(), fullNamespaces);
    }

    public static CharSequence parseContentDepth(XmlPullParser parser2, int depth) throws XmlPullParserException, IOException {
        return PacketParserUtils.parseContentDepth(parser2, depth, false);
    }

    public static CharSequence parseContentDepth(XmlPullParser parser2, int depth, boolean fullNamespaces) throws XmlPullParserException, IOException {
        if (parser2.supportsRoundtrip()) {
            return PacketParserUtils.parseContentDepthWithRoundtrip(parser2, depth);
        }
        return PacketParserUtils.parseContentDepthWithoutRoundtrip(parser2, depth, fullNamespaces);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static CharSequence parseContentDepthWithoutRoundtrip(XmlPullParser parser2, int depth, boolean fullNamespaces) throws XmlPullParserException, IOException {
        XmlStringBuilder xml = new XmlStringBuilder();
        XmlPullParser.Event event = parser2.getEventType();
        String namespaceElement = null;
        boolean startElementJustSeen = false;
        while (true) {
            switch (event) {
                case START_ELEMENT: {
                    String namespace;
                    if (startElementJustSeen) {
                        xml.rightAngleBracket();
                    } else {
                        startElementJustSeen = true;
                    }
                    xml.halfOpenElement(parser2.getName());
                    if ((namespaceElement == null || fullNamespaces) && StringUtils.isNotEmpty((CharSequence)(namespace = parser2.getNamespace()))) {
                        xml.attribute("xmlns", namespace);
                        namespaceElement = parser2.getName();
                    }
                    for (int i = 0; i < parser2.getAttributeCount(); ++i) {
                        xml.attribute(parser2.getAttributeName(i), parser2.getAttributeValue(i));
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (startElementJustSeen) {
                        xml.closeEmptyElement();
                        startElementJustSeen = false;
                    } else {
                        xml.closeElement(parser2.getName());
                    }
                    if (namespaceElement != null && namespaceElement.equals(parser2.getName())) {
                        namespaceElement = null;
                    }
                    if (parser2.getDepth() > depth) break;
                    return xml;
                }
                case TEXT_CHARACTERS: {
                    if (startElementJustSeen) {
                        startElementJustSeen = false;
                        xml.rightAngleBracket();
                    }
                    xml.escape(parser2.getText());
                }
            }
            event = parser2.next();
        }
    }

    private static XmlStringBuilder parseContentDepthWithRoundtrip(XmlPullParser parser2, int depth) throws XmlPullParserException, IOException {
        XmlStringBuilder sb = new XmlStringBuilder();
        XmlPullParser.Event event = parser2.getEventType();
        boolean startElementJustSeen = false;
        block4: while (true) {
            switch (event) {
                case START_ELEMENT: {
                    startElementJustSeen = true;
                    String openElementTag = parser2.getText();
                    sb.append(openElementTag);
                    break;
                }
                case END_ELEMENT: {
                    CharSequence text;
                    boolean isEmptyElement = false;
                    if (startElementJustSeen) {
                        isEmptyElement = true;
                        startElementJustSeen = false;
                    }
                    if (!isEmptyElement) {
                        text = parser2.getText();
                        sb.append(text);
                    }
                    if (parser2.getDepth() > depth) break;
                    break block4;
                }
                default: {
                    startElementJustSeen = false;
                    CharSequence text = parser2.getText();
                    if (event == XmlPullParser.Event.TEXT_CHARACTERS) {
                        text = StringUtils.escapeForXml(text);
                    }
                    sb.append(text);
                }
            }
            event = parser2.next();
        }
        return sb;
    }

    public static Presence parsePresence(XmlPullParser parser2) throws XmlPullParserException, IOException, SmackParsingException {
        return PacketParserUtils.parsePresence(parser2, XmlEnvironment.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Presence parsePresence(XmlPullParser parser2, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser2);
        int initialDepth = parser2.getDepth();
        XmlEnvironment presenceXmlEnvironment = XmlEnvironment.from(parser2, outerXmlEnvironment);
        PresenceBuilder presence = PacketParserUtils.parseCommonStanzaAttributes(stanzaId -> StanzaBuilder.buildPresence(stanzaId), parser2, outerXmlEnvironment);
        Presence.Type type2 = Presence.Type.available;
        String typeString = parser2.getAttributeValue("", "type");
        if (typeString != null && !typeString.equals("")) {
            type2 = Presence.Type.fromString(typeString);
        }
        presence.ofType(type2);
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block1 : switch (eventType) {
                case START_ELEMENT: {
                    String elementName = parser2.getName();
                    String namespace = parser2.getNamespace();
                    switch (elementName) {
                        case "status": {
                            presence.setStatus(parser2.nextText());
                            break block1;
                        }
                        case "priority": {
                            Byte priority = ParserUtils.getByteAttributeFromNextText(parser2);
                            presence.setPriority(priority);
                            break block1;
                        }
                        case "show": {
                            String modeText = parser2.nextText();
                            if (StringUtils.isNotEmpty((CharSequence)modeText)) {
                                presence.setMode(Presence.Mode.fromString(modeText));
                                break block1;
                            }
                            LOGGER.warning("Empty or null mode text in presence show element form " + presence + "' which is invalid according to RFC6121 4.7.2.1");
                            break block1;
                        }
                        case "error": {
                            presence.setError(PacketParserUtils.parseError(parser2, presenceXmlEnvironment));
                            break block1;
                        }
                    }
                    try {
                        ExtensionElement extensionElement = PacketParserUtils.parseExtensionElement(elementName, namespace, parser2, presenceXmlEnvironment);
                        presence.addExtension(extensionElement);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Failed to parse extension element in Presence stanza: " + presence, e);
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return presence.build();
                }
            }
        }
    }

    public static IQ parseIQ(XmlPullParser parser2) throws Exception {
        return PacketParserUtils.parseIQ(parser2, null);
    }

    public static IqData parseIqData(XmlPullParser parser2) throws XmppStringprepException {
        String id = parser2.getAttributeValue("", "id");
        IqData iqData = StanzaBuilder.buildIqData(id);
        Jid to = ParserUtils.getJidAttribute(parser2, "to");
        iqData.to(to);
        Jid from = ParserUtils.getJidAttribute(parser2, "from");
        iqData.from(from);
        String typeString = parser2.getAttributeValue("", "type");
        IQ.Type type2 = IQ.Type.fromString(typeString);
        iqData.ofType(type2);
        return iqData;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static IQ parseIQ(XmlPullParser parser2, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, XmppStringprepException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser2);
        int initialDepth = parser2.getDepth();
        XmlEnvironment iqXmlEnvironment = XmlEnvironment.from(parser2, outerXmlEnvironment);
        Stanza iqPacket = null;
        StanzaError error = null;
        IqData iqData = PacketParserUtils.parseIqData(parser2);
        block14: while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String elementName = parser2.getName();
                    String namespace = parser2.getNamespace();
                    switch (elementName) {
                        case "error": {
                            error = PacketParserUtils.parseError(parser2, iqXmlEnvironment);
                            break block0;
                        }
                    }
                    IqProvider<IQ> provider = ProviderManager.getIQProvider(elementName, namespace);
                    if (provider != null) {
                        iqPacket = provider.parse(parser2, iqData, outerXmlEnvironment);
                        break;
                    }
                    iqPacket = new UnparsedIQ(elementName, namespace, PacketParserUtils.parseElement(parser2));
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() == initialDepth) break block14;
                }
            }
        }
        if (iqPacket == null) {
            switch (iqData.getType()) {
                case error: {
                    iqPacket = new ErrorIQ(error);
                    break;
                }
                case result: {
                    iqPacket = new EmptyResultIQ();
                    break;
                }
            }
        }
        iqPacket.setStanzaId(iqData.getStanzaId());
        iqPacket.setTo(iqData.getTo());
        iqPacket.setFrom(iqData.getFrom());
        ((IQ)iqPacket).setType(iqData.getType());
        iqPacket.setError(error);
        return iqPacket;
    }

    public static Collection<String> parseMechanisms(XmlPullParser parser2) throws XmlPullParserException, IOException {
        ArrayList<String> mechanisms = new ArrayList<String>();
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                String elementName = parser2.getName();
                if (!elementName.equals("mechanism")) continue;
                mechanisms.add(parser2.nextText());
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser2.getName().equals("mechanisms")) continue;
            done = true;
        }
        return mechanisms;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Compress.Feature parseCompressionFeature(XmlPullParser parser2) throws IOException, XmlPullParserException {
        assert (parser2.getEventType() == XmlPullParser.Event.START_ELEMENT);
        int initialDepth = parser2.getDepth();
        LinkedList<String> methods2 = new LinkedList<String>();
        block16: while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "method": {
                            methods2.add(parser2.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "compression": {
                            if (parser2.getDepth() == initialDepth) break block16;
                        }
                        default: {
                            break block0;
                        }
                    }
                }
            }
        }
        assert (parser2.getEventType() == XmlPullParser.Event.END_ELEMENT);
        assert (parser2.getDepth() == initialDepth);
        return new Compress.Feature(methods2);
    }

    public static Map<String, String> parseDescriptiveTexts(XmlPullParser parser2, Map<String, String> descriptiveTexts) throws XmlPullParserException, IOException {
        String xmllang;
        if (descriptiveTexts == null) {
            descriptiveTexts = new HashMap<String, String>();
        }
        if ((xmllang = ParserUtils.getXmlLang(parser2)) == null) {
            xmllang = "";
        }
        String text = parser2.nextText();
        String previousValue = descriptiveTexts.put(xmllang, text);
        assert (previousValue == null);
        return descriptiveTexts;
    }

    public static StreamError parseStreamError(XmlPullParser parser2) throws XmlPullParserException, IOException, SmackParsingException {
        return PacketParserUtils.parseStreamError(parser2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StreamError parseStreamError(XmlPullParser parser2, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        int initialDepth = parser2.getDepth();
        ArrayList<ExtensionElement> extensions = new ArrayList<ExtensionElement>();
        Map<String, String> descriptiveTexts = null;
        StreamError.Condition condition = null;
        String conditionText = null;
        XmlEnvironment streamErrorXmlEnvironment = XmlEnvironment.from(parser2, outerXmlEnvironment);
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            switch (eventType) {
                case START_ELEMENT: {
                    String namespace;
                    String name = parser2.getName();
                    block7 : switch (namespace = parser2.getNamespace()) {
                        case "urn:ietf:params:xml:ns:xmpp-streams": {
                            switch (name) {
                                case "text": {
                                    descriptiveTexts = PacketParserUtils.parseDescriptiveTexts(parser2, descriptiveTexts);
                                    break block7;
                                }
                            }
                            condition = StreamError.Condition.fromString(name);
                            conditionText = parser2.nextText();
                            if (!conditionText.isEmpty()) break;
                            conditionText = null;
                            break;
                        }
                        default: {
                            PacketParserUtils.addExtensionElement(extensions, parser2, name, namespace, streamErrorXmlEnvironment);
                            break;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return new StreamError(condition, conditionText, descriptiveTexts, extensions);
                }
            }
        }
    }

    public static StanzaError parseError(XmlPullParser parser2) throws XmlPullParserException, IOException, SmackParsingException {
        return PacketParserUtils.parseError(parser2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StanzaError parseError(XmlPullParser parser2, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        int initialDepth = parser2.getDepth();
        Map<String, String> descriptiveTexts = null;
        XmlEnvironment stanzaErrorXmlEnvironment = XmlEnvironment.from(parser2, outerXmlEnvironment);
        ArrayList<ExtensionElement> extensions = new ArrayList<ExtensionElement>();
        StanzaError.Builder builder2 = StanzaError.getBuilder();
        builder2.setType(StanzaError.Type.fromString(parser2.getAttributeValue("", "type")));
        builder2.setErrorGenerator(parser2.getAttributeValue("", "by"));
        block16: while (true) {
            XmlPullParser.Event eventType = parser2.next();
            switch (eventType) {
                case START_ELEMENT: {
                    String namespace;
                    String name = parser2.getName();
                    block7 : switch (namespace = parser2.getNamespace()) {
                        case "urn:ietf:params:xml:ns:xmpp-stanzas": {
                            switch (name) {
                                case "text": {
                                    descriptiveTexts = PacketParserUtils.parseDescriptiveTexts(parser2, descriptiveTexts);
                                    break block7;
                                }
                            }
                            builder2.setCondition(StanzaError.Condition.fromString(name));
                            String conditionText = parser2.nextText();
                            if (conditionText.isEmpty()) break;
                            builder2.setConditionText(conditionText);
                            break;
                        }
                        default: {
                            PacketParserUtils.addExtensionElement(extensions, parser2, name, namespace, stanzaErrorXmlEnvironment);
                            break;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() == initialDepth) break block16;
                }
            }
        }
        ((StanzaError.Builder)builder2.setExtensions(extensions)).setDescriptiveTexts(descriptiveTexts);
        return builder2.build();
    }

    public static ExtensionElement parseExtensionElement(String elementName, String namespace, XmlPullParser parser2, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser2);
        ExtensionElementProvider<ExtensionElement> provider = ProviderManager.getExtensionProvider(elementName, namespace);
        if (provider != null) {
            return (ExtensionElement)provider.parse(parser2, outerXmlEnvironment);
        }
        return (ExtensionElement)StandardExtensionElementProvider.INSTANCE.parse(parser2, outerXmlEnvironment);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StartTls parseStartTlsFeature(XmlPullParser parser2) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser2);
        assert (parser2.getNamespace().equals("urn:ietf:params:xml:ns:xmpp-tls"));
        int initalDepth = parser2.getDepth();
        boolean required = false;
        block10: while (true) {
            XmlPullParser.Event event = parser2.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "required": {
                            required = true;
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() == initalDepth) break block10;
                }
            }
        }
        ParserUtils.assertAtEndTag(parser2);
        return new StartTls(required);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Session.Feature parseSessionFeature(XmlPullParser parser2) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser2);
        int initialDepth = parser2.getDepth();
        boolean optional = false;
        while (true) {
            XmlPullParser.Event event = parser2.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "optional": {
                            optional = true;
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return new Session.Feature(optional);
                }
            }
        }
    }

    public static void addExtensionElement(StanzaBuilder<?> stanzaBuilder, XmlPullParser parser2, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser2);
        PacketParserUtils.addExtensionElement(stanzaBuilder, parser2, parser2.getName(), parser2.getNamespace(), outerXmlEnvironment);
    }

    public static void addExtensionElement(StanzaBuilder<?> stanzaBuilder, XmlPullParser parser2, String elementName, String namespace, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ExtensionElement extensionElement = PacketParserUtils.parseExtensionElement(elementName, namespace, parser2, outerXmlEnvironment);
        stanzaBuilder.addExtension(extensionElement);
    }

    public static void addExtensionElement(Stanza packet, XmlPullParser parser2, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser2);
        PacketParserUtils.addExtensionElement(packet, parser2, parser2.getName(), parser2.getNamespace(), outerXmlEnvironment);
    }

    public static void addExtensionElement(Stanza packet, XmlPullParser parser2, String elementName, String namespace, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ExtensionElement packetExtension = PacketParserUtils.parseExtensionElement(elementName, namespace, parser2, outerXmlEnvironment);
        packet.addExtension(packetExtension);
    }

    public static void addExtensionElement(Collection<ExtensionElement> collection, XmlPullParser parser2, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        PacketParserUtils.addExtensionElement(collection, parser2, parser2.getName(), parser2.getNamespace(), outerXmlEnvironment);
    }

    public static void addExtensionElement(Collection<ExtensionElement> collection, XmlPullParser parser2, String elementName, String namespace, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ExtensionElement packetExtension = PacketParserUtils.parseExtensionElement(elementName, namespace, parser2, outerXmlEnvironment);
        collection.add(packetExtension);
    }

    private static interface StanzaBuilderSupplier<SB extends StanzaBuilder<?>> {
        public SB get(String var1);
    }
}

