/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.AbstractError;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class StanzaError
extends AbstractError
implements ExtensionElement {
    public static final String ERROR_CONDITION_AND_TEXT_NAMESPACE = "urn:ietf:params:xml:ns:xmpp-stanzas";
    @Deprecated
    public static final String NAMESPACE = "urn:ietf:params:xml:ns:xmpp-stanzas";
    public static final String ERROR = "error";
    public static final QName QNAME = new QName("jabber:client", "error");
    private static final Logger LOGGER = Logger.getLogger(StanzaError.class.getName());
    static final Map<Condition, Type> CONDITION_TO_TYPE = new HashMap<Condition, Type>();
    private final Condition condition;
    private final String conditionText;
    private final String errorGenerator;
    private final Type type;

    public StanzaError(Condition condition, String conditionText, String errorGenerator, Type type2, Map<String, String> descriptiveTexts, List<ExtensionElement> extensions) {
        super(descriptiveTexts, "urn:ietf:params:xml:ns:xmpp-stanzas", extensions);
        this.condition = Objects.requireNonNull(condition, "condition must not be null");
        if (StringUtils.isNullOrEmpty((CharSequence)conditionText)) {
            conditionText = null;
        }
        if (conditionText != null) {
            switch (condition) {
                case gone: 
                case redirect: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Condition text can only be set with condtion types 'gone' and 'redirect', not " + (Object)((Object)condition));
                }
            }
        }
        this.conditionText = conditionText;
        this.errorGenerator = errorGenerator;
        if (type2 == null) {
            Type determinedType = CONDITION_TO_TYPE.get((Object)condition);
            if (determinedType == null) {
                LOGGER.warning("Could not determine type for condition: " + (Object)((Object)condition));
                determinedType = Type.CANCEL;
            }
            this.type = determinedType;
        } else {
            this.type = type2;
        }
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Type getType() {
        return this.type;
    }

    public String getErrorGenerator() {
        return this.errorGenerator;
    }

    public String getConditionText() {
        return this.conditionText;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("XMPPError: ");
        sb.append(this.condition.toString()).append(" - ").append(this.type.toString());
        String descriptiveText = this.getDescriptiveText();
        if (descriptiveText != null) {
            sb.append(" [").append(descriptiveText).append(']');
        }
        if (this.errorGenerator != null) {
            sb.append(". Generated by ").append(this.errorGenerator);
        }
        return sb.toString();
    }

    @Override
    public String getElementName() {
        return QNAME.getLocalPart();
    }

    @Override
    public String getNamespace() {
        return QNAME.getNamespaceURI();
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this, enclosingNamespace);
        xml.attribute("type", this.type.toString());
        xml.optAttribute("by", this.errorGenerator);
        xml.rightAngleBracket();
        xml.halfOpenElement(this.condition.toString());
        xml.xmlnsAttribute("urn:ietf:params:xml:ns:xmpp-stanzas");
        if (this.conditionText != null) {
            xml.rightAngleBracket();
            xml.escape(this.conditionText);
            xml.closeElement(this.condition.toString());
        } else {
            xml.closeEmptyElement();
        }
        this.addDescriptiveTextsAndExtensions(xml);
        xml.closeElement(this);
        return xml;
    }

    public static Builder from(Condition condition, String descriptiveText) {
        Builder builder2 = StanzaError.getBuilder().setCondition(condition);
        if (descriptiveText != null) {
            HashMap<String, String> descriptiveTexts = new HashMap<String, String>();
            descriptiveTexts.put("en", descriptiveText);
            builder2.setDescriptiveTexts(descriptiveTexts);
        }
        return builder2;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static Builder getBuilder(Condition condition) {
        return StanzaError.getBuilder().setCondition(condition);
    }

    public static Builder getBuilder(StanzaError xmppError) {
        return StanzaError.getBuilder().copyFrom(xmppError);
    }

    static {
        CONDITION_TO_TYPE.put(Condition.bad_request, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.conflict, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.feature_not_implemented, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.forbidden, Type.AUTH);
        CONDITION_TO_TYPE.put(Condition.gone, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.internal_server_error, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.item_not_found, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.jid_malformed, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.not_acceptable, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.not_allowed, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.not_authorized, Type.AUTH);
        CONDITION_TO_TYPE.put(Condition.policy_violation, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.recipient_unavailable, Type.WAIT);
        CONDITION_TO_TYPE.put(Condition.redirect, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.registration_required, Type.AUTH);
        CONDITION_TO_TYPE.put(Condition.remote_server_not_found, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.remote_server_timeout, Type.WAIT);
        CONDITION_TO_TYPE.put(Condition.resource_constraint, Type.WAIT);
        CONDITION_TO_TYPE.put(Condition.service_unavailable, Type.CANCEL);
        CONDITION_TO_TYPE.put(Condition.subscription_required, Type.AUTH);
        CONDITION_TO_TYPE.put(Condition.undefined_condition, Type.MODIFY);
        CONDITION_TO_TYPE.put(Condition.unexpected_request, Type.WAIT);
    }

    public static enum Condition {
        bad_request,
        conflict,
        feature_not_implemented,
        forbidden,
        gone,
        internal_server_error,
        item_not_found,
        jid_malformed,
        not_acceptable,
        not_allowed,
        not_authorized,
        policy_violation,
        recipient_unavailable,
        redirect,
        registration_required,
        remote_server_not_found,
        remote_server_timeout,
        resource_constraint,
        service_unavailable,
        subscription_required,
        undefined_condition,
        unexpected_request;


        public String toString() {
            return this.name().replace('_', '-');
        }

        public static Condition fromString(String string) {
            string = string.replace('-', '_');
            Condition condition = null;
            try {
                condition = Condition.valueOf(string);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not transform string '" + string + "' to XMPPErrorCondition", e);
            }
            return condition;
        }
    }

    public static enum Type {
        WAIT,
        CANCEL,
        MODIFY,
        AUTH,
        CONTINUE;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }

        public static Type fromString(String string) {
            string = string.toUpperCase(Locale.US);
            return Type.valueOf(string);
        }
    }

    public static final class Builder
    extends AbstractError.Builder<Builder> {
        private Condition condition;
        private String conditionText;
        private String errorGenerator;
        private Type type;

        private Builder() {
        }

        public Builder setCondition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Builder setType(Type type2) {
            this.type = type2;
            return this;
        }

        public Builder setConditionText(String conditionText) {
            this.conditionText = conditionText;
            return this;
        }

        public Builder setErrorGenerator(String errorGenerator) {
            this.errorGenerator = errorGenerator;
            return this;
        }

        public Builder copyFrom(StanzaError xmppError) {
            this.setCondition(xmppError.getCondition());
            this.setType(xmppError.getType());
            this.setConditionText(xmppError.getConditionText());
            this.setErrorGenerator(xmppError.getErrorGenerator());
            this.setDescriptiveTexts(xmppError.descriptiveTexts);
            this.setTextNamespace(xmppError.textNamespace);
            this.setExtensions(xmppError.extensions);
            return this;
        }

        public StanzaError build() {
            return new StanzaError(this.condition, this.conditionText, this.errorGenerator, this.type, this.descriptiveTexts, this.extensions);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

