/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.concurrent.PeriodicRunnableWithObject;
import org.jitsi.utils.concurrent.RecurringRunnableExecutor;
import org.jitsi.videobridge.stats.Statistics;
import org.jitsi.videobridge.stats.StatsTransport;
import org.jitsi.videobridge.stats.config.StatsManagerConfig;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jitsi/videobridge/stats/StatsCollector;", "", "statistics", "Lorg/jitsi/videobridge/stats/Statistics;", "(Lorg/jitsi/videobridge/stats/Statistics;)V", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getStatistics", "()Lorg/jitsi/videobridge/stats/Statistics;", "statisticsExecutor", "Lorg/jitsi/utils/concurrent/RecurringRunnableExecutor;", "statisticsRunnable", "Lorg/jitsi/videobridge/stats/StatsCollector$StatisticsPeriodicRunnable;", "transportExecutor", "transportRunnables", "", "Lorg/jitsi/videobridge/stats/StatsCollector$TransportPeriodicRunnable;", "addTransport", "", "transport", "Lorg/jitsi/videobridge/stats/StatsTransport;", "updatePeriodMs", "", "removeTransport", "start", "stop", "StatisticsPeriodicRunnable", "TransportPeriodicRunnable", "jitsi-videobridge"})
public final class StatsCollector {
    @NotNull
    private final Statistics statistics;
    @NotNull
    private final RecurringRunnableExecutor statisticsExecutor;
    @NotNull
    private final RecurringRunnableExecutor transportExecutor;
    @NotNull
    private final StatisticsPeriodicRunnable statisticsRunnable;
    @NotNull
    private final List<TransportPeriodicRunnable> transportRunnables;
    @NotNull
    private final AtomicBoolean running;

    public StatsCollector(@NotNull Statistics statistics) {
        Intrinsics.checkNotNullParameter(statistics, "statistics");
        this.statistics = statistics;
        this.statisticsExecutor = new RecurringRunnableExecutor(StatsCollector.class.getSimpleName() + "-statisticsExecutor");
        this.transportExecutor = new RecurringRunnableExecutor(StatsCollector.class.getSimpleName() + "-transportExecutor");
        this.transportRunnables = new CopyOnWriteArrayList();
        this.running = new AtomicBoolean();
        long period = StatsManagerConfig.config.getInterval().toMillis();
        if (!(period >= 1L)) {
            boolean bl = false;
            String string = "period " + period;
            throw new IllegalArgumentException(string.toString());
        }
        this.statisticsRunnable = new StatisticsPeriodicRunnable(this.statistics, period);
    }

    @NotNull
    public final Statistics getStatistics() {
        return this.statistics;
    }

    public final void addTransport(@NotNull StatsTransport transport, long updatePeriodMs) {
        TransportPeriodicRunnable transportPeriodicRunnable;
        Intrinsics.checkNotNullParameter(transport, "transport");
        if (!(updatePeriodMs >= 1L)) {
            boolean $i$a$-require-StatsCollector$addTransport$22 = false;
            String $i$a$-require-StatsCollector$addTransport$22 = "period " + updatePeriodMs;
            throw new IllegalArgumentException($i$a$-require-StatsCollector$addTransport$22.toString());
        }
        TransportPeriodicRunnable it = transportPeriodicRunnable = new TransportPeriodicRunnable(transport, updatePeriodMs);
        boolean bl = false;
        this.transportRunnables.add(it);
        if (this.running.get()) {
            this.transportExecutor.registerRecurringRunnable(it);
        }
    }

    public final void removeTransport(@NotNull StatsTransport transport) {
        block2: {
            TransportPeriodicRunnable runnable;
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(transport, "transport");
                Iterable iterable = this.transportRunnables;
                for (Object t : iterable) {
                    TransportPeriodicRunnable it = (TransportPeriodicRunnable)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.o, transport)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            TransportPeriodicRunnable transportPeriodicRunnable = runnable = (TransportPeriodicRunnable)v0;
            if (transportPeriodicRunnable == null) break block2;
            TransportPeriodicRunnable it = transportPeriodicRunnable;
            boolean bl = false;
            this.transportExecutor.deRegisterRecurringRunnable(it);
            this.transportRunnables.remove(it);
        }
    }

    public final void start() {
        if (this.running.compareAndSet(false, true)) {
            this.statisticsExecutor.registerRecurringRunnable(this.statisticsRunnable);
            Iterable $this$forEach$iv = this.transportRunnables;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TransportPeriodicRunnable it = (TransportPeriodicRunnable)element$iv;
                boolean bl = false;
                this.transportExecutor.registerRecurringRunnable(it);
            }
        }
    }

    public final void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.statisticsExecutor.deRegisterRecurringRunnable(this.statisticsRunnable);
            Iterable $this$forEach$iv = this.transportRunnables;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TransportPeriodicRunnable it = (TransportPeriodicRunnable)element$iv;
                boolean bl = false;
                this.transportExecutor.deRegisterRecurringRunnable(it);
            }
            this.transportRunnables.clear();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jitsi/videobridge/stats/StatsCollector$StatisticsPeriodicRunnable;", "Lorg/jitsi/utils/concurrent/PeriodicRunnableWithObject;", "Lorg/jitsi/videobridge/stats/Statistics;", "statistics", "period", "", "(Lorg/jitsi/videobridge/stats/Statistics;J)V", "doRun", "", "jitsi-videobridge"})
    private static final class StatisticsPeriodicRunnable
    extends PeriodicRunnableWithObject<Statistics> {
        public StatisticsPeriodicRunnable(@NotNull Statistics statistics, long period) {
            Intrinsics.checkNotNullParameter(statistics, "statistics");
            super(statistics, period);
        }

        @Override
        protected void doRun() {
            ((Statistics)this.o).generate();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jitsi/videobridge/stats/StatsCollector$TransportPeriodicRunnable;", "Lorg/jitsi/utils/concurrent/PeriodicRunnableWithObject;", "Lorg/jitsi/videobridge/stats/StatsTransport;", "transport", "period", "", "(Lorg/jitsi/videobridge/stats/StatsCollector;Lorg/jitsi/videobridge/stats/StatsTransport;J)V", "doRun", "", "jitsi-videobridge"})
    private final class TransportPeriodicRunnable
    extends PeriodicRunnableWithObject<StatsTransport> {
        public TransportPeriodicRunnable(StatsTransport transport, long period) {
            Intrinsics.checkNotNullParameter(transport, "transport");
            super(transport, period);
        }

        @Override
        protected void doRun() {
            long measurementInterval = this.getPeriod();
            ((StatsTransport)this.o).publishStatistics((Statistics)((StatsCollector)StatsCollector.this).statisticsRunnable.o, measurementInterval);
        }
    }
}

