/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.time.Clock;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.PayloadTypeEncoding;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.event.SyncEventEmitter;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.cc.allocation.AllocationSettings;
import org.jitsi.videobridge.cc.allocation.AllocationSettingsWrapper;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocation;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocator;
import org.jitsi.videobridge.cc.allocation.BitrateControllerStatusSnapshot;
import org.jitsi.videobridge.cc.allocation.MediaSourceContainer;
import org.jitsi.videobridge.cc.allocation.PacketHandler;
import org.jitsi.videobridge.cc.allocation.SingleAllocation;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.cc.config.BitrateControllerConfig;
import org.jitsi.videobridge.message.ReceiverVideoConstraintsMessage;
import org.jitsi.videobridge.util.BooleanStateTimeTracker;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002bcBE\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020AJ\u000e\u0010?\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GJ\u000e\u0010H\u001a\u00020E2\u0006\u0010I\u001a\u00020JJ\u0006\u0010K\u001a\u00020EJ\u0006\u0010L\u001a\u00020EJ\u0006\u0010M\u001a\u00020NJ\u0006\u0010O\u001a\u00020PJ\u000e\u0010Q\u001a\u00020\u000e2\u0006\u0010R\u001a\u00020SJ\u0006\u0010T\u001a\u00020\u000eJ\u000e\u0010U\u001a\u00020\u000e2\u0006\u0010R\u001a\u00020SJ\u0006\u0010V\u001a\u00020\u000eJ\u0006\u0010W\u001a\u00020+J\u000e\u0010X\u001a\u00020E2\u0006\u0010Y\u001a\u00020ZJ\u000e\u0010[\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020CJ\u000e\u0010\\\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020AJ\u0014\u0010]\u001a\u00020E*\u0002092\u0006\u0010^\u001a\u00020_H\u0002J\u0014\u0010`\u001a\u00020E*\u0002092\u0006\u0010a\u001a\u00020JH\u0002R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\f0\u001bR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020+8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u00108\u001a\u0004\u0018\u000109\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BitrateController;", "T", "Lorg/jitsi/videobridge/cc/allocation/MediaSourceContainer;", "", "eventHandler", "Lorg/jitsi/videobridge/cc/allocation/BitrateController$EventHandler;", "endpointsSupplier", "Ljava/util/function/Supplier;", "", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "useSourceNames", "", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/videobridge/cc/allocation/BitrateController$EventHandler;Ljava/util/function/Supplier;Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/utils/logging2/Logger;ZLjava/time/Clock;)V", "allocationSettings", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "getAllocationSettings", "()Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "allocationSettingsWrapper", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettingsWrapper;", "bandwidthAllocator", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator;", "bitrateAllocatorEventHandler", "Lorg/jitsi/videobridge/cc/allocation/BitrateController$BitrateAllocatorEventHandler;", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "eventEmitter", "Lorg/jitsi/utils/event/SyncEventEmitter;", "getEventEmitter", "()Lorg/jitsi/utils/event/SyncEventEmitter;", "forwardedEndpoints", "", "", "getForwardedEndpoints$annotations", "()V", "forwardedSources", "value", "", "lastN", "getLastN", "()I", "setLastN", "(I)V", "oversendingTimeTracker", "Lorg/jitsi/videobridge/util/BooleanStateTimeTracker;", "getOversendingTimeTracker", "()Lorg/jitsi/videobridge/util/BooleanStateTimeTracker;", "packetHandler", "Lorg/jitsi/videobridge/cc/allocation/PacketHandler;", "supportsRtx", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "getTimeSeriesLogger", "()Lorg/jitsi/utils/logging/TimeSeriesLogger;", "trustBwe", "getTrustBwe", "()Z", "accept", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "rtcpSrPacket", "Lorg/jitsi/rtp/rtcp/RtcpSrPacket;", "addPayloadType", "", "payloadType", "Lorg/jitsi/nlj/format/PayloadType;", "bandwidthChanged", "newBandwidthBps", "", "endpointOrderingChanged", "expire", "getStatusSnapshot", "Lorg/jitsi/videobridge/cc/allocation/BitrateControllerStatusSnapshot;", "getTotalOversendingTime", "Ljava/time/Duration;", "hasNonZeroEffectiveConstraints", "source", "Lorg/jitsi/nlj/MediaSourceDesc;", "hasSuspendedSources", "isOnStageOrSelected", "isOversending", "numForwardedEndpoints", "setBandwidthAllocationSettings", "message", "Lorg/jitsi/videobridge/message/ReceiverVideoConstraintsMessage;", "transformRtcp", "transformRtp", "logAllocationChange", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "logBweChange", "newBweBps", "BitrateAllocatorEventHandler", "EventHandler", "jitsi-videobridge"})
public final class BitrateController<T extends MediaSourceContainer> {
    @NotNull
    private final DiagnosticContext diagnosticContext;
    private final boolean useSourceNames;
    @NotNull
    private final Clock clock;
    @NotNull
    private final SyncEventEmitter<EventHandler> eventEmitter;
    @NotNull
    private final BitrateAllocatorEventHandler bitrateAllocatorEventHandler;
    @NotNull
    private Set<String> forwardedEndpoints;
    @NotNull
    private Set<String> forwardedSources;
    @NotNull
    private final BooleanStateTimeTracker oversendingTimeTracker;
    @Nullable
    private final TimeSeriesLogger timeSeriesLogger;
    private boolean supportsRtx;
    @NotNull
    private final PacketHandler packetHandler;
    @NotNull
    private final BandwidthAllocator<T> bandwidthAllocator;
    @NotNull
    private final AllocationSettingsWrapper allocationSettingsWrapper;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public BitrateController(@NotNull EventHandler eventHandler, @NotNull Supplier<List<T>> endpointsSupplier, @NotNull DiagnosticContext diagnosticContext, @NotNull Logger parentLogger, boolean useSourceNames, @NotNull Clock clock) {
        void it;
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        Intrinsics.checkNotNullParameter(endpointsSupplier, "endpointsSupplier");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.diagnosticContext = diagnosticContext;
        this.useSourceNames = useSourceNames;
        this.clock = clock;
        this.eventEmitter = new SyncEventEmitter();
        this.bitrateAllocatorEventHandler = new BitrateAllocatorEventHandler();
        this.forwardedEndpoints = SetsKt.emptySet();
        this.forwardedSources = SetsKt.emptySet();
        this.oversendingTimeTracker = new BooleanStateTimeTracker(false, null, 3, null);
        TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(BitrateController.class);
        BitrateController bitrateController2 = this;
        boolean bl = false;
        bitrateController2.timeSeriesLogger = it.isTraceEnabled() ? it : null;
        this.packetHandler = new PacketHandler(this.clock, parentLogger, this.diagnosticContext, (EventEmitter<EventHandler>)this.eventEmitter);
        this.bandwidthAllocator = new BandwidthAllocator<T>(this.bitrateAllocatorEventHandler, endpointsSupplier, () -> BitrateController.bandwidthAllocator$lambda-1(this), parentLogger, this.diagnosticContext, this.clock);
        this.allocationSettingsWrapper = new AllocationSettingsWrapper(this.useSourceNames);
        this.eventEmitter.addHandler(eventHandler);
    }

    public /* synthetic */ BitrateController(EventHandler eventHandler, Supplier supplier, DiagnosticContext diagnosticContext, Logger logger, boolean bl, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(eventHandler, supplier, diagnosticContext, logger, bl, clock);
    }

    @NotNull
    public final SyncEventEmitter<EventHandler> getEventEmitter() {
        return this.eventEmitter;
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(expression="forwardedSources", imports={}), level=DeprecationLevel.WARNING)
    private static /* synthetic */ void getForwardedEndpoints$annotations() {
    }

    @NotNull
    public final BooleanStateTimeTracker getOversendingTimeTracker() {
        return this.oversendingTimeTracker;
    }

    @Nullable
    public final TimeSeriesLogger getTimeSeriesLogger() {
        return this.timeSeriesLogger;
    }

    public final boolean hasSuspendedSources() {
        return this.bandwidthAllocator.getAllocation().getHasSuspendedSources();
    }

    @NotNull
    public final AllocationSettings getAllocationSettings() {
        return this.allocationSettingsWrapper.get();
    }

    private final boolean getTrustBwe() {
        return BitrateControllerConfig.config.trustBwe() && this.supportsRtx && this.packetHandler.timeSinceFirstMedia().compareTo(DurationKt.getSecs(10)) >= 0;
    }

    public final void endpointOrderingChanged() {
        this.bandwidthAllocator.update();
    }

    public final int getLastN() {
        return this.allocationSettingsWrapper.getLastN$jitsi_videobridge();
    }

    public final void setLastN(int value2) {
        if (this.allocationSettingsWrapper.setLastN(value2)) {
            this.bandwidthAllocator.update(this.allocationSettingsWrapper.get());
        }
    }

    public final void expire() {
        this.bandwidthAllocator.expire();
    }

    public final int numForwardedEndpoints() {
        return this.forwardedEndpoints.size();
    }

    @NotNull
    public final Duration getTotalOversendingTime() {
        return this.oversendingTimeTracker.totalTimeOn();
    }

    public final boolean isOversending() {
        return this.oversendingTimeTracker.getState();
    }

    public final void bandwidthChanged(long newBandwidthBps) {
        TimeSeriesLogger timeSeriesLogger = this.timeSeriesLogger;
        if (timeSeriesLogger != null) {
            this.logBweChange(timeSeriesLogger, newBandwidthBps);
        }
        this.bandwidthAllocator.bandwidthChanged(newBandwidthBps);
    }

    public final boolean accept(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (packetInfo.getLayeringChanged()) {
            this.bandwidthAllocator.update();
        }
        return this.packetHandler.accept(packetInfo);
    }

    public final boolean accept(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter(rtcpSrPacket, "rtcpSrPacket");
        return this.packetHandler.accept(rtcpSrPacket);
    }

    public final boolean transformRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter(rtcpSrPacket, "rtcpSrPacket");
        return this.packetHandler.transformRtcp(rtcpSrPacket);
    }

    public final boolean transformRtp(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        return this.packetHandler.transformRtp(packetInfo);
    }

    @NotNull
    public final JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject $this$_get_debugState__u24lambda_u2d2 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$_get_debugState__u24lambda_u2d2.put("bitrate_allocator", this.bandwidthAllocator.getDebugState());
        $this$_get_debugState__u24lambda_u2d2.put("packet_handler", this.packetHandler.getDebugState());
        $this$_get_debugState__u24lambda_u2d2.put("forwardedEndpoints", this.forwardedEndpoints.toString());
        $this$_get_debugState__u24lambda_u2d2.put("forwardedSources", this.forwardedSources.toString());
        $this$_get_debugState__u24lambda_u2d2.put("oversending", this.oversendingTimeTracker.getState());
        $this$_get_debugState__u24lambda_u2d2.put("total_oversending_time_secs", this.oversendingTimeTracker.totalTimeOn().getSeconds());
        $this$_get_debugState__u24lambda_u2d2.put("supportsRtx", this.supportsRtx);
        $this$_get_debugState__u24lambda_u2d2.put("trust_bwe", this.getTrustBwe());
        return jSONObject;
    }

    public final void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        this.packetHandler.addPayloadType(payloadType);
        if (payloadType.getEncoding() == PayloadTypeEncoding.RTX) {
            this.supportsRtx = true;
        }
    }

    public final void setBandwidthAllocationSettings(@NotNull ReceiverVideoConstraintsMessage message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (this.allocationSettingsWrapper.setBandwidthAllocationSettings(message)) {
            this.bandwidthAllocator.update(this.allocationSettingsWrapper.get());
        }
    }

    public final boolean isOnStageOrSelected(@NotNull MediaSourceDesc source) {
        Intrinsics.checkNotNullParameter(source, "source");
        return this.getAllocationSettings().getOnStageSources().contains(source.getSourceName()) || this.getAllocationSettings().getSelectedSources().contains(source.getSourceName());
    }

    public final boolean hasNonZeroEffectiveConstraints(@NotNull MediaSourceDesc source) {
        Intrinsics.checkNotNullParameter(source, "source");
        return this.bandwidthAllocator.hasNonZeroEffectiveConstraints$jitsi_videobridge(source);
    }

    @NotNull
    public final BitrateControllerStatusSnapshot getStatusSnapshot() {
        double totalTargetBitrate = 0.0;
        totalTargetBitrate = BandwidthKt.getBps(0);
        double totalIdealBitrate = 0.0;
        totalIdealBitrate = BandwidthKt.getBps(0);
        Set activeSsrcs = new LinkedHashSet();
        long nowMs = this.clock.instant().toEpochMilli();
        BandwidthAllocation allocation = this.bandwidthAllocator.getAllocation();
        Iterable $this$forEach$iv = allocation.getAllocations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleAllocation it = (SingleAllocation)element$iv;
            boolean bl = false;
            RtpLayerDesc rtpLayerDesc = it.getTargetLayer();
            if (rtpLayerDesc != null) {
                double targetBitrate = rtpLayerDesc.getBitrate-WElJv5I(nowMs);
                boolean bl2 = false;
                totalTargetBitrate = Bandwidth.plus-GI7mN98(totalTargetBitrate, targetBitrate);
                MediaSourceDesc mediaSourceDesc = it.getMediaSource();
                if (mediaSourceDesc != null) {
                    long primarySsrc = mediaSourceDesc.getPrimarySSRC();
                    boolean bl3 = false;
                    activeSsrcs.add(primarySsrc);
                }
            }
            RtpLayerDesc rtpLayerDesc2 = it.getIdealLayer();
            if (rtpLayerDesc2 == null) continue;
            double idealBitrate = rtpLayerDesc2.getBitrate-WElJv5I(nowMs);
            boolean bl4 = false;
            totalIdealBitrate = Bandwidth.plus-GI7mN98(totalIdealBitrate, idealBitrate);
        }
        activeSsrcs.removeIf(BitrateController::getStatusSnapshot$lambda-7);
        return new BitrateControllerStatusSnapshot((long)totalTargetBitrate, (long)totalIdealBitrate, activeSsrcs);
    }

    private final void logBweChange(TimeSeriesLogger $this$logBweChange, long newBweBps) {
        $this$logBweChange.trace(this.diagnosticContext.makeTimeSeriesPoint("new_bwe").addField("bwe_bps", newBweBps));
    }

    private final void logAllocationChange(TimeSeriesLogger $this$logAllocationChange, BandwidthAllocation allocation) {
        long nowMs = this.clock.millis();
        double totalTargetBps = 0.0;
        double totalIdealBps = 0.0;
        Iterable $this$forEach$iv = allocation.getAllocations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double bitrate;
            SingleAllocation it = (SingleAllocation)element$iv;
            boolean bl = false;
            RtpLayerDesc rtpLayerDesc = it.getTargetLayer();
            if (rtpLayerDesc != null) {
                bitrate = rtpLayerDesc.getBitrate-WElJv5I(nowMs);
                boolean bl2 = false;
                totalTargetBps += bitrate;
            }
            RtpLayerDesc rtpLayerDesc2 = it.getIdealLayer();
            if (rtpLayerDesc2 != null) {
                bitrate = rtpLayerDesc2.getBitrate-WElJv5I(nowMs);
                boolean bl3 = false;
                totalIdealBps += bitrate;
            }
            RtpLayerDesc rtpLayerDesc3 = it.getTargetLayer();
            RtpLayerDesc rtpLayerDesc4 = it.getIdealLayer();
            RtpLayerDesc rtpLayerDesc5 = it.getTargetLayer();
            RtpLayerDesc rtpLayerDesc6 = it.getIdealLayer();
            $this$logAllocationChange.trace(this.diagnosticContext.makeTimeSeriesPoint("allocation_for_source", nowMs).addField("remote_endpoint_id", it.getEndpointId()).addField("target_idx", rtpLayerDesc3 != null ? rtpLayerDesc3.getIndex() : -1).addField("ideal_idx", rtpLayerDesc4 != null ? rtpLayerDesc4.getIndex() : -1).addField("target_bps", rtpLayerDesc5 != null ? (Number)rtpLayerDesc5.getBitrate-WElJv5I(nowMs) : (Number)-1).addField("ideal_bps", rtpLayerDesc6 != null ? (Number)rtpLayerDesc6.getBitrate-WElJv5I(nowMs) : (Number)-1));
        }
        $this$logAllocationChange.trace(this.diagnosticContext.makeTimeSeriesPoint("allocation", nowMs).addField("total_target_bps", totalTargetBps).addField("total_ideal_bps", totalIdealBps));
    }

    @JvmOverloads
    public BitrateController(@NotNull EventHandler eventHandler, @NotNull Supplier<List<T>> endpointsSupplier, @NotNull DiagnosticContext diagnosticContext, @NotNull Logger parentLogger, boolean useSourceNames) {
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        Intrinsics.checkNotNullParameter(endpointsSupplier, "endpointsSupplier");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this(eventHandler, endpointsSupplier, diagnosticContext, parentLogger, useSourceNames, null, 32, null);
    }

    private static final Boolean bandwidthAllocator$lambda-1(BitrateController this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.getTrustBwe();
    }

    private static final boolean getStatusSnapshot$lambda-7(Long it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it < 0L;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J8\u0010\u0006\u001a\u00020\u00032\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000bH&J\u0016\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH&J\u0016\u0010\u0011\u001a\u00020\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH&J\u001a\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0016H&\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BitrateController$EventHandler;", "", "allocationChanged", "", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "effectiveVideoConstraintsChanged", "oldEffectiveConstraints", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "newEffectiveConstraints", "forwardedEndpointsChanged", "forwardedEndpoints", "", "", "forwardedSourcesChanged", "forwardedSources", "keyframeNeeded", "endpointId", "ssrc", "", "jitsi-videobridge"})
    public static interface EventHandler {
        public void forwardedEndpointsChanged(@NotNull Set<String> var1);

        public void forwardedSourcesChanged(@NotNull Set<String> var1);

        public void effectiveVideoConstraintsChanged(@NotNull Map<MediaSourceDesc, VideoConstraints> var1, @NotNull Map<MediaSourceDesc, VideoConstraints> var2);

        public void keyframeNeeded(@Nullable String var1, long var2);

        public void allocationChanged(@NotNull BandwidthAllocation var1);

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void allocationChanged(@NotNull EventHandler this_, @NotNull BandwidthAllocation allocation) {
                Intrinsics.checkNotNullParameter(allocation, "allocation");
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J8\u0010\u0007\u001a\u00020\u00042\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BitrateController$BitrateAllocatorEventHandler;", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator$EventHandler;", "(Lorg/jitsi/videobridge/cc/allocation/BitrateController;)V", "allocationChanged", "", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "effectiveVideoConstraintsChanged", "oldEffectiveConstraints", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "newEffectiveConstraints", "jitsi-videobridge"})
    private final class BitrateAllocatorEventHandler
    implements BandwidthAllocator.EventHandler {
        @Override
        public void allocationChanged(@NotNull BandwidthAllocation allocation) {
            Intrinsics.checkNotNullParameter(allocation, "allocation");
            TimeSeriesLogger timeSeriesLogger = BitrateController.this.getTimeSeriesLogger();
            if (timeSeriesLogger != null) {
                BitrateController.this.logAllocationChange(timeSeriesLogger, allocation);
            }
            BitrateController.this.packetHandler.allocationChanged(allocation);
            if (BitrateController.this.useSourceNames) {
                Set<String> newForwardedSources = allocation.getForwardedSources();
                if (!Intrinsics.areEqual(BitrateController.this.forwardedSources, newForwardedSources)) {
                    BitrateController.this.forwardedSources = newForwardedSources;
                    BitrateController.this.getEventEmitter().fireEvent(new Function1<EventHandler, Unit>(newForwardedSources){
                        final /* synthetic */ Set<String> $newForwardedSources;
                        {
                            this.$newForwardedSources = $newForwardedSources;
                            super(1);
                        }

                        public final void invoke(@NotNull EventHandler $this$fireEvent) {
                            Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                            $this$fireEvent.forwardedSourcesChanged(this.$newForwardedSources);
                        }
                    });
                }
            } else {
                Set<String> newForwardedEndpoints = allocation.getForwardedEndpoints();
                if (!Intrinsics.areEqual(BitrateController.this.forwardedEndpoints, newForwardedEndpoints)) {
                    BitrateController.this.forwardedEndpoints = newForwardedEndpoints;
                    BitrateController.this.getEventEmitter().fireEvent(new Function1<EventHandler, Unit>(newForwardedEndpoints){
                        final /* synthetic */ Set<String> $newForwardedEndpoints;
                        {
                            this.$newForwardedEndpoints = $newForwardedEndpoints;
                            super(1);
                        }

                        public final void invoke(@NotNull EventHandler $this$fireEvent) {
                            Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                            $this$fireEvent.forwardedEndpointsChanged(this.$newForwardedEndpoints);
                        }
                    });
                }
            }
            BitrateController.this.getOversendingTimeTracker().setState(allocation.getOversending());
            BitrateController.this.getEventEmitter().fireEvent(new Function1<EventHandler, Unit>(allocation){
                final /* synthetic */ BandwidthAllocation $allocation;
                {
                    this.$allocation = $allocation;
                    super(1);
                }

                public final void invoke(@NotNull EventHandler $this$fireEvent) {
                    Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                    $this$fireEvent.allocationChanged(this.$allocation);
                }
            });
        }

        @Override
        public void effectiveVideoConstraintsChanged(@NotNull Map<MediaSourceDesc, VideoConstraints> oldEffectiveConstraints, @NotNull Map<MediaSourceDesc, VideoConstraints> newEffectiveConstraints) {
            Intrinsics.checkNotNullParameter(oldEffectiveConstraints, "oldEffectiveConstraints");
            Intrinsics.checkNotNullParameter(newEffectiveConstraints, "newEffectiveConstraints");
            BitrateController.this.getEventEmitter().fireEvent(new Function1<EventHandler, Unit>(oldEffectiveConstraints, newEffectiveConstraints){
                final /* synthetic */ Map<MediaSourceDesc, VideoConstraints> $oldEffectiveConstraints;
                final /* synthetic */ Map<MediaSourceDesc, VideoConstraints> $newEffectiveConstraints;
                {
                    this.$oldEffectiveConstraints = $oldEffectiveConstraints;
                    this.$newEffectiveConstraints = $newEffectiveConstraints;
                    super(1);
                }

                public final void invoke(@NotNull EventHandler $this$fireEvent) {
                    Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                    $this$fireEvent.effectiveVideoConstraintsChanged(this.$oldEffectiveConstraints, this.$newEffectiveConstraints);
                }
            });
        }
    }
}

