/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.extensions.bytearray;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.ByteKt;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.utils.ByteArrayUtils;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001f\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\n\u0010\b\u001a\u00020\u0003*\u00020\u0003\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n\u001a\u001a\u0010\f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n\u001a\u0012\u0010\u0010\u001a\u00020\n*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n\u001a\u001a\u0010\u0013\u001a\u00020\n*\u00020\u00032\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n\u001a\u0015\u0010\u0016\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\u0002\u001a\u001a\u0010\u0018\u001a\u00020\u0019*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n\u001a\"\u0010\u001b\u001a\u00020\u0019*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\r\u001a*\u0010\u001e\u001a\u00020\u0019*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\n\u001a\u001a\u0010\"\u001a\u00020\u0019*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n\u001a\u001a\u0010#\u001a\u00020\u0019*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0012\u001a\"\u0010$\u001a\u00020\u0019*\u00020\u00032\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\n\u001a\"\u0010(\u001a\u00020\u0019*\u00020\u00032\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\u0006\u0010)\u001a\u00020\n\u001a\"\u0010*\u001a\u00020\u0019*\u00020\u00032\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\u0006\u0010)\u001a\u00020\n\u001a\u001e\u0010+\u001a\u00020,*\u00020\u00032\b\b\u0002\u0010-\u001a\u00020\n2\b\b\u0002\u0010.\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"HEX_CHARS", "", "byteArrayOf", "", "elements", "", "", "([Ljava/lang/Number;)[B", "cloneFromPool", "get3Bytes", "", "byteIndex", "getBitAsBool", "", "byteOffset", "bitOffset", "getInt", "getShort", "", "hashCodeOfSegment", "start", "end", "plus", "other", "put3Bytes", "", "value", "putBitAsBoolean", "destBitPos", "isSet", "putBits", "src", "", "numBits", "putInt", "putShort", "shiftData", "startPos", "endPos", "delta", "shiftDataLeft", "numBytes", "shiftDataRight", "toHex", "", "offset", "length", "rtp"})
public final class ByteArrayExtensionsKt {
    @NotNull
    private static final char[] HEX_CHARS;

    public static final void putBits(@NotNull byte[] $this$putBits, int byteIndex, int destBitPos, byte src, int numBits) {
        Intrinsics.checkNotNullParameter($this$putBits, "<this>");
        byte by = $this$putBits[byteIndex];
        $this$putBits[byteIndex] = by = ByteKt.putBits(by, destBitPos, numBits, src);
    }

    public static final boolean getBitAsBool(@NotNull byte[] $this$getBitAsBool, int byteOffset, int bitOffset) {
        Intrinsics.checkNotNullParameter($this$getBitAsBool, "<this>");
        return ByteKt.getBitAsBool($this$getBitAsBool[byteOffset], bitOffset);
    }

    public static final void putBitAsBoolean(@NotNull byte[] $this$putBitAsBoolean, int byteIndex, int destBitPos, boolean isSet) {
        Intrinsics.checkNotNullParameter($this$putBitAsBoolean, "<this>");
        byte by = $this$putBitAsBoolean[byteIndex];
        $this$putBitAsBoolean[byteIndex] = by = ByteKt.putBit(by, destBitPos, isSet);
    }

    public static final short getShort(@NotNull byte[] $this$getShort, int byteIndex) {
        Intrinsics.checkNotNullParameter($this$getShort, "<this>");
        return ByteArrayUtils.readShort($this$getShort, byteIndex);
    }

    public static final void putShort(@NotNull byte[] $this$putShort, int byteIndex, short value2) {
        Intrinsics.checkNotNullParameter($this$putShort, "<this>");
        ByteArrayUtils.writeShort($this$putShort, byteIndex, value2);
    }

    public static final int get3Bytes(@NotNull byte[] $this$get3Bytes, int byteIndex) {
        Intrinsics.checkNotNullParameter($this$get3Bytes, "<this>");
        return ByteArrayUtils.readUint24($this$get3Bytes, byteIndex);
    }

    public static final void put3Bytes(@NotNull byte[] $this$put3Bytes, int byteIndex, int value2) {
        Intrinsics.checkNotNullParameter($this$put3Bytes, "<this>");
        ByteArrayUtils.writeUint24($this$put3Bytes, byteIndex, value2);
    }

    public static final int getInt(@NotNull byte[] $this$getInt, int byteIndex) {
        Intrinsics.checkNotNullParameter($this$getInt, "<this>");
        return ByteArrayUtils.readInt($this$getInt, byteIndex);
    }

    public static final void putInt(@NotNull byte[] $this$putInt, int byteIndex, int value2) {
        Intrinsics.checkNotNullParameter($this$putInt, "<this>");
        ByteArrayUtils.writeInt($this$putInt, byteIndex, value2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] byteArrayOf(Number ... elements) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, "elements");
        Number[] $this$map$iv = elements;
        boolean $i$f$map = false;
        Number[] numberArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.byteValue());
        }
        return CollectionsKt.toByteArray((List)destination$iv$iv);
    }

    public static final void shiftDataRight(@NotNull byte[] $this$shiftDataRight, int startPos, int endPos, int numBytes) {
        Intrinsics.checkNotNullParameter($this$shiftDataRight, "<this>");
        if (numBytes < 0) {
            throw new Exception("");
        }
        int index = endPos;
        if (startPos <= index) {
            while (true) {
                $this$shiftDataRight[index + numBytes] = $this$shiftDataRight[index];
                if (index == startPos) break;
                --index;
            }
        }
    }

    public static final void shiftDataLeft(@NotNull byte[] $this$shiftDataLeft, int startPos, int endPos, int numBytes) {
        Intrinsics.checkNotNullParameter($this$shiftDataLeft, "<this>");
        int index = startPos;
        if (index <= endPos) {
            while (true) {
                $this$shiftDataLeft[index - numBytes] = $this$shiftDataLeft[index];
                if (index == endPos) break;
                ++index;
            }
        }
    }

    public static final void shiftData(@NotNull byte[] $this$shiftData, int startPos, int endPos, int delta) {
        Intrinsics.checkNotNullParameter($this$shiftData, "<this>");
        if (delta < 0) {
            ByteArrayExtensionsKt.shiftDataLeft($this$shiftData, startPos, endPos, Math.abs(delta));
        } else if (delta > 0) {
            ByteArrayExtensionsKt.shiftDataRight($this$shiftData, startPos, endPos, delta);
        }
    }

    @NotNull
    public static final byte[] cloneFromPool(@NotNull byte[] $this$cloneFromPool) {
        Intrinsics.checkNotNullParameter($this$cloneFromPool, "<this>");
        byte[] clone = BufferPool.Companion.getGetArray().invoke($this$cloneFromPool.length);
        System.arraycopy($this$cloneFromPool, 0, clone, 0, $this$cloneFromPool.length);
        return clone;
    }

    @NotNull
    public static final byte[] plus(@NotNull byte[] $this$plus, @NotNull byte[] other) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        byte[] newArray = BufferPool.Companion.getGetArray().invoke($this$plus.length + other.length);
        System.arraycopy($this$plus, 0, newArray, 0, $this$plus.length);
        System.arraycopy(other, 0, newArray, $this$plus.length, other.length);
        return newArray;
    }

    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex, int offset, int length) {
        Intrinsics.checkNotNullParameter($this$toHex, "<this>");
        StringBuffer result2 = new StringBuffer();
        int n = RangesKt.coerceAtMost(offset + length, $this$toHex.length);
        for (int i = offset; i < n; ++i) {
            int position = i - offset;
            if (position != 0) {
                if (position % 16 == 0) {
                    result2.append("\n");
                } else if (position % 4 == 0) {
                    result2.append(" ");
                }
            }
            byte by = $this$toHex[i];
            int firstIndex = (by & 0xF0) >> 4;
            int secondIndex = by & 0xF;
            result2.append(HEX_CHARS[firstIndex]);
            result2.append(HEX_CHARS[secondIndex]);
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "result.toString()");
        return string;
    }

    public static /* synthetic */ String toHex$default(byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = byArray.length - n;
        }
        return ByteArrayExtensionsKt.toHex(byArray, n, n2);
    }

    public static final int hashCodeOfSegment(@NotNull byte[] $this$hashCodeOfSegment, int start, int end) {
        Intrinsics.checkNotNullParameter($this$hashCodeOfSegment, "<this>");
        int result2 = 1;
        int n = RangesKt.coerceIn(end, 0, $this$hashCodeOfSegment.length);
        for (int i = RangesKt.coerceIn(start, 0, $this$hashCodeOfSegment.length); i < n; ++i) {
            result2 = 31 * result2 + $this$hashCodeOfSegment[i];
        }
        return result2;
    }

    static {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
        HEX_CHARS = cArray;
    }
}

