/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.outgoing;

import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ModifierNode;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.TccHeaderExtension;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/TccSeqNumTagger;", "Lorg/jitsi/nlj/transform/node/ModifierNode;", "transportCcEngine", "Lorg/jitsi/nlj/rtp/TransportCcEngine;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "(Lorg/jitsi/nlj/rtp/TransportCcEngine;Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;)V", "currTccSeqNum", "", "tccExtensionId", "Ljava/lang/Integer;", "weakTcc", "Ljava/lang/ref/WeakReference;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "modify", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "trace", "", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class TccSeqNumTagger
extends ModifierNode {
    private int currTccSeqNum;
    @Nullable
    private Integer tccExtensionId;
    @NotNull
    private final WeakReference<TransportCcEngine> weakTcc;

    public TccSeqNumTagger(@Nullable TransportCcEngine transportCcEngine, @NotNull ReadOnlyStreamInformationStore streamInformationStore) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        super("TCC sequence number tagger");
        this.currTccSeqNum = 1;
        streamInformationStore.onRtpExtensionMapping(RtpExtensionType.TRANSPORT_CC, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>(){

            @Override
            public final void invoke(@Nullable Integer it) {
                tccExtensionId = it;
            }
        });
        this.weakTcc = new WeakReference<TransportCcEngine>(transportCcEngine);
    }

    public /* synthetic */ TccSeqNumTagger(TransportCcEngine transportCcEngine, ReadOnlyStreamInformationStore readOnlyStreamInformationStore, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            transportCcEngine = null;
        }
        this(transportCcEngine, readOnlyStreamInformationStore);
    }

    @Override
    @NotNull
    protected PacketInfo modify(@NotNull PacketInfo packetInfo) {
        block2: {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            Integer n = this.tccExtensionId;
            if (n == null) break block2;
            int tccExtId = ((Number)n).intValue();
            boolean bl = false;
            RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
            if (rtpPacket instanceof VideoRtpPacket) {
                RtpPacket.HeaderExtension headerExtension = rtpPacket.getHeaderExtension(tccExtId);
                if (headerExtension == null) {
                    headerExtension = rtpPacket.addHeaderExtension(tccExtId, 2);
                }
                RtpPacket.HeaderExtension ext = headerExtension;
                TccHeaderExtension.Companion.setSequenceNumber(ext, this.currTccSeqNum);
                int curSeq = this.currTccSeqNum;
                DataSize len = DataSizeKt.getBytes(rtpPacket.length);
                packetInfo.onSent(new Function0<Unit>(this, curSeq, len){
                    final /* synthetic */ TccSeqNumTagger this$0;
                    final /* synthetic */ int $curSeq;
                    final /* synthetic */ DataSize $len;
                    {
                        this.this$0 = $receiver;
                        this.$curSeq = $curSeq;
                        this.$len = $len;
                        super(0);
                    }

                    public final void invoke() {
                        block0: {
                            TransportCcEngine transportCcEngine = (TransportCcEngine)TccSeqNumTagger.access$getWeakTcc$p(this.this$0).get();
                            if (transportCcEngine == null) break block0;
                            transportCcEngine.mediaPacketSent(this.$curSeq, this.$len);
                        }
                    }
                });
                int n2 = this.currTccSeqNum;
                this.currTccSeqNum = n2 + 1;
            }
        }
        return packetInfo;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d1 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d1.addString("tcc_ext_id", String.valueOf(this.tccExtensionId));
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    public static final /* synthetic */ WeakReference access$getWeakTcc$p(TccSeqNumTagger $this) {
        return $this.weakTcc;
    }
}

