/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.AudioRedPayloadType;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.RedAudioRtpPacket;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.Config;
import org.jitsi.nlj.transform.node.MultipleOutputTransformerNode;
import org.jitsi.nlj.transform.node.RedDistance;
import org.jitsi.nlj.transform.node.RedPolicy;
import org.jitsi.nlj.transform.node.Stats;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.nlj.util.RtpPacketCache;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.extensions.ByteArrayBufferKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.AudioLevelHeaderExtension;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0002#$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001eH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020!H\u0014R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\fR\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\b\u0012\u00060\u0015R\u00020\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jitsi/nlj/transform/node/AudioRedHandler;", "Lorg/jitsi/nlj/transform/node/MultipleOutputTransformerNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "audioLevelExtId", "", "getAudioLevelExtId", "()Ljava/lang/Integer;", "setAudioLevelExtId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "logger", "redPayloadType", "getRedPayloadType", "setRedPayloadType", "ssrcRedHandlers", "", "", "Lorg/jitsi/nlj/transform/node/AudioRedHandler$SsrcRedHandler;", "stats", "Lorg/jitsi/nlj/transform/node/Stats;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "stop", "", "trace", "f", "Lkotlin/Function0;", "transform", "", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "Companion", "SsrcRedHandler", "jitsi-media-transform"})
public final class AudioRedHandler
extends MultipleOutputTransformerNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Stats stats;
    @Nullable
    private Integer audioLevelExtId;
    @Nullable
    private Integer redPayloadType;
    @NotNull
    private final Map<Long, SsrcRedHandler> ssrcRedHandlers;
    @NotNull
    private static final Config config = new Config();

    public AudioRedHandler(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("RedHandler");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.stats = new Stats(0, 0, 0, 0, 0, 0, 0, 127, null);
        this.ssrcRedHandlers = new HashMap();
        streamInformationStore.onRtpPayloadTypesChanged((Function1<? super Map<Byte, ? extends PayloadType>, Unit>)new Function1<Map<Byte, ? extends PayloadType>, Unit>(){

            @Override
            public final void invoke(@NotNull Map<Byte, ? extends PayloadType> payloadTypes) {
                Object v0;
                AudioRedHandler audioRedHandler;
                block1: {
                    Intrinsics.checkNotNullParameter(payloadTypes, "payloadTypes");
                    Iterable iterable = payloadTypes.values();
                    audioRedHandler = this;
                    Iterable iterable2 = iterable;
                    for (Object t : iterable2) {
                        PayloadType it = (PayloadType)t;
                        boolean bl = false;
                        if (!(it instanceof AudioRedPayloadType)) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                PayloadType payloadType = v0;
                audioRedHandler.setRedPayloadType(payloadType != null ? Integer.valueOf(payloadType.getPt()) : null);
            }
        });
        streamInformationStore.onRtpExtensionMapping(RtpExtensionType.SSRC_AUDIO_LEVEL, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>(){

            @Override
            public final void invoke(@Nullable Integer it) {
                this.setAudioLevelExtId(it);
            }
        });
    }

    @Nullable
    public final Integer getAudioLevelExtId() {
        return this.audioLevelExtId;
    }

    public final void setAudioLevelExtId(@Nullable Integer n) {
        this.audioLevelExtId = n;
    }

    @Nullable
    public final Integer getRedPayloadType() {
        return this.redPayloadType;
    }

    public final void setRedPayloadType(@Nullable Integer n) {
        this.redPayloadType = n;
    }

    @Override
    @NotNull
    protected List<PacketInfo> transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Packet packet = packetInfo.getPacket();
        AudioRtpPacket audioRtpPacket = packet instanceof AudioRtpPacket ? (AudioRtpPacket)packet : null;
        if (audioRtpPacket == null) {
            return CollectionsKt.listOf(packetInfo);
        }
        AudioRtpPacket audioPacket = audioRtpPacket;
        SsrcRedHandler ssrcRedHandler = this.ssrcRedHandlers.computeIfAbsent(audioPacket.getSsrc(), arg_0 -> AudioRedHandler.transform$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(ssrcRedHandler, "ssrcRedHandlers.computeI\u2026src) { SsrcRedHandler() }");
        SsrcRedHandler ssrcHandler = ssrcRedHandler;
        return audioPacket instanceof RedAudioRtpPacket ? ssrcHandler.transformRed(packetInfo) : CollectionsKt.listOf(ssrcHandler.transformAudio(packetInfo));
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d1 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        Object object = this.redPayloadType;
        if (object == null || (object = ((Integer)object).toString()) == null) {
            object = "null";
        }
        $this$getNodeStats_u24lambda_u2d1.addString("red_payload_type", (String)object);
        Object object2 = this.audioLevelExtId;
        if (object2 == null || (object2 = ((Integer)object2).toString()) == null) {
            object2 = "null";
        }
        $this$getNodeStats_u24lambda_u2d1.addString("audio_level_ext_id", (String)object2);
        $this$getNodeStats_u24lambda_u2d1.addString("policy", config.getPolicy().toString());
        $this$getNodeStats_u24lambda_u2d1.addString("distance", config.getDistance().toString());
        $this$getNodeStats_u24lambda_u2d1.addBoolean("vad_only", config.getVadOnly());
        $this$getNodeStats_u24lambda_u2d1.addNumber("red_packets_decapsulated", this.stats.getRedPacketsDecapsulated());
        $this$getNodeStats_u24lambda_u2d1.addNumber("red_packets_forwarded", this.stats.getRedPacketsForwarded());
        $this$getNodeStats_u24lambda_u2d1.addNumber("audio_packets_encapsulated", this.stats.getAudioPacketsEncapsulated());
        $this$getNodeStats_u24lambda_u2d1.addNumber("audio_packets_forwarded", this.stats.getAudioPacketsForwarded());
        $this$getNodeStats_u24lambda_u2d1.addNumber("lost_packets_recovered", this.stats.getLostPacketsRecovered());
        $this$getNodeStats_u24lambda_u2d1.addNumber("redundancy_packets_added", this.stats.getRedundancyPacketsAdded());
        $this$getNodeStats_u24lambda_u2d1.addNumber("invalid_red_packets_dropped", this.stats.getInvalidRedPacketsDropped());
        return nodeStatsBlock;
    }

    @Override
    public void stop() {
        Unit unit;
        super.stop();
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        Iterable $this$forEach$iv = this.ssrcRedHandlers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SsrcRedHandler it2 = (SsrcRedHandler)element$iv;
            boolean bl2 = false;
            it2.stop();
        }
        this.ssrcRedHandlers.clear();
    }

    private static final SsrcRedHandler transform$lambda-0(AudioRedHandler this$0, Long it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.new SsrcRedHandler();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0013\u001a\u00020\u0012J\f\u0010\u0016\u001a\u00020\u000e*\u00020\bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/nlj/transform/node/AudioRedHandler$SsrcRedHandler;", "", "(Lorg/jitsi/nlj/transform/node/AudioRedHandler;)V", "sentAudioCache", "Lorg/jitsi/nlj/util/RtpPacketCache;", "getSentAudioCache", "()Lorg/jitsi/nlj/util/RtpPacketCache;", "getPacketToProtect", "Lorg/jitsi/rtp/rtp/RtpPacket;", "seq", "", "primaryTimestamp", "", "vadOnly", "", "stop", "", "transformAudio", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "transformRed", "", "hasVad", "jitsi-media-transform"})
    private final class SsrcRedHandler {
        @NotNull
        private final RtpPacketCache sentAudioCache = new RtpPacketCache(20, true);

        @NotNull
        public final RtpPacketCache getSentAudioCache() {
            return this.sentAudioCache;
        }

        @NotNull
        public final PacketInfo transformAudio(@NotNull PacketInfo packetInfo) {
            boolean bl;
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            switch (WhenMappings.$EnumSwitchMapping$0[Companion.getConfig().getPolicy().ordinal()]) {
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean encapsulate = bl;
            Integer redPayloadType = AudioRedHandler.this.getRedPayloadType();
            if (redPayloadType == null || !encapsulate) {
                AudioRedHandler.this.stats.audioPacketForwarded();
                return packetInfo;
            }
            AudioRtpPacket audioRtpPacket = (AudioRtpPacket)packetInfo.packetAs();
            this.sentAudioCache.insert(audioRtpPacket);
            List redundancy = new ArrayList();
            int seq = audioRtpPacket.getSequenceNumber();
            switch (WhenMappings.$EnumSwitchMapping$1[Companion.getConfig().getDistance().ordinal()]) {
                case 1: {
                    RtpPacket rtpPacket = this.getPacketToProtect(RtpUtils.Companion.applySequenceNumberDelta(seq, -1), audioRtpPacket.getTimestamp(), Companion.getConfig().getVadOnly());
                    if (rtpPacket == null) break;
                    RtpPacket rtpPacket2 = rtpPacket;
                    AudioRedHandler audioRedHandler = AudioRedHandler.this;
                    RtpPacket secondary = rtpPacket2;
                    boolean bl2 = false;
                    redundancy.add(secondary);
                    audioRedHandler.stats.redundancyPacketAdded();
                    break;
                }
                case 2: {
                    RtpPacket rtpPacket = this.getPacketToProtect(RtpUtils.Companion.applySequenceNumberDelta(seq, -1), audioRtpPacket.getTimestamp(), false);
                    if (rtpPacket == null) break;
                    RtpPacket rtpPacket3 = rtpPacket;
                    AudioRedHandler audioRedHandler = AudioRedHandler.this;
                    RtpPacket secondary = rtpPacket3;
                    boolean bl3 = false;
                    RtpPacket tertiary = this.getPacketToProtect(RtpUtils.Companion.applySequenceNumberDelta(seq, -2), audioRtpPacket.getTimestamp(), Companion.getConfig().getVadOnly());
                    if (tertiary != null) {
                        redundancy.add(tertiary);
                        audioRedHandler.stats.redundancyPacketAdded();
                        redundancy.add(secondary);
                        audioRedHandler.stats.redundancyPacketAdded();
                        break;
                    }
                    if (Companion.getConfig().getVadOnly() && !this.hasVad(secondary)) break;
                    redundancy.add(secondary);
                    audioRedHandler.stats.redundancyPacketAdded();
                    break;
                }
            }
            RedAudioRtpPacket redPacket = RedAudioRtpPacket.Companion.getBuilder().build(redPayloadType, audioRtpPacket, redundancy);
            packetInfo.setPacket(redPacket);
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue(audioRtpPacket.buffer, "audioRtpPacket.buffer");
            function1.invoke(audioRtpPacket.buffer);
            AudioRedHandler.this.stats.audioPacketEncapsulated();
            return packetInfo;
        }

        private final RtpPacket getPacketToProtect(int seq, long primaryTimestamp, boolean vadOnly) {
            Object object = this.sentAudioCache.peek(seq);
            if (object != null && (object = (RtpPacket)((ArrayCache.Container)object).getItem()) != null) {
                Object it = object;
                boolean bl = false;
                if (!vadOnly || this.hasVad((RtpPacket)it)) {
                    RtpUtils.Companion companion = RtpUtils.Companion;
                    long b$iv = ((RtpPacket)it).getTimestamp();
                    boolean $i$f$getTimestampDiffAsInt = false;
                    if ((int)(primaryTimestamp - b$iv) <= 16383) {
                        return it;
                    }
                }
            }
            return null;
        }

        private final boolean hasVad(RtpPacket $this$hasVad) {
            boolean bl;
            Integer n = AudioRedHandler.this.getAudioLevelExtId();
            if (n != null) {
                int extId = ((Number)n).intValue();
                boolean bl2 = false;
                RtpPacket.HeaderExtension headerExtension = $this$hasVad.getHeaderExtension(extId);
                if (headerExtension != null) {
                    RtpPacket.HeaderExtension it = headerExtension;
                    boolean bl3 = false;
                    bl = AudioLevelHeaderExtension.Companion.getVad(it);
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public final void stop() {
            this.sentAudioCache.flush();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PacketInfo> transformRed(@NotNull PacketInfo packetInfo) {
            List<PacketInfo> list;
            boolean bl;
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            if (AudioRedHandler.this.getRedPayloadType() == null) {
                bl = true;
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[Companion.getConfig().getPolicy().ordinal()]) {
                    case 2: {
                        bl = true;
                        break;
                    }
                    case 1: 
                    case 3: {
                        bl = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            boolean strip = bl;
            if (strip) {
                List<PacketInfo> list2;
                block15: {
                    void p2;
                    void p1;
                    void p0;
                    Object it;
                    AudioRedHandler audioRedHandler = AudioRedHandler.this;
                    List<PacketInfo> $this$transformRed_u24lambda_u2d6 = list2 = CollectionsKt.createListBuilder();
                    boolean bl2 = false;
                    RedAudioRtpPacket redPacket = (RedAudioRtpPacket)packetInfo.packetAs();
                    int seq = redPacket.getSequenceNumber();
                    int prev = RtpUtils.Companion.applySequenceNumberDelta(seq, -1);
                    int prev2 = RtpUtils.Companion.applySequenceNumberDelta(seq, -2);
                    boolean prevMissing = !this.sentAudioCache.contains(prev);
                    boolean prev2Missing = !this.sentAudioCache.contains(prev2);
                    try {
                        if (prevMissing || prev2Missing) {
                            Iterable $this$forEach$iv = redPacket.removeRedAndGetRedundancyPackets();
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (AudioRtpPacket)element$iv;
                                boolean bl3 = false;
                                if (((RtpPacket)it).getSequenceNumber() == prev && prevMissing || ((RtpPacket)it).getSequenceNumber() == prev2 && prev2Missing) {
                                    $this$transformRed_u24lambda_u2d6.add(new PacketInfo((Packet)it, null, 2, null));
                                    audioRedHandler.stats.lostPacketRecovered();
                                }
                                this.sentAudioCache.insert((RtpPacket)it);
                            }
                        } else {
                            redPacket.removeRed();
                        }
                    }
                    catch (IllegalArgumentException e) {
                        audioRedHandler.logger.warn("Dropping invalid RED packet from ep=" + packetInfo.getEndpointId() + " (" + e.getMessage() + "): " + redPacket + ". Contents (50B): " + ByteArrayBufferKt.toHex(redPacket, 50));
                        audioRedHandler.stats.invalidRedPacketDropped();
                        break block15;
                    }
                    audioRedHandler.stats.redPacketDecapsulated();
                    Packet this_$iv = redPacket;
                    boolean $i$f$toOtherType = false;
                    Intrinsics.checkNotNullExpressionValue(this_$iv.buffer, "buffer");
                    int n = this_$iv.length;
                    int element$iv = this_$iv.offset;
                    it = this_$iv.buffer;
                    PacketInfo packetInfo2 = packetInfo;
                    boolean bl4 = false;
                    packetInfo2.setPacket(new AudioRtpPacket((byte[])p0, (int)p1, (int)p2));
                    if (!this.sentAudioCache.contains(seq)) {
                        this.sentAudioCache.insert((RtpPacket)packetInfo.packetAs());
                        $this$transformRed_u24lambda_u2d6.add(packetInfo);
                    }
                }
                list = CollectionsKt.build(list2);
            } else {
                AudioRedHandler.this.stats.redPacketForwarded();
                list = CollectionsKt.listOf(packetInfo);
            }
            return list;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[RedPolicy.values().length];
                nArray[RedPolicy.NOOP.ordinal()] = 1;
                nArray[RedPolicy.STRIP.ordinal()] = 2;
                nArray[RedPolicy.PROTECT_ALL.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[RedDistance.values().length];
                nArray[RedDistance.ONE.ordinal()] = 1;
                nArray[RedDistance.TWO.ordinal()] = 2;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/transform/node/AudioRedHandler$Companion;", "", "()V", "config", "Lorg/jitsi/nlj/transform/node/Config;", "getConfig", "()Lorg/jitsi/nlj/transform/node/Config;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Config getConfig() {
            return config;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

