/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.srtp;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.srtp.SrtcpDecryptTransformer;
import org.jitsi.nlj.srtp.SrtcpEncryptTransformer;
import org.jitsi.nlj.srtp.SrtpConfig;
import org.jitsi.nlj.srtp.SrtpDecryptTransformer;
import org.jitsi.nlj.srtp.SrtpEncryptTransformer;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.srtp.SrtpContextFactory;
import org.jitsi.srtp.SrtpPolicy;
import org.jitsi.srtp.crypto.Aes;
import org.jitsi.utils.logging2.Logger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jitsi/nlj/srtp/SrtpUtil;", "", "()V", "Companion", "jitsi-media-transform"})
public final class SrtpUtil {
    @NotNull
    public static final Companion Companion;

    static {
        block0: {
            Companion = new Companion(null);
            String string = SrtpConfig.Companion.getFactoryClass();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            Aes.setFactoryClassName(it);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/nlj/srtp/SrtpUtil$Companion;", "", "()V", "getSrtpProfileInformationFromSrtpProtectionProfile", "Lorg/jitsi/nlj/srtp/SrtpProfileInformation;", "srtpProtectionProfile", "", "getSrtpProtectionProfileFromName", "profileName", "", "initializeTransformer", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "srtpProfileInformation", "keyingMaterial", "", "tlsRole", "Lorg/jitsi/nlj/srtp/TlsRole;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final int getSrtpProtectionProfileFromName(@NotNull String profileName) {
            int n;
            Intrinsics.checkNotNullParameter(profileName, "profileName");
            switch (profileName) {
                case "SRTP_AES128_CM_HMAC_SHA1_80": {
                    n = 1;
                    break;
                }
                case "SRTP_AES128_CM_HMAC_SHA1_32": {
                    n = 2;
                    break;
                }
                case "SRTP_NULL_HMAC_SHA1_32": {
                    n = 6;
                    break;
                }
                case "SRTP_NULL_HMAC_SHA1_80": {
                    n = 5;
                    break;
                }
                case "SRTP_AEAD_AES_128_GCM": {
                    n = 7;
                    break;
                }
                case "SRTP_AEAD_AES_256_GCM": {
                    n = 8;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SRTP protection profile: " + profileName);
                }
            }
            return n;
        }

        @NotNull
        public final SrtpProfileInformation getSrtpProfileInformationFromSrtpProtectionProfile(int srtpProtectionProfile) {
            SrtpProfileInformation srtpProfileInformation;
            switch (srtpProtectionProfile) {
                case 2: {
                    srtpProfileInformation = new SrtpProfileInformation(16, 14, 1, 1, 20, 10, 4);
                    break;
                }
                case 1: {
                    srtpProfileInformation = new SrtpProfileInformation(16, 14, 1, 1, 20, 10, 10);
                    break;
                }
                case 6: {
                    srtpProfileInformation = new SrtpProfileInformation(0, 0, 0, 1, 20, 10, 4);
                    break;
                }
                case 5: {
                    srtpProfileInformation = new SrtpProfileInformation(0, 0, 0, 1, 20, 10, 10);
                    break;
                }
                case 7: {
                    srtpProfileInformation = new SrtpProfileInformation(16, 12, 5, 0, 0, 16, 16);
                    break;
                }
                case 8: {
                    srtpProfileInformation = new SrtpProfileInformation(32, 12, 5, 0, 0, 16, 16);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SRTP protection profile: " + srtpProtectionProfile);
                }
            }
            return srtpProfileInformation;
        }

        @NotNull
        public final SrtpTransformers initializeTransformer(@NotNull SrtpProfileInformation srtpProfileInformation, @NotNull byte[] keyingMaterial, @NotNull TlsRole tlsRole, @NotNull Logger parentLogger) {
            Intrinsics.checkNotNullParameter(srtpProfileInformation, "srtpProfileInformation");
            Intrinsics.checkNotNullParameter(keyingMaterial, "keyingMaterial");
            Intrinsics.checkNotNullParameter((Object)tlsRole, "tlsRole");
            Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
            byte[] clientWriteSrtpMasterKey = new byte[srtpProfileInformation.getCipherKeyLength()];
            byte[] serverWriteSrtpMasterKey = new byte[srtpProfileInformation.getCipherKeyLength()];
            byte[] clientWriterSrtpMasterSalt = new byte[srtpProfileInformation.getCipherSaltLength()];
            byte[] serverWriterSrtpMasterSalt = new byte[srtpProfileInformation.getCipherSaltLength()];
            byte[][] byArrayArray = new byte[][]{clientWriteSrtpMasterKey, serverWriteSrtpMasterKey, clientWriterSrtpMasterSalt, serverWriterSrtpMasterSalt};
            List<Object> keyingMaterialValues = CollectionsKt.listOf((Object[])byArrayArray);
            int keyingMaterialOffset = 0;
            int n = keyingMaterialValues.size();
            for (int i = 0; i < n; ++i) {
                byte[] keyingMaterialValue = (byte[])keyingMaterialValues.get(i);
                System.arraycopy(keyingMaterial, keyingMaterialOffset, keyingMaterialValue, 0, keyingMaterialValue.length);
                keyingMaterialOffset += keyingMaterialValue.length;
            }
            SrtpPolicy srtcpPolicy = new SrtpPolicy(srtpProfileInformation.getCipherName(), srtpProfileInformation.getCipherKeyLength(), srtpProfileInformation.getAuthFunctionName(), srtpProfileInformation.getAuthKeyLength(), srtpProfileInformation.getRtcpAuthTagLength(), srtpProfileInformation.getCipherSaltLength());
            SrtpPolicy srtpPolicy = new SrtpPolicy(srtpProfileInformation.getCipherName(), srtpProfileInformation.getCipherKeyLength(), srtpProfileInformation.getAuthFunctionName(), srtpProfileInformation.getAuthKeyLength(), srtpProfileInformation.getRtpAuthTagLength(), srtpProfileInformation.getCipherSaltLength());
            srtpPolicy.setSendReplayEnabled(false);
            SrtpContextFactory clientSrtpContextFactory = new SrtpContextFactory(tlsRole == TlsRole.CLIENT, clientWriteSrtpMasterKey, clientWriterSrtpMasterSalt, srtpPolicy, srtcpPolicy, parentLogger);
            SrtpContextFactory serverSrtpContextFactory = new SrtpContextFactory(tlsRole == TlsRole.SERVER, serverWriteSrtpMasterKey, serverWriterSrtpMasterSalt, srtpPolicy, srtcpPolicy, parentLogger);
            SrtpContextFactory forwardSrtpContextFactory = null;
            SrtpContextFactory reverseSrtpContextFactory = null;
            switch (WhenMappings.$EnumSwitchMapping$0[tlsRole.ordinal()]) {
                case 1: {
                    forwardSrtpContextFactory = clientSrtpContextFactory;
                    reverseSrtpContextFactory = serverSrtpContextFactory;
                    break;
                }
                case 2: {
                    forwardSrtpContextFactory = serverSrtpContextFactory;
                    reverseSrtpContextFactory = clientSrtpContextFactory;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return new SrtpTransformers(new SrtpDecryptTransformer(reverseSrtpContextFactory, parentLogger), new SrtpEncryptTransformer(forwardSrtpContextFactory, parentLogger), new SrtcpDecryptTransformer(reverseSrtpContextFactory, parentLogger), new SrtcpEncryptTransformer(forwardSrtpContextFactory, parentLogger));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TlsRole.values().length];
                nArray[TlsRole.CLIENT.ordinal()] = 1;
                nArray[TlsRole.SERVER.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

