/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.NodeStatsProducer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0019\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u000eR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/nlj/MediaSources;", "Lorg/jitsi/nlj/transform/NodeStatsProducer;", "()V", "sources", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "[Lorg/jitsi/nlj/MediaSourceDesc;", "getMediaSources", "()[Lorg/jitsi/nlj/MediaSourceDesc;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "setMediaSources", "", "newSources", "([Lorg/jitsi/nlj/MediaSourceDesc;)Z", "jitsi-media-transform"})
public final class MediaSources
implements NodeStatsProducer {
    @NotNull
    private MediaSourceDesc[] sources = new MediaSourceDesc[0];

    public final boolean setMediaSources(@NotNull MediaSourceDesc[] newSources) {
        Intrinsics.checkNotNullParameter(newSources, "newSources");
        MediaSourceDesc[] oldSources = this.sources;
        if (oldSources.length == 0 || newSources.length == 0) {
            this.sources = newSources;
            return oldSources.length != newSources.length;
        }
        int cntMatched = 0;
        int n = newSources.length;
        MediaSourceDesc[] mediaSourceDescArray = new MediaSourceDesc[n];
        for (int i = 0; i < n; ++i) {
            MediaSourceDesc mediaSourceDesc;
            block3: {
                int n2;
                int n3 = n2 = i;
                MediaSourceDesc[] mediaSourceDescArray2 = mediaSourceDescArray;
                long newPrimarySSRC = newSources[n2].getPrimarySSRC();
                int n4 = oldSources.length;
                for (int j = 0; j < n4; ++j) {
                    if (!oldSources[j].matches(newPrimarySSRC)) continue;
                    ++cntMatched;
                    mediaSourceDesc = oldSources[j];
                    break block3;
                }
                mediaSourceDesc = newSources[n2];
            }
            mediaSourceDescArray2[n3] = mediaSourceDesc;
        }
        MediaSourceDesc[] mergedSources = mediaSourceDescArray;
        this.sources = mergedSources;
        return oldSources.length != newSources.length || cntMatched != oldSources.length;
    }

    @NotNull
    public final MediaSourceDesc[] getMediaSources() {
        return this.sources;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d2 = nodeStatsBlock = new NodeStatsBlock("MediaStreamSources");
        boolean bl = false;
        MediaSourceDesc[] $this$forEachIndexed$iv = this.sources;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (MediaSourceDesc item$iv : $this$forEachIndexed$iv) {
            void source;
            int n = index$iv++;
            MediaSourceDesc mediaSourceDesc = item$iv;
            int i = n;
            boolean bl2 = false;
            NodeStatsBlock sourceBlock = new NodeStatsBlock("source_" + i);
            sourceBlock.addString("owner", source.getOwner());
            sourceBlock.addString("name", source.getSourceName());
            sourceBlock.addString("video_type", source.getVideoType().toString());
            RtpEncodingDesc[] $this$forEach$iv = source.getRtpEncodings();
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int j = 0; j < n2; ++j) {
                RtpEncodingDesc element$iv;
                RtpEncodingDesc it = element$iv = $this$forEach$iv[j];
                boolean bl3 = false;
                sourceBlock.addBlock(it.getNodeStats());
            }
            $this$getNodeStats_u24lambda_u2d2.addBlock(sourceBlock);
        }
        return nodeStatsBlock;
    }
}

