/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpEncodingDescKt;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.VideoType;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.utils.ArrayUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010$\u001a\u00020\u0000J\u0010\u0010%\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020\u0010J\u0010\u0010'\u001a\u0004\u0018\u00010\r2\u0006\u0010(\u001a\u00020)J&\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u0013\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b.\u0010/J\u0010\u00100\u001a\u0004\u0018\u00010\r2\u0006\u0010-\u001a\u00020\u0013J\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u0002022\u0006\u0010&\u001a\u00020\u0010J\u0006\u00104\u001a\u00020\u0013J!\u00105\u001a\u0002062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u00032\u0006\u0010&\u001a\u00020\u0010\u00a2\u0006\u0002\u00107J\b\u00108\u001a\u00020\u0006H\u0016J\b\u00109\u001a\u000206H\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006:"}, d2={"Lorg/jitsi/nlj/MediaSourceDesc;", "", "rtpEncodings", "", "Lorg/jitsi/nlj/RtpEncodingDesc;", "owner", "", "sourceName", "videoType", "Lorg/jitsi/nlj/VideoType;", "([Lorg/jitsi/nlj/RtpEncodingDesc;Ljava/lang/String;Ljava/lang/String;Lorg/jitsi/nlj/VideoType;)V", "layers", "", "Lorg/jitsi/nlj/RtpLayerDesc;", "layersById", "", "", "layersByIndex", "Ljava/util/NavigableMap;", "", "getOwner", "()Ljava/lang/String;", "primarySSRC", "getPrimarySSRC", "()J", "getRtpEncodings", "()[Lorg/jitsi/nlj/RtpEncodingDesc;", "[Lorg/jitsi/nlj/RtpEncodingDesc;", "rtpLayers", "getRtpLayers", "()Ljava/util/List;", "getSourceName", "getVideoType", "()Lorg/jitsi/nlj/VideoType;", "setVideoType", "(Lorg/jitsi/nlj/VideoType;)V", "copy", "findRtpEncodingDesc", "ssrc", "findRtpLayerDesc", "videoRtpPacket", "Lorg/jitsi/nlj/rtp/VideoRtpPacket;", "getBitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "nowMs", "idx", "getBitrate-MxRVi0s", "(JI)D", "getRtpLayerByQualityIdx", "hasRtpLayers", "", "matches", "numRtpLayers", "setEncodingLayers", "", "([Lorg/jitsi/nlj/RtpLayerDesc;J)V", "toString", "updateLayerCache", "jitsi-media-transform"})
@SuppressFBWarnings(value={"NP_ALWAYS_NULL"}, justification="False positives with 'lateinit'.")
public final class MediaSourceDesc {
    @NotNull
    private final RtpEncodingDesc[] rtpEncodings;
    @NotNull
    private final String owner;
    @NotNull
    private final String sourceName;
    @NotNull
    private VideoType videoType;
    private List<? extends RtpLayerDesc> layers;
    @NotNull
    private final Map<Long, RtpLayerDesc> layersById;
    @NotNull
    private final NavigableMap<Integer, RtpLayerDesc> layersByIndex;

    @JvmOverloads
    public MediaSourceDesc(@NotNull RtpEncodingDesc[] rtpEncodings, @NotNull String owner, @NotNull String sourceName, @NotNull VideoType videoType) {
        Intrinsics.checkNotNullParameter(rtpEncodings, "rtpEncodings");
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(sourceName, "sourceName");
        Intrinsics.checkNotNullParameter((Object)videoType, "videoType");
        this.rtpEncodings = rtpEncodings;
        this.owner = owner;
        this.sourceName = sourceName;
        this.videoType = videoType;
        this.layersById = new HashMap();
        this.layersByIndex = new TreeMap();
        this.updateLayerCache();
    }

    public /* synthetic */ MediaSourceDesc(RtpEncodingDesc[] rtpEncodingDescArray, String string, String string2, VideoType videoType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            videoType = VideoType.CAMERA;
        }
        this(rtpEncodingDescArray, string, string2, videoType);
    }

    @NotNull
    public final RtpEncodingDesc[] getRtpEncodings() {
        return this.rtpEncodings;
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    @NotNull
    public final String getSourceName() {
        return this.sourceName;
    }

    @NotNull
    public final VideoType getVideoType() {
        return this.videoType;
    }

    public final void setVideoType(@NotNull VideoType videoType) {
        Intrinsics.checkNotNullParameter((Object)videoType, "<set-?>");
        this.videoType = videoType;
    }

    @NotNull
    public final synchronized List<RtpLayerDesc> getRtpLayers() {
        List<RtpLayerDesc> list = this.layers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("layers");
            list = null;
        }
        return list;
    }

    private final void updateLayerCache() {
        this.layersById.clear();
        this.layersByIndex.clear();
        ArrayList<RtpLayerDesc> layers_ = new ArrayList<RtpLayerDesc>();
        for (RtpEncodingDesc encoding : this.rtpEncodings) {
            for (RtpLayerDesc layer : encoding.getLayers$jitsi_media_transform()) {
                this.layersById.put(encoding.encodingId(layer), layer);
                ((Map)this.layersByIndex).put(layer.getIndex(), layer);
                layers_.add(layer);
            }
        }
        List list = Collections.unmodifiableList((List)layers_);
        Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(layers_)");
        this.layers = list;
    }

    public final double getBitrate-MxRVi0s(long nowMs, int idx) {
        NavigableMap<Integer, RtpLayerDesc> navigableMap = this.layersByIndex.headMap(idx, true).descendingMap();
        Intrinsics.checkNotNullExpressionValue(navigableMap, "layersByIndex.headMap(idx, true).descendingMap()");
        for (Map.Entry entry : ((Map)navigableMap).entrySet()) {
            double bitrate = ((RtpLayerDesc)entry.getValue()).getBitrate-WElJv5I(nowMs);
            if (!(bitrate > 0.0)) continue;
            return bitrate;
        }
        return BandwidthKt.getBps(0);
    }

    public final synchronized boolean hasRtpLayers() {
        List<? extends RtpLayerDesc> list = this.layers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("layers");
            list = null;
        }
        return !((Collection)list).isEmpty();
    }

    public final synchronized int numRtpLayers() {
        return this.layersByIndex.size();
    }

    public final long getPrimarySSRC() {
        return this.rtpEncodings[0].getPrimarySSRC();
    }

    @Nullable
    public final synchronized RtpLayerDesc getRtpLayerByQualityIdx(int idx) {
        return (RtpLayerDesc)this.layersByIndex.get(idx);
    }

    @Nullable
    public final synchronized RtpLayerDesc findRtpLayerDesc(@NotNull VideoRtpPacket videoRtpPacket) {
        Intrinsics.checkNotNullParameter(videoRtpPacket, "videoRtpPacket");
        if (ArrayUtils.isNullOrEmpty(this.rtpEncodings)) {
            return null;
        }
        long encodingId = RtpEncodingDescKt.getEncodingId(videoRtpPacket);
        RtpLayerDesc desc = this.layersById.get(encodingId);
        return desc;
    }

    @Nullable
    public final synchronized RtpEncodingDesc findRtpEncodingDesc(long ssrc2) {
        RtpEncodingDesc rtpEncodingDesc;
        block1: {
            RtpEncodingDesc[] rtpEncodingDescArray = this.rtpEncodings;
            int n = rtpEncodingDescArray.length;
            for (int i = 0; i < n; ++i) {
                RtpEncodingDesc rtpEncodingDesc2;
                RtpEncodingDesc it = rtpEncodingDesc2 = rtpEncodingDescArray[i];
                boolean bl = false;
                if (!it.matches(ssrc2)) continue;
                rtpEncodingDesc = rtpEncodingDesc2;
                break block1;
            }
            rtpEncodingDesc = null;
        }
        return rtpEncodingDesc;
    }

    public final synchronized void setEncodingLayers(@NotNull RtpLayerDesc[] layers, long ssrc2) {
        Intrinsics.checkNotNullParameter(layers, "layers");
        RtpEncodingDesc rtpEncodingDesc = this.findRtpEncodingDesc(ssrc2);
        if (rtpEncodingDesc == null) {
            return;
        }
        RtpEncodingDesc enc = rtpEncodingDesc;
        enc.setLayers$jitsi_media_transform(layers);
        this.updateLayerCache();
    }

    @NotNull
    public final synchronized MediaSourceDesc copy() {
        int n = 0;
        int n2 = this.rtpEncodings.length;
        RtpEncodingDesc[] rtpEncodingDescArray = new RtpEncodingDesc[n2];
        while (n < n2) {
            int n3 = n++;
            rtpEncodingDescArray[n3] = RtpEncodingDesc.copy$default(this.rtpEncodings[n3], 0L, null, 3, null);
        }
        VideoType videoType = this.videoType;
        String string = this.sourceName;
        String string2 = this.owner;
        RtpEncodingDesc[] rtpEncodingDescArray2 = rtpEncodingDescArray;
        return new MediaSourceDesc(rtpEncodingDescArray2, string2, string, videoType);
    }

    @NotNull
    public String toString() {
        return "MediaSourceDesc[name=" + this.sourceName + " owner=" + this.owner + ", videoType=" + this.videoType + ", encodings=" + ArraysKt.joinToString$default(this.rtpEncodings, (CharSequence)",", null, null, 0, null, null, 62, null) + "]";
    }

    public final boolean matches(long ssrc2) {
        RtpEncodingDesc rtpEncodingDesc = ArraysKt.getOrNull(this.rtpEncodings, 0);
        return rtpEncodingDesc != null ? rtpEncodingDesc.getPrimarySSRC() == ssrc2 : false;
    }

    @JvmOverloads
    public MediaSourceDesc(@NotNull RtpEncodingDesc[] rtpEncodings, @NotNull String owner, @NotNull String sourceName) {
        Intrinsics.checkNotNullParameter(rtpEncodings, "rtpEncodings");
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(sourceName, "sourceName");
        this(rtpEncodings, owner, sourceName, null, 8, null);
    }
}

