/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.GetItemsRequest;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.PublishItem;
import org.jivesoftware.smackx.pubsub.packet.PubSub;

public class LeafNode
extends Node {
    LeafNode(PubSubManager pubSubManager, String nodeId) {
        super(pubSubManager, nodeId);
    }

    public DiscoverItems discoverItems() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems items = new DiscoverItems();
        items.setTo(this.pubSubManager.getServiceJid());
        items.setNode(this.getId());
        return (DiscoverItems)this.pubSubManager.getConnection().createStanzaCollectorAndSend(items).nextResultOrThrow();
    }

    public <T extends Item> List<T> getItems() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getItems((List<ExtensionElement>)null, null);
    }

    public <T extends Item> List<T> getItems(String subscriptionId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub request = this.createPubsubPacket(IQ.Type.get, new GetItemsRequest(this.getId(), subscriptionId));
        return this.getItems(request);
    }

    public <T extends Item> List<T> getItems(Collection<String> ids) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ArrayList<Item> itemList = new ArrayList<Item>(ids.size());
        for (String id : ids) {
            itemList.add(new Item(id));
        }
        PubSub request = this.createPubsubPacket(IQ.Type.get, new ItemsExtension(ItemsExtension.ItemsElementType.items, this.getId(), itemList));
        return this.getItems(request);
    }

    public <T extends Item> List<T> getItems(int maxItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub request = this.createPubsubPacket(IQ.Type.get, new GetItemsRequest(this.getId(), maxItems));
        return this.getItems(request);
    }

    public <T extends Item> List<T> getItems(int maxItems, String subscriptionId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub request = this.createPubsubPacket(IQ.Type.get, new GetItemsRequest(this.getId(), subscriptionId, maxItems));
        return this.getItems(request);
    }

    public <T extends Item> List<T> getItems(List<ExtensionElement> additionalExtensions, List<ExtensionElement> returnedExtensions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub request = this.createPubsubPacket(IQ.Type.get, new GetItemsRequest(this.getId()));
        request.addExtensions(additionalExtensions);
        return this.getItems(request, returnedExtensions);
    }

    private <T extends Item> List<T> getItems(PubSub request) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getItems(request, null);
    }

    private <T extends Item> List<T> getItems(PubSub request, List<ExtensionElement> returnedExtensions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub result2 = (PubSub)this.pubSubManager.getConnection().createStanzaCollectorAndSend(request).nextResultOrThrow();
        ItemsExtension itemsElem = (ItemsExtension)result2.getExtension(PubSubElementType.ITEMS);
        if (returnedExtensions != null) {
            returnedExtensions.addAll(result2.getExtensions());
        }
        return itemsElem.getItems();
    }

    @Deprecated
    public void send() throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException {
        this.publish();
    }

    @Deprecated
    public <T extends Item> void send(T item) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException {
        this.publish(item);
    }

    @Deprecated
    public <T extends Item> void send(Collection<T> items) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException {
        this.publish(items);
    }

    public void publish() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub packet = this.createPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.PUBLISH, this.getId()));
        this.pubSubManager.getConnection().createStanzaCollectorAndSend(packet).nextResultOrThrow();
    }

    public <T extends Item> void publish(T item) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ArrayList<T> items = new ArrayList<T>(1);
        items.add(item == null ? new Item() : item);
        this.publish(items);
    }

    public <T extends Item> void publish(Collection<T> items) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub packet = this.createPubsubPacket(IQ.Type.set, new PublishItem<T>(this.getId(), items));
        this.pubSubManager.getConnection().createStanzaCollectorAndSend(packet).nextResultOrThrow();
    }

    public void deleteAllItems() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub request = this.createPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.PURGE_OWNER, this.getId()));
        this.pubSubManager.getConnection().createStanzaCollectorAndSend(request).nextResultOrThrow();
    }

    public void deleteItem(String itemId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ArrayList<String> items = new ArrayList<String>(1);
        items.add(itemId);
        this.deleteItem(items);
    }

    public void deleteItem(Collection<String> itemIds) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ArrayList<Item> items = new ArrayList<Item>(itemIds.size());
        for (String id : itemIds) {
            items.add(new Item(id));
        }
        PubSub request = this.createPubsubPacket(IQ.Type.set, new ItemsExtension(ItemsExtension.ItemsElementType.retract, this.getId(), items));
        this.pubSubManager.getConnection().createStanzaCollectorAndSend(request).nextResultOrThrow();
    }
}

