
(define-library (srfi 160 s64)
  (export
   make-s64vector
   s64?
   s64vector?
   s64vector-ref
   s64vector-set!
   s64vector-length
   (rename uvector-unfold s64vector-unfold)
   (rename uvector-unfold-right s64vector-unfold-right)
   (rename vector-copy s64vector-copy)
   (rename vector-reverse-copy s64vector-reverse-copy)
   (rename vector-append s64vector-append)
   (rename vector-concatenate s64vector-concatenate)
   (rename vector-append-subvectors s64vector-append-subvectors)
   (rename vector-empty? s64vector-empty?)
   (rename vector= s64vector=)
   (rename vector-take s64vector-take)
   (rename vector-take-right s64vector-take-right)
   (rename vector-drop s64vector-drop)
   (rename vector-drop-right s64vector-drop-right)
   (rename vector-segment s64vector-segment)
   (rename vector-fold s64vector-fold)
   (rename vector-fold-right s64vector-fold-right)
   (rename vector-map s64vector-map)
   (rename vector-map! s64vector-map!)
   (rename vector-for-each s64vector-for-each)
   (rename vector-count s64vector-count)
   (rename vector-cumulate s64vector-cumulate)
   (rename vector-take-while s64vector-take-while)
   (rename vector-take-while-right s64vector-take-while-right)
   (rename vector-drop-while s64vector-drop-while)
   (rename vector-drop-while-right s64vector-drop-while-right)
   (rename vector-index s64vector-index)
   (rename vector-index-right s64vector-index-right)
   (rename vector-skip s64vector-skip)
   (rename vector-skip-right s64vector-skip-right)
   (rename vector-binary-search s64vector-binary-search)
   (rename vector-any s64vector-any)
   (rename vector-every s64vector-every)
   (rename vector-partition s64vector-partition)
   (rename vector-filter s64vector-filter)
   (rename vector-remove s64vector-remove)
   (rename vector-swap! s64vector-swap!)
   (rename vector-fill! s64vector-fill!)
   (rename vector-reverse! s64vector-reverse!)
   (rename vector-copy! s64vector-copy!)
   (rename vector-reverse-copy! s64vector-reverse-copy!)
   (rename reverse-vector->list reverse-s64vector->list)
   (rename reverse-list->vector reverse-list->s64vector)
   (rename uvector->vector s64vector->vector)
   (rename vector->uvector vector->s64vector)
   (rename make-vector-generator make-s64vector-generator)
   (rename write-vector write-s64vector))
  (import (except (scheme base)
                  vector-append vector-copy vector-copy!
                  vector-map vector-for-each)
          (scheme write)
          (srfi 160 base))
  (begin
    (define uvector? s64vector?)
    (define make-uvector make-s64vector)
    (define vector s64vector)
    (define uvector->list s64vector->list)
    (define list->uvector list->s64vector)
    (define uvector->list s64vector->list)
    (define uvector-length s64vector-length)
    (define uvector-ref s64vector-ref)
    (define uvector-set! s64vector-set!))
  (include "uvector.scm"))
