/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.security.util.PortMapper;
import org.springframework.util.Assert;

public class PortMapperImpl
implements PortMapper {
    private Map httpsPortMappings = new HashMap();

    public PortMapperImpl() {
        this.httpsPortMappings.put(new Integer(80), new Integer(443));
        this.httpsPortMappings.put(new Integer(8080), new Integer(8443));
    }

    public Map getTranslatedPortMappings() {
        return this.httpsPortMappings;
    }

    public Integer lookupHttpPort(Integer httpsPort) {
        Iterator iter = this.httpsPortMappings.keySet().iterator();
        while (iter.hasNext()) {
            Integer httpPort = (Integer)iter.next();
            if (!this.httpsPortMappings.get(httpPort).equals(httpsPort)) continue;
            return httpPort;
        }
        return null;
    }

    public Integer lookupHttpsPort(Integer httpPort) {
        return (Integer)this.httpsPortMappings.get(httpPort);
    }

    public void setPortMappings(Map newMappings) {
        Assert.notNull((Object)newMappings, (String)"A valid list of HTTPS port mappings must be provided");
        this.httpsPortMappings.clear();
        Iterator it = newMappings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Integer httpPort = new Integer((String)entry.getKey());
            Integer httpsPort = new Integer((String)entry.getValue());
            if (httpPort < 1 || httpPort > 65535 || httpsPort < 1 || httpsPort > 65535) {
                throw new IllegalArgumentException("one or both ports out of legal range: " + httpPort + ", " + httpsPort);
            }
            this.httpsPortMappings.put(httpPort, httpsPort);
        }
        if (this.httpsPortMappings.size() < 1) {
            throw new IllegalArgumentException("must map at least one port");
        }
    }
}

