# ChangeLog

## 6.2.0 (2023-02-08)
- implement `JsonSerializer()` to allow serializing session data to/from JSON
  instead of native PHP serialization

## 6.1.0 (2022-11-07)
- switch to `fkooman/put` for unit testing
- Add `Makefile`
- update (C) year
- update `cron` example in README

## 6.0.0 (2021-12-21)
- major refactor touching almost all code
- require PHP >= 7.4
- drop requirement for polyfills
- remove session locking, instead create new session every time a session value
  changes (i.e. _implicit regenerate_)
- add `PdoSessionStorage` for storing sessions in databases supported by `PDO`
- add `MemcacheSessionStorage` for storing sessions in memcached

## 5.0.2 (2021-02-23)
- handle empty session file

## 5.0.1 (2020-08-09)
- restore use of `paragonie/constant_time_encoding` for now
- update README

## 5.0.0 (2020-07-28)
- remove built-in session garbage collection as it does not work on 
  Debian/Ubuntu
- document in README.md how to do garbage collection
- try `sodium_bin2hex`, `\Sodium\bin2hex`, `bin2hex`, in that order, to encode 
  the session identifier

## 4.0.1 (2020-07-20)
- drop `paragonie/constant_time_encoding` dependency and use `sodium_bin2hex` 
  when available

## 4.0.0 (2020-02-03)
- when `CookieOptions::setSameSite('None')` is used, the same cookie is also 
  sent without `SameSite` attribute for browsers that interpret `None` as 
  `Strict`, most notably iOS 12 devices
- no longer have the option to disable setting `SameSite`, it has to be either
  `None`, `Lax` or `Strict`
- make `CookieOptions` and `SessionOptions` immutable and rename "setters" to
  "withers"
- introduce `CookieOptions::withSameSiteNone()`, 
  `CookieOptions::withSameSiteLax()` and `CookieOptions::withSameSiteStrict()`
  instead of string parameter for `CookieOptions::setSameSite()`
- have `CookieOptions::withInsecure()` instead of bool parameter to 
  `CookieOptions::setSecure()`

## 3.0.1 (2020-01-29)
- use `Hex::encode()` from `paragonie/constant_time_encoding` for constant time
  hex encoding of session cookies

## 3.0.0 (2020-01-27)
- completely rewrite the library to use custom session handling without relying
  on PHP's built-in session and cookie support

## 2.0.1 (2018-06-02)
- add support for newer versions of PHPUnit
- update (C)
- update source formatting

## 2.0.0 (2017-09-10)
- change `Session` constructor to take `Cookie` instance instead of 
  `HeaderInterface` to have a much cleaner implementation and separation of 
  `Cookie` and `Session`. See [README.md](README.md) for the updated
  documentation
- Fix issues found by [Psalm](https://getpsalm.org/)

## 1.0.2 (2017-08-08)
- fix possible duplicate `Max-Age` when deleting cookie

## 1.0.1 (2017-08-07)
- `Cookie::delete` will set `Max-Age=0` telling the browser to delete the 
  cookie (#1)

## 1.0.0 (2017-06-30)
- initial release
