/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TzoneProtocolDecoder
extends BaseProtocolDecoder {
    public TzoneProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int index) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String ack = String.format("@ACK,%d#", index);
        String time = String.format("@UTC time:%s", dateFormat.format(new Date()));
        ByteBuf response = Unpooled.copiedBuffer((CharSequence)(ack + time), (Charset)StandardCharsets.US_ASCII);
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private String decodeAlarm(Short value) {
        switch (value) {
            case 1: {
                return "sos";
            }
            case 16: {
                return "lowBattery";
            }
            case 17: {
                return "overspeed";
            }
            case 20: {
                return "hardBraking";
            }
            case 21: {
                return "hardAcceleration";
            }
            case 48: {
                return "parking";
            }
            case 66: {
                return "geofenceExit";
            }
            case 67: {
                return "geofenceEnter";
            }
        }
        return null;
    }

    private boolean decodeGps(Position position, ByteBuf buf, int hardware) {
        double lon;
        double lat;
        int blockLength = buf.readUnsignedShort();
        int blockEnd = buf.readerIndex() + blockLength;
        if (blockLength < 22) {
            return false;
        }
        if (hardware == 1043) {
            buf.readUnsignedByte();
        } else {
            position.set("sat", buf.readUnsignedByte());
        }
        if (hardware == 1043) {
            position.setFixTime(new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).getDate());
        }
        if (hardware == 266 || hardware == 267) {
            lat = (double)buf.readUnsignedInt() / 600000.0;
            lon = (double)buf.readUnsignedInt() / 600000.0;
        } else {
            lat = (double)buf.readUnsignedInt() / 100000.0 / 60.0;
            lon = (double)buf.readUnsignedInt() / 100000.0 / 60.0;
        }
        if (hardware == 1043) {
            position.set("hdop", (double)buf.readUnsignedShort() * 0.1);
            position.setAltitude(buf.readUnsignedShort());
            position.setCourse(buf.readUnsignedShort());
            position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShort() * 0.1));
            position.set("sat", buf.readUnsignedByte());
        } else {
            position.setFixTime(new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).getDate());
            position.setSpeed((double)buf.readUnsignedShort() * 0.01);
            position.set("odometer", buf.readUnsignedMedium());
            int flags = buf.readUnsignedShort();
            position.setCourse(BitUtil.to(flags, 9));
            if (!BitUtil.check(flags, 10)) {
                lat = -lat;
            }
            position.setLatitude(lat);
            if (BitUtil.check(flags, 9)) {
                lon = -lon;
            }
            position.setLongitude(lon);
            position.setValid(BitUtil.check(flags, 11));
        }
        buf.readerIndex(blockEnd);
        return true;
    }

    private void decodeCards(Position position, ByteBuf buf) {
        int index = 1;
        for (int i = 0; i < 4; ++i) {
            int blockLength = buf.readUnsignedShort();
            int blockEnd = buf.readerIndex() + blockLength;
            if (blockLength > 0) {
                int count = buf.readUnsignedByte();
                for (int j = 0; j < count; ++j) {
                    boolean odd;
                    int length = buf.readUnsignedByte();
                    boolean bl = odd = length % 2 != 0;
                    if (odd) {
                        ++length;
                    }
                    String num = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(length / 2));
                    if (odd) {
                        num = num.substring(1);
                    }
                    position.set("card" + index, num);
                }
            }
            buf.readerIndex(blockEnd);
        }
    }

    private void decodePassengers(Position position, ByteBuf buf) {
        int blockLength = buf.readUnsignedShort();
        int blockEnd = buf.readerIndex() + blockLength;
        if (blockLength > 0) {
            position.set("passengersOn", buf.readUnsignedMedium());
            position.set("passengersOff", buf.readUnsignedMedium());
        }
        buf.readerIndex(blockEnd);
    }

    private void decodeTags(Position position, ByteBuf buf, int hardware) {
        int blockLength = buf.readUnsignedShort();
        int blockEnd = buf.readerIndex() + blockLength;
        if (blockLength > 0) {
            short type = buf.readUnsignedByte();
            if (hardware != 339 || type >= 2) {
                int count = buf.readUnsignedByte();
                short tagLength = buf.readUnsignedByte();
                for (int i = 1; i <= count; ++i) {
                    int tagEnd = buf.readerIndex() + tagLength;
                    buf.readUnsignedByte();
                    buf.readUnsignedShortLE();
                    position.set("temp" + i, (double)(buf.readShortLE() & 0x3FFF) * 0.1);
                    buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    buf.readerIndex(tagEnd);
                }
            } else if (type == 1) {
                position.set("card", buf.readCharSequence(blockEnd - buf.readerIndex(), StandardCharsets.UTF_8).toString());
            }
        }
        buf.readerIndex(blockEnd);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        buf.readUnsignedShort();
        if (buf.readUnsignedShort() != 9252) {
            return null;
        }
        int hardware = buf.readUnsignedShort();
        long firmware = buf.readUnsignedInt();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("versionHw", hardware);
        position.set("versionFw", firmware);
        position.setDeviceTime(new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).getDate());
        if (hardware == 1030 || !this.decodeGps(position, buf, hardware)) {
            this.getLastLocation(position, position.getDeviceTime());
        }
        int blockLength = buf.readUnsignedShort();
        int blockEnd = buf.readerIndex() + blockLength;
        if (blockLength > 0) {
            if (hardware == 266 || hardware == 267 || hardware == 1030) {
                position.setNetwork(new Network(CellTower.fromLacCid(this.getConfig(), buf.readUnsignedShort(), buf.readUnsignedShort())));
            } else if (hardware == 1031) {
                Network network = new Network();
                int count = buf.readUnsignedByte();
                for (int i = 0; i < count; ++i) {
                    buf.readUnsignedByte();
                    int mcc = BcdUtil.readInteger(buf, 4);
                    int mnc = BcdUtil.readInteger(buf, 4) % 1000;
                    network.addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShort(), buf.readUnsignedInt()));
                }
                position.setNetwork(network);
            }
        }
        buf.readerIndex(blockEnd);
        blockLength = buf.readUnsignedShort();
        blockEnd = buf.readerIndex() + blockLength;
        if (hardware == 1031 || blockLength >= 13) {
            position.set("alarm", this.decodeAlarm(buf.readUnsignedByte()));
            position.set("terminalInfo", buf.readUnsignedByte());
            if (hardware != 1031) {
                short status = buf.readUnsignedByte();
                position.set("out1", BitUtil.check(status, 0));
                position.set("out2", BitUtil.check(status, 1));
                status = buf.readUnsignedByte();
                position.set("in1", BitUtil.check(status, 4));
                if (BitUtil.check(status, 0)) {
                    position.set("alarm", "sos");
                }
            }
            position.set("rssi", buf.readUnsignedByte());
            position.set("gsmStatus", buf.readUnsignedByte());
            position.set("battery", (double)buf.readUnsignedShort() * 0.01);
            if (hardware != 1031) {
                position.set("power", buf.readUnsignedShort());
                position.set("adc1", buf.readUnsignedShort());
                position.set("adc2", buf.readUnsignedShort());
            } else {
                int humidity;
                int temperature = buf.readUnsignedShort();
                if (!BitUtil.check(temperature, 15)) {
                    double value = (double)BitUtil.to(temperature, 14) * 0.1;
                    position.set("temp1", BitUtil.check(temperature, 14) ? -value : value);
                }
                if (!BitUtil.check(humidity = buf.readUnsignedShort(), 15)) {
                    position.set("humidity", (double)BitUtil.to(humidity, 15) * 0.1);
                }
                position.set("lightSensor", buf.readUnsignedByte() == 0);
            }
        }
        if (blockLength >= 15) {
            position.set("temp1", buf.readUnsignedShort());
        }
        buf.readerIndex(blockEnd);
        if (hardware == 267) {
            this.decodeCards(position, buf);
            buf.skipBytes(buf.readUnsignedShort());
            buf.skipBytes(buf.readUnsignedShort());
            this.decodePassengers(position, buf);
        }
        if (hardware == 339 || hardware == 1030) {
            this.decodeTags(position, buf, hardware);
        }
        if (this.getConfig().getBoolean(Keys.PROTOCOL_ACK.withPrefix(this.getProtocolName()))) {
            this.sendResponse(channel, remoteAddress, buf.getUnsignedShort(buf.writerIndex() - 6));
        }
        return position;
    }
}

