/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGI
extends HttpServlet {
    private static final long serialVersionUID = -6182088932884791074L;
    private static final Logger LOG = LoggerFactory.getLogger(CGI.class);
    private boolean _ok;
    private File _docRoot;
    private boolean _cgiBinProvided;
    private String _path;
    private String _cmdPrefix;
    private boolean _useFullPath;
    private EnvList _env;
    private boolean _ignoreExitState;
    private boolean _relative;

    public void init() throws ServletException {
        String os;
        this._env = new EnvList();
        this._cmdPrefix = this.getInitParameter("commandPrefix");
        this._useFullPath = Boolean.parseBoolean(this.getInitParameter("useFullPath"));
        this._relative = Boolean.parseBoolean(this.getInitParameter("cgibinResourceBaseIsRelative"));
        String tmp = this.getInitParameter("cgibinResourceBase");
        if (tmp != null) {
            this._cgiBinProvided = true;
        } else {
            tmp = this.getInitParameter("resourceBase");
            if (tmp != null) {
                this._cgiBinProvided = true;
            } else {
                tmp = this.getServletContext().getRealPath("/");
            }
        }
        if (this._relative && this._cgiBinProvided) {
            tmp = this.getServletContext().getRealPath(tmp);
        }
        if (tmp == null) {
            LOG.warn("CGI: no CGI bin !");
            return;
        }
        File dir = new File(tmp);
        if (!dir.exists()) {
            LOG.warn("CGI: CGI bin does not exist - {}", (Object)dir);
            return;
        }
        if (!dir.canRead()) {
            LOG.warn("CGI: CGI bin is not readable - {}", (Object)dir);
            return;
        }
        if (!dir.isDirectory()) {
            LOG.warn("CGI: CGI bin is not a directory - {}", (Object)dir);
            return;
        }
        try {
            this._docRoot = dir.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.warn("CGI: CGI bin failed - {}", (Object)dir, (Object)e);
            return;
        }
        this._path = this.getInitParameter("Path");
        if (this._path != null) {
            this._env.set("PATH", this._path);
        }
        this._ignoreExitState = "true".equalsIgnoreCase(this.getInitParameter("ignoreExitState"));
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (n == null || !n.startsWith("ENV_")) continue;
            this._env.set(n.substring(4), this.getInitParameter(n));
        }
        if (!this._env.envMap.containsKey("SystemRoot") && (os = System.getProperty("os.name")) != null && os.toLowerCase(Locale.ENGLISH).contains("windows")) {
            this._env.set("SystemRoot", "C:\\WINDOWS");
        }
        this._ok = true;
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this._ok) {
            res.sendError(503);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CGI: ContextPath : {}, ServletPath : {}, PathInfo : {}, _docRoot : {}, _path : {}, _ignoreExitState : {}", new Object[]{req.getContextPath(), req.getServletPath(), req.getPathInfo(), this._docRoot, this._path, this._ignoreExitState});
        }
        String pathInContext = (this._relative ? "" : StringUtil.nonNull((String)req.getServletPath())) + StringUtil.nonNull((String)req.getPathInfo());
        File execCmd = new File(this._docRoot, pathInContext);
        Object pathInfo = pathInContext;
        if (!this._useFullPath) {
            Object path = pathInContext;
            String info = "";
            while ((((String)path).endsWith("/") || !execCmd.exists()) && ((String)path).length() >= 0) {
                int index = ((String)path).lastIndexOf(47);
                path = ((String)path).substring(0, index);
                info = pathInContext.substring(index, pathInContext.length());
                execCmd = new File(this._docRoot, (String)path);
            }
            if (((String)path).length() == 0 || !execCmd.exists() || execCmd.isDirectory() || !execCmd.getCanonicalPath().equals(execCmd.getAbsolutePath())) {
                res.sendError(404);
            }
            pathInfo = info;
        }
        this.exec(execCmd, (String)pathInfo, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void exec(File command, String pathInfo, HttpServletRequest req, HttpServletResponse res) throws IOException {
        block33: {
            String scriptName;
            String scriptPath;
            String pathTranslated;
            assert (req != null);
            assert (res != null);
            assert (pathInfo != null);
            assert (command != null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("CGI: script is {} pathInfo is {}", (Object)command, (Object)pathInfo);
            }
            String bodyFormEncoded = null;
            if ((HttpMethod.POST.is(req.getMethod()) || HttpMethod.PUT.is(req.getMethod())) && "application/x-www-form-urlencoded".equals(req.getContentType())) {
                MultiMap parameterMap = new MultiMap();
                Enumeration names = req.getParameterNames();
                while (names.hasMoreElements()) {
                    String parameterName = (String)names.nextElement();
                    parameterMap.addValues(parameterName, (Object[])req.getParameterValues(parameterName));
                }
                String characterEncoding = req.getCharacterEncoding();
                Charset charset = characterEncoding != null ? Charset.forName(characterEncoding) : StandardCharsets.UTF_8;
                bodyFormEncoded = UrlEncoded.encode((MultiMap)parameterMap, (Charset)charset, (boolean)true);
            }
            EnvList env = new EnvList(this._env);
            env.set("AUTH_TYPE", req.getAuthType());
            int contentLen = req.getContentLength();
            if (contentLen < 0) {
                contentLen = 0;
            }
            if (bodyFormEncoded != null) {
                env.set("CONTENT_LENGTH", Integer.toString(bodyFormEncoded.length()));
            } else {
                env.set("CONTENT_LENGTH", Integer.toString(contentLen));
            }
            env.set("CONTENT_TYPE", req.getContentType());
            env.set("GATEWAY_INTERFACE", "CGI/1.1");
            if (pathInfo.length() > 0) {
                env.set("PATH_INFO", pathInfo);
            }
            if ((pathTranslated = req.getPathTranslated()) == null || pathTranslated.length() == 0) {
                pathTranslated = pathInfo;
            }
            env.set("PATH_TRANSLATED", pathTranslated);
            env.set("QUERY_STRING", req.getQueryString());
            env.set("REMOTE_ADDR", req.getRemoteAddr());
            env.set("REMOTE_HOST", req.getRemoteHost());
            env.set("REMOTE_USER", req.getRemoteUser());
            env.set("REQUEST_METHOD", req.getMethod());
            if (this._cgiBinProvided) {
                scriptPath = command.getAbsolutePath();
                scriptName = scriptPath.substring(this._docRoot.getAbsolutePath().length());
            } else {
                String requestURI = req.getRequestURI();
                scriptName = requestURI.substring(0, requestURI.length() - pathInfo.length());
                scriptPath = this.getServletContext().getRealPath(scriptName);
            }
            env.set("SCRIPT_FILENAME", scriptPath);
            env.set("SCRIPT_NAME", scriptName);
            env.set("SERVER_NAME", req.getServerName());
            env.set("SERVER_PORT", Integer.toString(req.getServerPort()));
            env.set("SERVER_PROTOCOL", req.getProtocol());
            env.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
            Enumeration enm = req.getHeaderNames();
            while (enm.hasMoreElements()) {
                String name = (String)enm.nextElement();
                if (name.equalsIgnoreCase("Proxy")) continue;
                String value = req.getHeader(name);
                env.set("HTTP_" + StringUtil.replace((String)name.toUpperCase(Locale.ENGLISH), (char)'-', (char)'_'), value);
            }
            env.set("HTTPS", req.isSecure() ? "ON" : "OFF");
            String absolutePath = command.getAbsolutePath();
            Object execCmd = absolutePath;
            if (((String)execCmd).length() > 0 && ((String)execCmd).charAt(0) != '\"' && ((String)execCmd).contains(" ")) {
                execCmd = "\"" + (String)execCmd + "\"";
            }
            if (this._cmdPrefix != null) {
                execCmd = this._cmdPrefix + " " + (String)execCmd;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Environment: {} Command: {}", (Object)env.getExportString(), execCmd);
            }
            final Process p = Runtime.getRuntime().exec((String)execCmd, env.getEnvArray(), this._docRoot);
            if (bodyFormEncoded != null) {
                CGI.writeProcessInput(p, bodyFormEncoded);
            } else if (contentLen > 0) {
                CGI.writeProcessInput(p, (InputStream)req.getInputStream(), contentLen);
            }
            ServletOutputStream os = null;
            AsyncContext async = req.startAsync();
            try {
                int exitValue;
                async.start(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IO.copy((InputStream)p.getErrorStream(), (OutputStream)System.err);
                        }
                        catch (IOException e) {
                            LOG.warn("Unable to copy error stream", (Throwable)e);
                        }
                    }
                });
                String line = null;
                InputStream inFromCgi = p.getInputStream();
                while ((line = CGI.getTextLineFromStream(inFromCgi)).length() > 0) {
                    int k;
                    if (line.startsWith("HTTP") || (k = line.indexOf(58)) <= 0) continue;
                    String key = line.substring(0, k).trim();
                    String value = line.substring(k + 1).trim();
                    if ("Location".equals(key)) {
                        res.sendRedirect(res.encodeRedirectURL(value));
                        continue;
                    }
                    if ("Status".equals(key)) {
                        String[] token = value.split(" ");
                        int status = Integer.parseInt(token[0]);
                        res.setStatus(status);
                        continue;
                    }
                    res.addHeader(key, value);
                }
                os = res.getOutputStream();
                IO.copy((InputStream)inFromCgi, (OutputStream)os);
                p.waitFor();
                if (!this._ignoreExitState && 0 != (exitValue = p.exitValue())) {
                    LOG.warn("Non-zero exit status ({}) from CGI program: {}", (Object)exitValue, (Object)absolutePath);
                    if (!res.isCommitted()) {
                        res.sendError(500, "Failed to exec CGI");
                    }
                }
                IO.close((OutputStream)os);
                p.destroy();
            }
            catch (IOException e) {
                LOG.debug("CGI: Client closed connection!", (Throwable)e);
                break block33;
            }
            catch (InterruptedException ex) {
                LOG.debug("CGI: interrupted!");
                break block33;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IO.close(os);
                p.destroy();
                async.complete();
            }
            async.complete();
        }
    }

    private static void writeProcessInput(final Process p, final String input) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try (OutputStreamWriter outToCgi = new OutputStreamWriter(p.getOutputStream());){
                    outToCgi.write(input);
                }
                catch (IOException e) {
                    LOG.debug("Unable to write out to CGI", (Throwable)e);
                }
            }
        }).start();
    }

    private static void writeProcessInput(final Process p, final InputStream input, final int len) {
        if (len <= 0) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try (OutputStream outToCgi = p.getOutputStream();){
                    IO.copy((InputStream)input, (OutputStream)outToCgi, (long)len);
                }
                catch (IOException e) {
                    LOG.debug("Unable to write out to CGI", (Throwable)e);
                }
            }
        }).start();
    }

    private static String getTextLineFromStream(InputStream is) throws IOException {
        int b;
        StringBuilder buffer = new StringBuilder();
        while ((b = is.read()) != -1 && b != 10) {
            buffer.append((char)b);
        }
        return buffer.toString().trim();
    }

    private static class EnvList {
        private Map<String, String> envMap;

        EnvList() {
            this.envMap = new HashMap<String, String>();
        }

        EnvList(EnvList l) {
            this.envMap = new HashMap<String, String>(l.envMap);
        }

        public void set(String name, String value) {
            this.envMap.put(name, name + "=" + StringUtil.nonNull((String)value));
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }

        public String getExportString() {
            StringBuilder sb = new StringBuilder();
            for (String variable : this.getEnvArray()) {
                sb.append("export \"");
                sb.append(variable);
                sb.append("\"; ");
            }
            return sb.toString();
        }

        public String toString() {
            return this.envMap.toString();
        }
    }
}

