/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayModificationFactory;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.attacks.config.Lucky13CommandConfig;
import de.rub.nds.tlsattacker.attacks.impl.Attacker;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.message.AlertMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import de.rub.nds.tlsattacker.transport.TransportHandlerType;
import de.rub.nds.tlsattacker.transport.tcp.proxy.TimingProxyClientTcpTransportHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Lucky13Attacker
extends Attacker<Lucky13CommandConfig> {
    private static final Logger LOGGER = LogManager.getLogger(Lucky13Attacker.class);
    private final Map<Integer, List<Long>> results;
    private long lastResult;
    private final Config tlsConfig = this.getTlsConfig();

    public Lucky13Attacker(Lucky13CommandConfig config, Config baseConfig) {
        super(config, baseConfig);
        this.results = new HashMap<Integer, List<Long>>();
    }

    @Override
    public void executeAttack() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private void createMonaFile(String fileName, String[] delimiters, List<Long> result1, List<Long> result2) {
        try (FileWriter fw = new FileWriter(fileName);){
            for (int i = 0; i < result1.size(); ++i) {
                fw.write(Integer.toString(i * 2));
                fw.write(delimiters[0] + result1.get(i) + System.getProperty("line.separator"));
                fw.write(Integer.toString(i * 2 + 1));
                fw.write(delimiters[1] + result2.get(i) + System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
        }
    }

    public void executeAttackRound(Record record) {
        this.tlsConfig.getDefaultClientConnection().setTransportHandlerType(TransportHandlerType.TCP_PROXY_TIMING);
        this.tlsConfig.setWorkflowExecutorShouldClose(true);
        WorkflowTrace trace = new WorkflowConfigurationFactory(this.tlsConfig).createWorkflowTrace(WorkflowTraceType.FULL, RunningModeType.CLIENT);
        SendAction sendAction = (SendAction)trace.getLastSendingAction();
        LinkedList<AbstractRecord> records = new LinkedList<AbstractRecord>();
        records.add(record);
        sendAction.setRecords(records);
        ReceiveAction action = new ReceiveAction();
        AlertMessage alertMessage = new AlertMessage(this.tlsConfig);
        LinkedList<ProtocolMessage> messages = new LinkedList<ProtocolMessage>();
        messages.add(alertMessage);
        action.setExpectedMessages(messages);
        trace.addTlsAction(action);
        State state = new State(this.tlsConfig, trace);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(this.tlsConfig.getWorkflowExecutorType(), state);
        try {
            workflowExecutor.executeWorkflow();
        }
        catch (WorkflowExecutionException ex) {
            LOGGER.info("Not possible to finalize the defined workflow: {}", (Object)ex.getLocalizedMessage());
        }
        TimingProxyClientTcpTransportHandler transportHandler = (TimingProxyClientTcpTransportHandler)state.getTlsContext().getTransportHandler();
        this.lastResult = transportHandler.getLastMeasurement();
        try {
            transportHandler.closeConnection();
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Record createRecordWithPadding(int p, CipherSuite suite) {
        byte[] padding = this.createPaddingBytes(p);
        int recordLength = AlgorithmResolver.getCipher(suite).getBlocksize() * ((Lucky13CommandConfig)this.config).getBlocks();
        if (recordLength < padding.length) {
            throw new ConfigurationException("Padding too large");
        }
        int messageSize = recordLength - padding.length;
        byte[] message = new byte[messageSize];
        new Random().nextBytes(message);
        byte[] plain = ArrayConverter.concatenate((byte[][])new byte[][]{message, padding});
        return this.createRecordWithPlainData(plain);
    }

    private Record createRecordWithPlainData(byte[] plain) {
        Record r = new Record();
        r.prepareComputations();
        ModifiableByteArray plainData = new ModifiableByteArray();
        VariableModification modifier = ByteArrayModificationFactory.explicitValue((byte[])plain);
        plainData.setModification(modifier);
        r.getComputations().setPlainRecordBytes(plainData);
        return r;
    }

    private byte[] createPaddingBytes(int padding) {
        byte[] paddingBytes = new byte[padding + 1];
        for (int i = 0; i < paddingBytes.length; ++i) {
            paddingBytes[i] = (byte)padding;
        }
        return paddingBytes;
    }

    @Override
    protected Boolean isVulnerable() {
        Boolean vulnerable = false;
        StringBuilder commands = new StringBuilder();
        List<CipherSuite> suites = this.tlsConfig.getDefaultClientSupportedCiphersuites();
        for (CipherSuite suite : suites) {
            int i;
            this.results.clear();
            LOGGER.info("Testing ciphersuite {}", (Object)suite);
            this.tlsConfig.setDefaultClientSupportedCiphersuites(suite);
            this.tlsConfig.setDefaultServerSupportedCiphersuites(suite);
            this.tlsConfig.setDefaultSelectedCipherSuite(suite);
            String[] paddingStrings = ((Lucky13CommandConfig)this.config).getPaddings().split(",");
            int[] paddings = new int[paddingStrings.length];
            for (i = 0; i < paddingStrings.length; ++i) {
                paddings[i] = Integer.parseInt(paddingStrings[i]);
            }
            for (i = 0; i < ((Lucky13CommandConfig)this.config).getMeasurements(); ++i) {
                LOGGER.info("Starting round {}", (Object)i);
                for (int p : paddings) {
                    Record record = this.createRecordWithPadding(p, suite);
                    this.executeAttackRound(record);
                    LOGGER.info("Padding: {}, Measured {}", (Object)p, (Object)this.lastResult);
                    if (this.results.get(p) == null) {
                        this.results.put(p, new LinkedList());
                    }
                    if (i <= ((Lucky13CommandConfig)this.config).getMeasurements() / 4 - 1) continue;
                    this.results.get(p).add(this.lastResult);
                }
            }
            StringBuilder medians = new StringBuilder();
            for (int padding : paddings) {
                List rp = (List)((LinkedList)this.results.get(padding)).clone();
                Collections.sort(rp);
                LOGGER.info("Padding: {}", (Object)padding);
                long median = (Long)rp.get(rp.size() / 2);
                LOGGER.info("Median: {}", (Object)median);
                medians.append(median).append(",");
            }
            LOGGER.info("Medians: {}", (Object)medians);
            if (((Lucky13CommandConfig)this.config).getMonaFile() == null) continue;
            for (int i2 = 0; i2 < paddings.length - 1; ++i2) {
                for (int j = i2 + 1; j < paddings.length; ++j) {
                    String fileName = ((Lucky13CommandConfig)this.config).getMonaFile() + "-" + paddings[i2] + "-" + paddings[j] + "-" + suite.name() + ".csv";
                    String[] delimiters = new String[]{";" + paddings[i2] + ";", ";" + paddings[j] + ";"};
                    this.createMonaFile(fileName, delimiters, this.results.get(paddings[i2]), this.results.get(paddings[j]));
                    String command = "java -jar " + ((Lucky13CommandConfig)this.config).getMonaJar() + " --inputFile=" + fileName + " --name=lucky13-" + suite.name().replace('_', '-') + "-" + paddings[i2] + "-" + paddings[j] + " --lowerBound=0.3 --upperBound=0.5";
                    LOGGER.info("Run mona timing lib with: " + command);
                    commands.append(command);
                    commands.append(System.getProperty("line.separator"));
                }
            }
        }
        LOGGER.info("All commands at once: \n{}", (Object)commands);
        LOGGER.warn("Vulnerability has to be tested using the mona timing lib.");
        return vulnerable;
    }
}

