"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMetricsRoute = registerMetricsRoute;

var _common = require("../../common");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerMetricsRoute(router) {
  router.get({
    path: _common.ServiceEndpoints.GetStats,
    validate: false
  }, async (context, _, response) => {
    try {
      const metrics = context.searchRelevance.metricsService.getStats();
      return response.ok({
        body: JSON.stringify(metrics, null, 2)
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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