/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchpipelines.questionanswering.generative.prompt;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.opensearch.ml.common.conversation.Interaction;

public class PromptUtil {
    public static final String DEFAULT_CHAT_COMPLETION_PROMPT_TEMPLATE = "Generate a concise and informative answer in less than 100 words for the given question, taking into context: - An enumerated list of search results- A rephrase of the question that was used to generate the search results- The conversation historyCite search results using [${number}] notation.Do not repeat yourself, and NEVER repeat anything in the chat history.If there are any necessary steps or procedures in your answer, enumerate them.";
    private static final String roleUser = "user";
    private static Gson gson = new Gson();

    public static String getQuestionRephrasingPrompt(String originalQuestion, List<Interaction> chatHistory) {
        return null;
    }

    public static String getChatCompletionPrompt(String question, List<Interaction> chatHistory, List<String> contexts) {
        return PromptUtil.buildMessageParameter(question, chatHistory, contexts);
    }

    @VisibleForTesting
    static String buildMessageParameter(String question, List<Interaction> chatHistory, List<String> contexts) {
        JsonArray messageArray = new JsonArray();
        messageArray.add((JsonElement)new Message(ChatRole.USER, DEFAULT_CHAT_COMPLETION_PROMPT_TEMPLATE).toJson());
        for (String result : contexts) {
            messageArray.add((JsonElement)new Message(ChatRole.USER, "SEARCH RESULT: " + result).toJson());
        }
        if (!chatHistory.isEmpty()) {
            Messages.fromInteractions(chatHistory).getMessages().forEach(m -> messageArray.add((JsonElement)m.toJson()));
        }
        messageArray.add((JsonElement)new Message(ChatRole.USER, "QUESTION: " + question).toJson());
        messageArray.add((JsonElement)new Message(ChatRole.USER, "ANSWER:").toJson());
        return messageArray.toString();
    }

    @Generated
    private PromptUtil() {
    }

    static class Message {
        private static final String MESSAGE_FIELD_ROLE = "role";
        private static final String MESSAGE_FIELD_CONTENT = "content";
        private ChatRole chatRole;
        private String content;
        private JsonObject json = new JsonObject();

        public Message() {
        }

        public Message(ChatRole chatRole, String content) {
            this();
            this.setChatRole(chatRole);
            this.setContent(content);
        }

        public void setChatRole(ChatRole chatRole) {
            this.json.remove(MESSAGE_FIELD_ROLE);
            this.json.add(MESSAGE_FIELD_ROLE, (JsonElement)new JsonPrimitive(chatRole.getName()));
        }

        public void setContent(String content) {
            this.content = StringEscapeUtils.escapeJson((String)content);
            this.json.remove(MESSAGE_FIELD_CONTENT);
            this.json.add(MESSAGE_FIELD_CONTENT, (JsonElement)new JsonPrimitive(this.content));
        }

        public JsonObject toJson() {
            return this.json;
        }

        @Generated
        public ChatRole getChatRole() {
            return this.chatRole;
        }

        @Generated
        public String getContent() {
            return this.content;
        }
    }

    static enum ChatRole {
        USER("user"),
        ASSISTANT("assistant"),
        SYSTEM("system");

        private String name;

        private ChatRole(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }

    static class Messages {
        private List<Message> messages = new ArrayList<Message>();

        public Messages(List<Message> messages) {
            this.addMessages(messages);
        }

        public void addMessages(List<Message> messages) {
            this.messages.addAll(messages);
        }

        public static Messages fromInteractions(List<Interaction> interactions) {
            ArrayList<Message> messages = new ArrayList<Message>();
            for (Interaction interaction : interactions) {
                messages.add(new Message(ChatRole.USER, interaction.getInput()));
                messages.add(new Message(ChatRole.ASSISTANT, interaction.getResponse()));
            }
            return new Messages(messages);
        }

        @Generated
        public List<Message> getMessages() {
            return this.messages;
        }
    }
}

