/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.pyrometer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.ShardProfileSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.HeatZoneAssigner;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;

public class Api {
    private static boolean checkIfElectedClusterManager() {
        return true;
    }

    private static void failIfNotElectedClusterManager(String apiName) {
        if (!Api.checkIfElectedClusterManager()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Api (").append(apiName).append(") can only be called from the elected cluster_manager node.");
            throw new IllegalStateException(builder.toString());
        }
    }

    public static boolean isClusterImbalanceAlongDimension(TemperatureDimension dimension) {
        Api.failIfNotElectedClusterManager("getClusterImbalanceAlongDimension");
        return true;
    }

    @Nonnull
    public static List<CompactNodeSummary> getNodesForGivenZone(TemperatureDimension dimension, HeatZoneAssigner.Zone zone, Count count, SortOrder order) {
        Api.failIfNotElectedClusterManager("getNodes");
        return new ArrayList<CompactNodeSummary>();
    }

    @Nonnull
    public static Map<HeatZoneAssigner.Zone, List<CompactNodeSummary>> getNodesForAllZones(TemperatureDimension dimension, Count count, SortOrder order) {
        Api.failIfNotElectedClusterManager("getNodes");
        HashMap<HeatZoneAssigner.Zone, List<CompactNodeSummary>> nodes = new HashMap<HeatZoneAssigner.Zone, List<CompactNodeSummary>>();
        for (HeatZoneAssigner.Zone zone : HeatZoneAssigner.Zone.values()) {
            nodes.put(zone, Api.getNodesForGivenZone(dimension, zone, count, order));
        }
        return nodes;
    }

    @Nonnull
    public static List<ShardProfileSummary> getShards(CompactNodeSummary node, TemperatureDimension dimension, HeatZoneAssigner.Zone zone, Count count, SortOrder sortOrder) {
        ArrayList<ShardProfileSummary> shards = new ArrayList<ShardProfileSummary>();
        return shards;
    }

    static enum Count {
        ALL,
        TOP_K;

    }

    static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }
}

