/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.processors.response;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.ConfigurableName;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.data.columnar.ResponseProcessor;

public class FieldResponseProcessor<T extends Output<T>>
implements ResponseProcessor<T> {
    @Config(description="The field name to read.")
    @Deprecated
    private String fieldName;
    @Config(description="Default value to return if one isn't found.")
    private String defaultValue;
    @Config(mandatory=true, description="The output factory to use.")
    private OutputFactory<T> outputFactory;
    @Config(description="A list of field names to read, you should use only one of this or fieldName.")
    private List<String> fieldNames;
    @Config(description="A list of default values to return if one isn't found, one for each field")
    private List<String> defaultValues;
    @Config(description="Whether to display field names as part of the generated label, defaults to false")
    private boolean displayField = false;
    @Config(description="Uppercase the value before converting to output.")
    private boolean uppercase = true;
    @ConfigurableName
    private String configName;

    public void postConfig() {
        boolean singleDefaultValuePopulated;
        boolean bothFieldNamesPopulated = this.fieldName != null && this.fieldNames != null;
        boolean neitherFieldNamesPopulated = this.fieldName == null && this.fieldNames == null;
        boolean multipleFieldNamesPopulated = this.fieldNames != null;
        boolean singleFieldNamePopulated = this.fieldName != null;
        boolean bothDefaultValuesPopulated = this.defaultValues != null && this.defaultValue != null;
        boolean neitherDefaultValuesPopulated = this.defaultValue == null && this.defaultValues == null;
        boolean multipleDefaultValuesPopulated = this.defaultValues != null;
        boolean bl = singleDefaultValuePopulated = this.defaultValue != null;
        if (bothFieldNamesPopulated || neitherFieldNamesPopulated) {
            throw new PropertyException(this.configName, "fieldName, FieldNames", "exactly one of fieldName or fieldNames must be populated");
        }
        if (bothDefaultValuesPopulated || neitherDefaultValuesPopulated) {
            throw new PropertyException(this.configName, "defaultValue, defaultValues", "exactly one of defaultValue or defaultValues must be populated");
        }
        if (multipleFieldNamesPopulated && multipleDefaultValuesPopulated && this.fieldNames.size() != this.defaultValues.size()) {
            throw new PropertyException(this.configName, "defaultValues", "must match the length of fieldNames");
        }
        if (multipleFieldNamesPopulated && singleDefaultValuePopulated) {
            this.defaultValues = Collections.nCopies(this.fieldNames.size(), this.defaultValue);
            this.defaultValue = null;
        } else {
            if (singleFieldNamePopulated && multipleDefaultValuesPopulated) {
                throw new PropertyException(this.configName, "defaultValues", "if fieldName is populated, defaultValues must be blank");
            }
            if (singleFieldNamePopulated && singleDefaultValuePopulated) {
                this.fieldNames = Collections.singletonList(this.fieldName);
                this.fieldName = null;
                this.defaultValues = Collections.singletonList(this.defaultValue);
                this.defaultValue = null;
            }
        }
    }

    private FieldResponseProcessor() {
    }

    public FieldResponseProcessor(String fieldName, String defaultValue, OutputFactory<T> outputFactory) {
        this(Collections.singletonList(fieldName), defaultValue, outputFactory);
    }

    public FieldResponseProcessor(List<String> fieldNames, String defaultValue, OutputFactory<T> outputFactory) {
        this(fieldNames, Collections.nCopies(fieldNames.size(), defaultValue), outputFactory);
    }

    public FieldResponseProcessor(List<String> fieldNames, List<String> defaultValues, OutputFactory<T> outputFactory) {
        this(fieldNames, defaultValues, outputFactory, false);
    }

    public FieldResponseProcessor(List<String> fieldNames, List<String> defaultValues, OutputFactory<T> outputFactory, boolean displayField) {
        this(fieldNames, defaultValues, outputFactory, displayField, true);
    }

    public FieldResponseProcessor(List<String> fieldNames, List<String> defaultValues, OutputFactory<T> outputFactory, boolean displayField, boolean uppercase) {
        if (fieldNames.size() != defaultValues.size()) {
            throw new IllegalArgumentException("fieldNames and defaultValues must be the same length");
        }
        this.fieldNames = fieldNames;
        this.defaultValues = defaultValues;
        this.outputFactory = outputFactory;
        this.displayField = displayField;
        this.uppercase = uppercase;
    }

    @Override
    @Deprecated
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public OutputFactory<T> getOutputFactory() {
        return this.outputFactory;
    }

    @Override
    @Deprecated
    public String getFieldName() {
        return this.fieldNames.get(0);
    }

    @Override
    @Deprecated
    public Optional<T> process(String value) {
        return this.process(Collections.singletonList(value));
    }

    @Override
    public Optional<T> process(List<String> values) {
        if (values.size() != this.fieldNames.size()) {
            throw new IllegalArgumentException("values must have the same length as fieldNames. Got values: " + values.size() + " fieldNames: " + this.fieldNames.size());
        }
        ArrayList<String> responses = new ArrayList<String>();
        String prefix = "";
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            if (this.displayField) {
                prefix = this.fieldNames.get(i) + "=";
            }
            String val = this.uppercase ? values.get(i).toUpperCase().trim() : values.get(i).trim();
            val = val.isEmpty() ? this.defaultValues.get(i) : val;
            responses.add(prefix + val);
        }
        return Optional.of(this.outputFactory.generateOutput(this.fieldNames.size() == 1 ? responses.get(0) : responses));
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public String toString() {
        return "FieldResponseProcessor(fieldNames=" + this.fieldNames.toString() + ",displayField=" + this.displayField + ",uppercase=" + this.uppercase + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "ResponseProcessor");
    }
}

