/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.tuple.CompactSketch;
import com.yahoo.sketches.tuple.QuickSelectSketch;
import com.yahoo.sketches.tuple.Sketch;
import com.yahoo.sketches.tuple.SketchIterator;
import com.yahoo.sketches.tuple.Summary;
import java.util.function.Predicate;

public class Filter<T extends Summary> {
    private final Predicate<T> predicate;

    public Filter(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public CompactSketch<T> filter(Sketch<T> sketchIn) {
        if (sketchIn == null) {
            return new CompactSketch(null, null, Long.MAX_VALUE, true);
        }
        QuickSelectSketch<Summary> sketch = new QuickSelectSketch<Summary>(sketchIn.getRetainedEntries(), ResizeFactor.X1.lg(), null);
        SketchIterator<T> it = sketchIn.iterator();
        while (it.next()) {
            T summary = it.getSummary();
            if (!this.predicate.test(summary)) continue;
            sketch.insert(it.getKey(), summary.copy());
        }
        sketch.setThetaLong(sketchIn.getThetaLong());
        if (!sketchIn.isEmpty()) {
            sketch.setNotEmpty();
        }
        return sketch.compact();
    }
}

