/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.http;

import java.net.InetSocketAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.http.netty4.Netty4HttpChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.http.RemoteIpDetector;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.threadpool.ThreadPool;

public class XFFResolver {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile boolean enabled;
    private volatile RemoteIpDetector detector;
    private final ThreadContext threadContext;

    public XFFResolver(ThreadPool threadPool) {
        this.threadContext = threadPool.getThreadContext();
    }

    public TransportAddress resolve(RestRequest request) throws OpenSearchSecurityException {
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (isTraceEnabled) {
            this.log.trace("resolve {}", (Object)request.getHttpChannel().getRemoteAddress());
        }
        if (this.enabled && request.getHttpChannel().getRemoteAddress() instanceof InetSocketAddress && request.getHttpChannel() instanceof Netty4HttpChannel) {
            InetSocketAddress isa = new InetSocketAddress(this.detector.detect(request, this.threadContext), request.getHttpChannel().getRemoteAddress().getPort());
            if (isa.isUnresolved()) {
                throw new OpenSearchSecurityException("Cannot resolve address " + isa.getHostString(), new Object[0]);
            }
            if (isTraceEnabled) {
                if (this.threadContext.getTransient("_opendistro_security_xff_done") == Boolean.TRUE) {
                    this.log.trace("xff resolved {} to {}", (Object)request.getHttpChannel().getRemoteAddress(), (Object)isa);
                } else {
                    this.log.trace("no xff done for {}", request.getClass());
                }
            }
            return new TransportAddress(isa);
        }
        if (request.getHttpChannel().getRemoteAddress() instanceof InetSocketAddress) {
            if (isTraceEnabled) {
                this.log.trace("no xff done (enabled or no netty request) {},{},{},{}", (Object)this.enabled, request.getClass());
            }
            return new TransportAddress(request.getHttpChannel().getRemoteAddress());
        }
        throw new OpenSearchSecurityException("Cannot handle this request. Remote address is " + request.getHttpChannel().getRemoteAddress() + " with request class " + request.getClass(), new Object[0]);
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        this.enabled = dcm.isXffEnabled();
        if (this.enabled) {
            this.detector = new RemoteIpDetector();
            this.detector.setInternalProxies(dcm.getInternalProxies());
            this.detector.setRemoteIpHeader(dcm.getRemoteIpHeader());
        } else {
            this.detector = null;
        }
    }
}

