/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.ml.memory.ConversationalMemoryHandler;
import org.opensearch.ml.memory.action.conversation.DeleteConversationRequest;
import org.opensearch.ml.memory.action.conversation.DeleteConversationResponse;
import org.opensearch.ml.memory.index.OpenSearchConversationalMemoryHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteConversationTransportAction
extends HandledTransportAction<DeleteConversationRequest, DeleteConversationResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteConversationTransportAction.class);
    private Client client;
    private ConversationalMemoryHandler cmHandler;
    private volatile boolean featureIsEnabled;

    @Inject
    public DeleteConversationTransportAction(TransportService transportService, ActionFilters actionFilters, OpenSearchConversationalMemoryHandler cmHandler, Client client, ClusterService clusterService) {
        super("cluster:admin/opensearch/ml/memory/conversation/delete", transportService, actionFilters, DeleteConversationRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    public void doExecute(Task task, DeleteConversationRequest request, ActionListener<DeleteConversationResponse> listener) {
        if (!this.featureIsEnabled) {
            listener.onFailure((Exception)new OpenSearchException("The experimental Conversation Memory feature is not enabled. To enable, please update the setting " + ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.getKey(), new Object[0]));
            return;
        }
        String conversationId = request.getId();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> context.restore());
            ActionListener al = ActionListener.wrap(success -> {
                DeleteConversationResponse response = new DeleteConversationResponse((boolean)success);
                internalListener.onResponse((Object)response);
            }, e -> internalListener.onFailure(e));
            this.cmHandler.deleteConversation(conversationId, (ActionListener<Boolean>)al);
        }
        catch (Exception e2) {
            log.error("Failed to delete conversation " + conversationId, (Throwable)e2);
            listener.onFailure(e2);
        }
    }
}

