/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.tribuo.Dataset;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.provenance.TrainerProvenance;

public interface Trainer<T extends Output<T>>
extends Configurable,
Provenancable<TrainerProvenance> {
    public static final long DEFAULT_SEED = 12345L;
    public static final int INCREMENT_INVOCATION_COUNT = -1;

    default public Model<T> train(Dataset<T> examples) {
        return this.train(examples, Collections.emptyMap());
    }

    public Model<T> train(Dataset<T> var1, Map<String, Provenance> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Model<T> train(Dataset<T> examples, Map<String, Provenance> runProvenance, int invocationCount) {
        Trainer trainer = this;
        synchronized (trainer) {
            if (invocationCount != -1) {
                this.setInvocationCount(invocationCount);
            }
            return this.train(examples, runProvenance);
        }
    }

    public int getInvocationCount();

    default public void setInvocationCount(int invocationCount) {
        Logger.getLogger(this.getClass().getName()).warning("This class is using the default implementation of setInvocationCount and so might not behave as expected when reproduced. We highly recommend overriding this method as per the documentation.");
    }
}

