/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.action.mapping;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indexmanagement.indexstatemanagement.util.RestHandlerUtilsKt;
import org.opensearch.indexmanagement.rollup.action.mapping.UpdateRollupMappingAction;
import org.opensearch.indexmanagement.rollup.action.mapping.UpdateRollupMappingRequest;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0014J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/opensearch/indexmanagement/rollup/action/mapping/TransportUpdateRollupMappingAction;", "Lorg/opensearch/action/support/clustermanager/TransportClusterManagerNodeAction;", "Lorg/opensearch/indexmanagement/rollup/action/mapping/UpdateRollupMappingRequest;", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "client", "Lorg/opensearch/client/Client;", "(Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;Lorg/opensearch/client/Client;)V", "getClient", "()Lorg/opensearch/client/Client;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "checkBlock", "Lorg/opensearch/cluster/block/ClusterBlockException;", "request", "state", "Lorg/opensearch/cluster/ClusterState;", "executor", "", "masterOperation", "", "listener", "Lorg/opensearch/core/action/ActionListener;", "read", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "opensearch-index-management"})
public final class TransportUpdateRollupMappingAction
extends TransportClusterManagerNodeAction<UpdateRollupMappingRequest, AcknowledgedResponse> {
    @NotNull
    private final Client client;
    private final Logger log;

    @Inject
    public TransportUpdateRollupMappingAction(@NotNull ThreadPool threadPool, @NotNull ClusterService clusterService, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(UpdateRollupMappingAction.Companion.getINSTANCE().name(), transportService, clusterService, threadPool, actionFilters, TransportUpdateRollupMappingAction::_init_$lambda$0, indexNameExpressionResolver);
        this.client = client;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @Nullable
    protected ClusterBlockException checkBlock(@NotNull UpdateRollupMappingRequest request, @NotNull ClusterState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String targetIndexResolvedName = RollupFieldValueExpressionResolver.INSTANCE.resolve(request.getRollup(), request.getRollup().getTargetIndex());
        String[] stringArray = new String[]{targetIndexResolvedName};
        return state.getBlocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, stringArray);
    }

    protected void masterOperation(@NotNull UpdateRollupMappingRequest request, @NotNull ClusterState state, @NotNull ActionListener<AcknowledgedResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        String targetIndexResolvedName = RollupFieldValueExpressionResolver.INSTANCE.resolve(request.getRollup(), request.getRollup().getTargetIndex());
        IndexMetadata index2 = state.getMetadata().index(targetIndexResolvedName);
        if (index2 == null) {
            this.log.debug("Could not find index [" + index2 + "]");
            listener.onFailure((Exception)new IllegalStateException("Could not find index [" + index2 + "]"));
            return;
        }
        MappingMetadata mappings = index2.mapping();
        if (mappings == null) {
            this.log.debug("Could not find mapping for index [" + index2 + "]");
            listener.onFailure((Exception)new IllegalStateException("Could not find mapping for index [" + index2 + "]"));
            return;
        }
        Map source = mappings.getSourceAsMap();
        if (source == null) {
            this.log.debug("Could not find source for index mapping [" + index2 + "]");
            listener.onFailure((Exception)new IllegalStateException("Could not find source for index mapping [" + index2 + "]"));
            return;
        }
        Rollup rollup2 = request.getRollup();
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
        BytesReference bytesReference = BytesReference.bytes((XContentBuilder)rollup2.toXContent(xContentBuilder, (ToXContent.Params)RestHandlerUtilsKt.getXCONTENT_WITHOUT_TYPE()));
        XContentType xContentType = XContentType.JSON;
        Intrinsics.checkNotNull((Object)xContentType, (String)"null cannot be cast to non-null type org.opensearch.core.xcontent.MediaType");
        Map rollup3 = (Map)XContentHelper.convertToMap((BytesReference)bytesReference, (boolean)false, (MediaType)((MediaType)xContentType)).v2();
        Map metaMappings = new LinkedHashMap();
        Object meta = source.get("_meta");
        if (meta == null) {
            this.log.debug("Could not find meta mappings for index [" + index2 + "], creating meta mappings");
            Map rollupJobEntries = MapsKt.mapOf((Pair)TuplesKt.to((Object)request.getRollup().getId(), (Object)rollup3));
            Map rollups2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollups", (Object)rollupJobEntries));
            metaMappings.put("_meta", rollups2);
        } else {
            Map rollupJobEntries;
            Object rollups3 = ((Map)meta).get("rollups");
            if (rollups3 == null) {
                this.log.debug("Could not find meta rollup mappings for index [" + index2 + "], creating meta rollup mappings");
                rollupJobEntries = MapsKt.mapOf((Pair)TuplesKt.to((Object)request.getRollup().getId(), (Object)rollup3));
                Map updatedRollups = MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollups", (Object)rollupJobEntries));
                metaMappings.put("_meta", updatedRollups);
            } else {
                if (((Map)rollups3).containsKey(request.getRollup().getId())) {
                    this.log.debug("Meta rollup mappings already contain rollup " + request.getRollup().getId() + " for index [" + index2 + "]");
                    listener.onFailure((Exception)new IllegalStateException("Meta rollup mappings already contain rollup " + request.getRollup().getId() + " for index [" + index2 + "]"));
                    return;
                }
                rollupJobEntries = MapsKt.toMutableMap((Map)((Map)rollups3));
                rollupJobEntries.put(request.getRollup().getId(), rollup3);
                Map updatedRollups = MapsKt.mapOf((Pair)TuplesKt.to((Object)"rollups", (Object)rollupJobEntries));
                metaMappings.put("_meta", updatedRollups);
            }
        }
        String[] stringArray = new String[]{targetIndexResolvedName};
        PutMappingRequest putMappingRequest = new PutMappingRequest(stringArray).source(metaMappings);
        this.client.admin().indices().putMapping(putMappingRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(listener){
            final /* synthetic */ ActionListener<AcknowledgedResponse> $listener;
            {
                this.$listener = $listener;
            }

            public void onResponse(@NotNull AcknowledgedResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.$listener.onResponse((Object)response2);
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }
        });
    }

    @NotNull
    protected AcknowledgedResponse read(@NotNull StreamInput sin) {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        return new AcknowledgedResponse(sin);
    }

    @NotNull
    protected String executor() {
        return "same";
    }

    private static final UpdateRollupMappingRequest _init_$lambda$0(StreamInput it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new UpdateRollupMappingRequest(it);
    }
}

