/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.upload_chunk;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupInput;
import org.opensearch.ml.common.transport.upload_chunk.MLRegisterModelMetaInput;
import org.opensearch.ml.common.transport.upload_chunk.MLRegisterModelMetaRequest;
import org.opensearch.ml.common.transport.upload_chunk.MLRegisterModelMetaResponse;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelGroupManager;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.utils.MLExceptionUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportRegisterModelMetaAction
extends HandledTransportAction<ActionRequest, MLRegisterModelMetaResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportRegisterModelMetaAction.class);
    TransportService transportService;
    ActionFilters actionFilters;
    MLModelManager mlModelManager;
    Client client;
    ModelAccessControlHelper modelAccessControlHelper;
    MLModelGroupManager mlModelGroupManager;

    @Inject
    public TransportRegisterModelMetaAction(TransportService transportService, ActionFilters actionFilters, MLModelManager mlModelManager, Client client, ModelAccessControlHelper modelAccessControlHelper, MLModelGroupManager mlModelGroupManager) {
        super("cluster:admin/opensearch/ml/register_model_meta", transportService, actionFilters, MLRegisterModelMetaRequest::new);
        this.transportService = transportService;
        this.actionFilters = actionFilters;
        this.mlModelManager = mlModelManager;
        this.client = client;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlModelGroupManager = mlModelGroupManager;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLRegisterModelMetaResponse> listener) {
        MLRegisterModelMetaRequest registerModelMetaRequest = MLRegisterModelMetaRequest.fromActionRequest((ActionRequest)request);
        MLRegisterModelMetaInput mlUploadInput = registerModelMetaRequest.getMlRegisterModelMetaInput();
        User user = RestActionUtils.getUserContext(this.client);
        this.modelAccessControlHelper.validateModelGroupAccess(user, mlUploadInput.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListener.wrap(access -> {
            if (!access.booleanValue()) {
                log.error("You don't have permissions to perform this operation on this model.");
                listener.onFailure((Exception)new IllegalArgumentException("You don't have permissions to perform this operation on this model."));
            } else if (StringUtils.isEmpty((CharSequence)mlUploadInput.getModelGroupId())) {
                MLRegisterModelGroupInput mlRegisterModelGroupInput = this.createRegisterModelGroupRequest(mlUploadInput);
                this.mlModelGroupManager.createModelGroup(mlRegisterModelGroupInput, (ActionListener<String>)ActionListener.wrap(modelGroupId -> {
                    mlUploadInput.setModelGroupId(modelGroupId);
                    this.registerModelMeta(mlUploadInput, listener);
                }, e -> {
                    MLExceptionUtils.logException("Failed to create Model Group", e, log);
                    listener.onFailure(e);
                }));
            } else {
                this.registerModelMeta(mlUploadInput, listener);
            }
        }, e -> {
            MLExceptionUtils.logException("Failed to validate model access", e, log);
            listener.onFailure(e);
        }));
    }

    private MLRegisterModelGroupInput createRegisterModelGroupRequest(MLRegisterModelMetaInput mlUploadInput) {
        return MLRegisterModelGroupInput.builder().name(mlUploadInput.getName()).description(mlUploadInput.getDescription()).backendRoles(mlUploadInput.getBackendRoles()).modelAccessMode(mlUploadInput.getAccessMode()).isAddAllBackendRoles(mlUploadInput.getIsAddAllBackendRoles()).build();
    }

    private void registerModelMeta(MLRegisterModelMetaInput mlUploadInput, ActionListener<MLRegisterModelMetaResponse> listener) {
        this.mlModelManager.registerModelMeta(mlUploadInput, (ActionListener<String>)ActionListener.wrap(modelId -> listener.onResponse((Object)new MLRegisterModelMetaResponse(modelId, MLTaskState.CREATED.name())), ex -> {
            log.error("Failed to init model index", (Throwable)ex);
            listener.onFailure(ex);
        }));
    }
}

