/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.connector;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorRequest;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorResponse;
import org.opensearch.ml.engine.MLEngine;
import org.opensearch.ml.engine.exceptions.MetaDataException;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.indices.MLIndicesHandler;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportCreateConnectorAction
extends HandledTransportAction<ActionRequest, MLCreateConnectorResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportCreateConnectorAction.class);
    private final MLIndicesHandler mlIndicesHandler;
    private final Client client;
    private final MLEngine mlEngine;
    private final MLModelManager mlModelManager;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private volatile List<String> trustedConnectorEndpointsRegex;

    @Inject
    public TransportCreateConnectorAction(TransportService transportService, ActionFilters actionFilters, MLIndicesHandler mlIndicesHandler, Client client, MLEngine mlEngine, ConnectorAccessControlHelper connectorAccessControlHelper, Settings settings, ClusterService clusterService, MLModelManager mlModelManager) {
        super("cluster:admin/opensearch/ml/create_connector", transportService, actionFilters, MLCreateConnectorRequest::new);
        this.mlIndicesHandler = mlIndicesHandler;
        this.client = client;
        this.mlEngine = mlEngine;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlModelManager = mlModelManager;
        this.trustedConnectorEndpointsRegex = (List)MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX, it -> {
            this.trustedConnectorEndpointsRegex = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLCreateConnectorResponse> listener) {
        MLCreateConnectorRequest mlCreateConnectorRequest = MLCreateConnectorRequest.fromActionRequest((ActionRequest)request);
        MLCreateConnectorInput mlCreateConnectorInput = mlCreateConnectorRequest.getMlCreateConnectorInput();
        if (mlCreateConnectorInput.isDryRun()) {
            MLCreateConnectorResponse response = new MLCreateConnectorResponse("dryRunConnector");
            listener.onResponse((Object)response);
            return;
        }
        String connectorName = mlCreateConnectorInput.getName();
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            mlCreateConnectorInput.toXContent(builder, ToXContent.EMPTY_PARAMS);
            Connector connector = Connector.createConnector((XContentBuilder)builder, (String)mlCreateConnectorInput.getProtocol());
            connector.validateConnectorURL(this.trustedConnectorEndpointsRegex);
            User user = RestActionUtils.getUserContext(this.client);
            if (this.connectorAccessControlHelper.accessControlNotEnabled(user)) {
                this.validateSecurityDisabledOrConnectorAccessControlDisabled(mlCreateConnectorInput);
                this.indexConnector(connector, listener);
            } else {
                this.validateRequest4AccessControl(mlCreateConnectorInput, user);
                if (Boolean.TRUE.equals(mlCreateConnectorInput.getAddAllBackendRoles())) {
                    mlCreateConnectorInput.setBackendRoles(user.getBackendRoles());
                }
                connector.setBackendRoles(mlCreateConnectorInput.getBackendRoles());
                connector.setOwner(user);
                connector.setAccess(mlCreateConnectorInput.getAccess());
                this.indexConnector(connector, listener);
            }
        }
        catch (MetaDataException e) {
            log.error("The masterKey for credential encryption is missing in connector creation");
            listener.onFailure((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error("Failed to create connector " + connectorName, (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void indexConnector(Connector connector, ActionListener<MLCreateConnectorResponse> listener) {
        connector.encrypt(arg_0 -> ((MLEngine)this.mlEngine).encrypt(arg_0));
        log.info("connector created, indexing into the connector system index");
        this.mlIndicesHandler.initMLConnectorIndex((ActionListener<Boolean>)ActionListener.wrap(indexCreated -> {
            if (!indexCreated.booleanValue()) {
                listener.onFailure((Exception)new RuntimeException("No response to create ML Connector index"));
                return;
            }
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                ActionListener indexResponseListener = ActionListener.wrap(r -> {
                    log.info("Connector saved into index, result:{}, connector id: {}", (Object)r.getResult(), (Object)r.getId());
                    MLCreateConnectorResponse response = new MLCreateConnectorResponse(r.getId());
                    listener.onResponse((Object)response);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                IndexRequest indexRequest = new IndexRequest(".plugins-ml-connector");
                indexRequest.source(connector.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.index(indexRequest, ActionListener.runBefore((ActionListener)indexResponseListener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
            catch (Exception e) {
                log.error("Failed to save ML connector", (Throwable)e);
                listener.onFailure(e);
            }
        }, e -> {
            log.error("Failed to init ML connector index", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void validateRequest4AccessControl(MLCreateConnectorInput input, User user) {
        Boolean isAddAllBackendRoles = input.getAddAllBackendRoles();
        if (this.connectorAccessControlHelper.isAdmin(user) && Boolean.TRUE.equals(isAddAllBackendRoles)) {
            throw new IllegalArgumentException("Admin can't add all backend roles");
        }
        AccessMode accessMode = input.getAccess();
        if (accessMode == null) {
            if (!CollectionUtils.isEmpty((Collection)input.getBackendRoles()) || Boolean.TRUE.equals(isAddAllBackendRoles)) {
                input.setAccess(AccessMode.RESTRICTED);
                accessMode = AccessMode.RESTRICTED;
            } else {
                input.setAccess(AccessMode.PRIVATE);
                accessMode = AccessMode.PRIVATE;
            }
        }
        if (!(AccessMode.PUBLIC != accessMode && AccessMode.PRIVATE != accessMode || CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && !Boolean.TRUE.equals(isAddAllBackendRoles))) {
            throw new IllegalArgumentException("You can specify backend roles only for a connector with the restricted access mode.");
        }
        if (AccessMode.RESTRICTED == accessMode) {
            if (Boolean.TRUE.equals(isAddAllBackendRoles)) {
                if (!CollectionUtils.isEmpty((Collection)input.getBackendRoles())) {
                    throw new IllegalArgumentException("You can't specify backend roles and add all backend roles to true at same time.");
                }
                if (CollectionUtils.isEmpty((Collection)user.getBackendRoles())) {
                    throw new IllegalArgumentException("You must have at least one backend role to create a connector.");
                }
            } else {
                if (CollectionUtils.isEmpty((Collection)input.getBackendRoles())) {
                    throw new IllegalArgumentException("You must specify at least one backend role or make the connector public/private for registering it.");
                }
                if (!this.connectorAccessControlHelper.isAdmin(user) && !new HashSet(user.getBackendRoles()).containsAll(input.getBackendRoles())) {
                    throw new IllegalArgumentException("You don't have the backend roles specified.");
                }
            }
        }
    }

    private void validateSecurityDisabledOrConnectorAccessControlDisabled(MLCreateConnectorInput input) {
        if (input.getAccess() != null || input.getAddAllBackendRoles() != null || !CollectionUtils.isEmpty((Collection)input.getBackendRoles())) {
            throw new IllegalArgumentException("You cannot specify connector access control parameters because the Security plugin or connector access control is disabled on your cluster.");
        }
    }
}

