/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.connector;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.exception.MLValidationException;
import org.opensearch.ml.common.transport.connector.MLConnectorGetRequest;
import org.opensearch.ml.common.transport.connector.MLConnectorGetResponse;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetConnectorTransportAction
extends HandledTransportAction<ActionRequest, MLConnectorGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetConnectorTransportAction.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;

    @Inject
    public GetConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ConnectorAccessControlHelper connectorAccessControlHelper) {
        super("cluster:admin/opensearch/ml/connectors/get", transportService, actionFilters, MLConnectorGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLConnectorGetResponse> actionListener) {
        MLConnectorGetRequest mlConnectorGetRequest = MLConnectorGetRequest.fromActionRequest((ActionRequest)request);
        String connectorId = mlConnectorGetRequest.getConnectorId();
        FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(mlConnectorGetRequest.isReturnContent());
        GetRequest getRequest = new GetRequest(".plugins-ml-connector").id(connectorId).fetchSourceContext(fetchSourceContext);
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, ActionListener.runBefore((ActionListener)ActionListener.wrap(r -> {
                log.debug("Completed Get Connector Request, id:{}", (Object)connectorId);
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        Connector mlConnector = Connector.createConnector((XContentParser)parser);
                        mlConnector.removeCredential();
                        if (this.connectorAccessControlHelper.hasPermission(user, mlConnector)) {
                            actionListener.onResponse((Object)MLConnectorGetResponse.builder().mlConnector(mlConnector).build());
                        } else {
                            actionListener.onFailure((Exception)new MLValidationException("You don't have permission to access this connector"));
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml connector" + r.getId(), (Throwable)e);
                        actionListener.onFailure(e);
                    }
                } else {
                    actionListener.onFailure((Exception)new IllegalArgumentException("Failed to find connector with the provided connector id: " + connectorId));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    log.error("Failed to get connector index", (Throwable)e);
                    actionListener.onFailure((Exception)new IllegalArgumentException("Fail to find connector"));
                } else {
                    log.error("Failed to get ML connector " + connectorId, (Throwable)e);
                    actionListener.onFailure(e);
                }
            }), () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            log.error("Failed to get ML connector " + connectorId, (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

