/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.connector;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.common.exception.MLValidationException;
import org.opensearch.ml.common.transport.connector.MLConnectorDeleteRequest;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteConnectorTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteConnectorTransportAction.class);
    Client client;
    NamedXContentRegistry xContentRegistry;
    ConnectorAccessControlHelper connectorAccessControlHelper;

    @Inject
    public DeleteConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ConnectorAccessControlHelper connectorAccessControlHelper) {
        super("cluster:admin/opensearch/ml/connectors/delete", transportService, actionFilters, MLConnectorDeleteRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLConnectorDeleteRequest mlConnectorDeleteRequest = MLConnectorDeleteRequest.fromActionRequest((ActionRequest)request);
        String connectorId = mlConnectorDeleteRequest.getConnectorId();
        DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-connector", connectorId);
        this.connectorAccessControlHelper.validateConnectorAccess(this.client, connectorId, (ActionListener<Boolean>)ActionListener.wrap(x -> {
            if (Boolean.TRUE.equals(x)) {
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-model"});
                    SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
                    sourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)"connector_id", (Object)connectorId));
                    searchRequest.source(sourceBuilder);
                    this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
                        SearchHit[] searchHits = searchResponse.getHits().getHits();
                        if (searchHits.length == 0) {
                            this.deleteConnector(deleteRequest, connectorId, actionListener);
                        } else {
                            log.error(searchHits.length + " models are still using this connector, please delete or update the models first!");
                            actionListener.onFailure((Exception)new MLValidationException(searchHits.length + " models are still using this connector, please delete or update the models first!"));
                        }
                    }, e -> {
                        if (e instanceof IndexNotFoundException) {
                            this.deleteConnector(deleteRequest, connectorId, actionListener);
                            return;
                        }
                        log.error("Failed to delete ML connector: " + connectorId, (Throwable)e);
                        actionListener.onFailure(e);
                    }));
                }
                catch (Exception e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                    actionListener.onFailure(e2);
                }
            } else {
                actionListener.onFailure((Exception)new MLValidationException("You are not allowed to delete this connector"));
            }
        }, e -> {
            log.error("Failed to delete ML connector: " + connectorId, (Throwable)e);
            actionListener.onFailure(e);
        }));
    }

    private void deleteConnector(DeleteRequest deleteRequest, final String connectorId, final ActionListener<DeleteResponse> actionListener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse deleteResponse) {
                    if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        log.info("Connector id:{} not found", (Object)connectorId);
                        actionListener.onResponse((Object)deleteResponse);
                        return;
                    }
                    log.info("Completed Delete Connector Request, connector id:{} deleted", (Object)connectorId);
                    actionListener.onResponse((Object)deleteResponse);
                }

                public void onFailure(Exception e) {
                    log.error("Failed to delete ML connector: " + connectorId, (Throwable)e);
                    actionListener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to delete ML connector: " + connectorId, (Throwable)e);
            actionListener.onFailure(e);
        }
    }
}

