/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequestBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.model.Rule;
import org.opensearch.securityanalytics.rules.backend.OSQueryBackend;
import org.opensearch.securityanalytics.rules.backend.QueryBackend;
import org.opensearch.securityanalytics.rules.exceptions.SigmaError;
import org.opensearch.securityanalytics.rules.objects.SigmaRule;
import org.opensearch.securityanalytics.util.FileUtils;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.threadpool.ThreadPool;

public class RuleIndices {
    private static final Logger log = LogManager.getLogger(RuleIndices.class);
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final LogTypeService logTypeService;

    public RuleIndices(LogTypeService logTypeService, Client client, ClusterService clusterService, ThreadPool threadPool) {
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.logTypeService = logTypeService;
    }

    public static String ruleMappings() throws IOException {
        return new String(Objects.requireNonNull(RuleIndices.class.getClassLoader().getResourceAsStream("mappings/rules.json")).readAllBytes(), Charset.defaultCharset());
    }

    public void initRuleIndex(ActionListener<CreateIndexResponse> actionListener, boolean isPrepackaged) throws IOException {
        if (!this.ruleIndexExists(isPrepackaged)) {
            Settings indexSettings = Settings.builder().put("index.hidden", true).build();
            CreateIndexRequest indexRequest = new CreateIndexRequest(this.getRuleIndex(isPrepackaged)).mapping(RuleIndices.ruleMappings()).settings(indexSettings);
            this.client.admin().indices().create(indexRequest, actionListener);
        }
    }

    public void loadRules(List<Rule> rules, WriteRequest.RefreshPolicy refreshPolicy, TimeValue indexTimeout, ActionListener<BulkResponse> actionListener, boolean isPrepackaged) throws IOException {
        String ruleIndex = this.getRuleIndex(isPrepackaged);
        BulkRequest bulkRequest = new BulkRequest().setRefreshPolicy(refreshPolicy).timeout(indexTimeout);
        if (rules.isEmpty()) {
            actionListener.onResponse((Object)new BulkResponse(new BulkItemResponse[0], 1L));
            return;
        }
        for (Rule rule : rules) {
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(ruleIndex).id(rule.getId()).source(rule.toXContent(XContentFactory.jsonBuilder(), (ToXContent.Params)new ToXContent.MapParams(Map.of("with_type", "true")))).timeout(indexTimeout);
            bulkRequest.add(indexRequest);
        }
        this.client.bulk(bulkRequest, actionListener);
    }

    public boolean ruleIndexExists(boolean isPrepackaged) {
        ClusterState clusterState = this.clusterService.state();
        return clusterState.getRoutingTable().hasIndex(this.getRuleIndex(isPrepackaged));
    }

    public ClusterIndexHealth ruleIndexHealth(boolean isPrepackaged) {
        ClusterIndexHealth indexHealth = null;
        if (this.ruleIndexExists(isPrepackaged)) {
            IndexRoutingTable indexRoutingTable = this.clusterService.state().routingTable().index(this.getRuleIndex(isPrepackaged));
            IndexMetadata indexMetadata = this.clusterService.state().metadata().index(this.getRuleIndex(isPrepackaged));
            indexHealth = new ClusterIndexHealth(indexMetadata, indexRoutingTable);
        }
        return indexHealth;
    }

    private String getRuleIndex(boolean isPrepackaged) {
        return isPrepackaged ? ".opensearch-sap-pre-packaged-rules-config" : ".opensearch-sap-custom-rules-config";
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void onCreateMappingsResponse(CreateIndexResponse response, boolean isPrepackaged) {
        if (response.isAcknowledged()) {
            log.info(String.format(Locale.getDefault(), "Created %s with mappings.", isPrepackaged ? ".opensearch-sap-pre-packaged-rules-config" : ".opensearch-sap-custom-rules-config"));
            if (isPrepackaged) {
                IndexUtils.prePackagedRuleIndexUpdated();
            } else {
                IndexUtils.customRuleIndexUpdated();
            }
        } else {
            log.error(String.format(Locale.getDefault(), "Create %s mappings call not acknowledged.", isPrepackaged ? ".opensearch-sap-pre-packaged-rules-config" : ".opensearch-sap-custom-rules-config"));
            throw new OpenSearchStatusException(String.format(Locale.getDefault(), "Create %s mappings call not acknowledged", isPrepackaged ? ".opensearch-sap-pre-packaged-rules-config" : ".opensearch-sap-custom-rules-config"), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
    }

    public void onUpdateMappingsResponse(AcknowledgedResponse response, boolean isPrepackaged) {
        if (response.isAcknowledged()) {
            log.info(String.format(Locale.getDefault(), "Updated  %s with mappings.", isPrepackaged ? ".opensearch-sap-pre-packaged-rules-config" : ".opensearch-sap-custom-rules-config"));
            if (isPrepackaged) {
                IndexUtils.prePackagedRuleIndexUpdated();
            } else {
                IndexUtils.customRuleIndexUpdated();
            }
        } else {
            log.error(String.format(Locale.getDefault(), "Update %s mappings call not acknowledged.", isPrepackaged ? ".opensearch-sap-pre-packaged-rules-config" : ".opensearch-sap-custom-rules-config"));
            throw new OpenSearchStatusException(String.format(Locale.getDefault(), "Update %s mappings call not acknowledged.", isPrepackaged ? ".opensearch-sap-pre-packaged-rules-config" : ".opensearch-sap-custom-rules-config"), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
    }

    public void initPrepackagedRulesIndex(ActionListener<CreateIndexResponse> createListener, ActionListener<AcknowledgedResponse> updateListener, ActionListener<SearchResponse> searchListener) {
        try {
            if (!this.ruleIndexExists(true)) {
                this.initRuleIndex(createListener, true);
            } else if (!IndexUtils.prePackagedRuleIndexUpdated.booleanValue()) {
                IndexUtils.updateIndexMapping(".opensearch-sap-pre-packaged-rules-config", RuleIndices.ruleMappings(), this.clusterService.state(), this.client.admin().indices(), updateListener);
            } else {
                this.countRules(searchListener);
            }
        }
        catch (IOException ex) {
            log.info(ex.getMessage());
        }
    }

    public void importRules(WriteRequest.RefreshPolicy refreshPolicy, TimeValue indexTimeout, ActionListener<BulkResponse> listener) {
        try {
            String url = Objects.requireNonNull(this.getClass().getClassLoader().getResource("rules/")).toURI().toString();
            if (url.contains("!")) {
                String[] paths = url.split("!");
                this.loadQueries(paths, refreshPolicy, indexTimeout, listener);
            } else {
                Path path = Path.of(url, new String[0]);
                this.loadQueries(path, refreshPolicy, indexTimeout, listener);
            }
        }
        catch (IOException | URISyntaxException | SigmaError ex) {
            log.info(ex.getMessage());
        }
    }

    public void deleteRules(ActionListener<BulkByScrollResponse> listener) {
        ((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((OpenSearchClient)this.client, (ActionType)DeleteByQueryAction.INSTANCE).source(new String[]{".opensearch-sap-pre-packaged-rules-config"})).filter((QueryBuilder)QueryBuilders.matchAllQuery())).execute(listener);
    }

    public void countRules(ActionListener<SearchResponse> listener) {
        SearchRequest request = new SearchRequest(new String[]{".opensearch-sap-pre-packaged-rules-config"}).source(new SearchSourceBuilder().size(0)).preference(Preference.PRIMARY_FIRST.type());
        this.client.search(request, listener);
    }

    private List<String> getRules(List<Path> listOfRules) {
        ArrayList<String> rules = new ArrayList<String>();
        listOfRules.forEach(path -> {
            try {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    rules.addAll(this.getRules(Files.list(path).collect(Collectors.toList())));
                } else {
                    rules.add(Files.readString(path, Charset.defaultCharset()));
                }
            }
            catch (IOException ex) {
                log.warn("rules cannot be parsed");
            }
        });
        return rules;
    }

    private void loadQueries(Path path, WriteRequest.RefreshPolicy refreshPolicy, TimeValue indexTimeout, ActionListener<BulkResponse> listener) throws IOException, SigmaError {
        Stream<Path> folder = Files.list(path);
        List folderPaths = folder.collect(Collectors.toList());
        HashMap<String, List<String>> logIndexToRules = new HashMap<String, List<String>>();
        for (Path folderPath : folderPaths) {
            List<String> rules = this.getRules(List.of(folderPath));
            String ruleCategory = this.getRuleCategory(folderPath);
            logIndexToRules.put(ruleCategory, rules);
        }
        this.checkLogTypes(logIndexToRules, refreshPolicy, indexTimeout, listener);
    }

    private String getRuleCategory(Path folderPath) {
        return folderPath.getFileName().toString();
    }

    private void ingestQueries(Map<String, List<String>> logIndexToRules, WriteRequest.RefreshPolicy refreshPolicy, TimeValue indexTimeout, ActionListener<BulkResponse> listener) throws SigmaError, IOException {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        for (Map.Entry<String, List<String>> logIndexToRule : logIndexToRules.entrySet()) {
            Map<String, String> fieldMappings = this.logTypeService.getRuleFieldMappingsForBuiltinLogType(logIndexToRule.getKey());
            OSQueryBackend backend = new OSQueryBackend(fieldMappings, true, true);
            queries.addAll(this.getQueries(backend, logIndexToRule.getKey(), logIndexToRule.getValue()));
        }
        this.loadRules(queries, refreshPolicy, indexTimeout, listener, true);
    }

    private void loadQueries(String[] paths, WriteRequest.RefreshPolicy refreshPolicy, TimeValue indexTimeout, ActionListener<BulkResponse> listener) throws IOException, SigmaError {
        Path path = FileUtils.getFs().getPath(paths[1], new String[0]);
        this.loadQueries(path, refreshPolicy, indexTimeout, listener);
    }

    private List<Rule> getQueries(QueryBackend backend, String category, List<String> rules) throws SigmaError {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        for (String ruleStr : rules) {
            SigmaRule rule = SigmaRule.fromYaml(ruleStr, true);
            backend.resetQueryFields();
            List<Object> ruleQueries = backend.convertRule(rule);
            Set<String> queryFieldNames = backend.getQueryFields().keySet();
            Rule ruleModel = new Rule(rule.getId().toString(), Detector.NO_VERSION, rule, category, ruleQueries, new ArrayList<String>(queryFieldNames), ruleStr);
            queries.add(ruleModel);
        }
        return queries;
    }

    private void checkLogTypes(final Map<String, List<String>> logIndexToRules, final WriteRequest.RefreshPolicy refreshPolicy, final TimeValue indexTimeout, final ActionListener<BulkResponse> listener) {
        this.logTypeService.ensureConfigIndexIsInitialized(new ActionListener<Void>(){

            public void onResponse(Void unused) {
                BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"source"));
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                searchSourceBuilder.query((QueryBuilder)queryBuilder);
                searchSourceBuilder.fetchSource(true);
                searchSourceBuilder.size(10000);
                SearchRequest searchRequest = new SearchRequest();
                searchRequest.indices(new String[]{".opensearch-sap-log-types-config"});
                searchRequest.source(searchSourceBuilder);
                RuleIndices.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse response) {
                        if (response.isTimedOut()) {
                            listener.onFailure((Exception)new OpenSearchStatusException(response.toString(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                        }
                        try {
                            SearchHit[] hits = response.getHits().getHits();
                            HashMap<String, List<String>> filteredLogIndexToRules = new HashMap<String, List<String>>();
                            for (SearchHit hit : hits) {
                                String name = hit.getSourceAsMap().get("name").toString();
                                if (!logIndexToRules.containsKey(name)) continue;
                                filteredLogIndexToRules.put(name, (List)logIndexToRules.get(name));
                            }
                            RuleIndices.this.ingestQueries(filteredLogIndexToRules, refreshPolicy, indexTimeout, (ActionListener<BulkResponse>)listener);
                        }
                        catch (IOException | SigmaError e) {
                            this.onFailure(e);
                        }
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

