/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.action.PublishFindingsRequest;
import org.opensearch.commons.alerting.action.SubscribeFindingsResponse;
import org.opensearch.commons.alerting.model.Finding;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.InputStreamStreamInput;
import org.opensearch.core.common.io.stream.OutputStreamStreamOutput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.correlation.JoinEngine;
import org.opensearch.securityanalytics.correlation.VectorEmbeddingsEngine;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.model.CustomLogType;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.CorrelationIndices;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportCorrelateFindingAction
extends HandledTransportAction<ActionRequest, SubscribeFindingsResponse>
implements SecureTransportAction {
    private static final Logger log = LogManager.getLogger(TransportCorrelateFindingAction.class);
    private final DetectorIndices detectorIndices;
    private final CorrelationIndices correlationIndices;
    private final LogTypeService logTypeService;
    private final ClusterService clusterService;
    private final Settings settings;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ThreadPool threadPool;
    private volatile TimeValue indexTimeout;
    private volatile long corrTimeWindow;
    private volatile long setupTimestamp;

    @Inject
    public TransportCorrelateFindingAction(TransportService transportService, Client client, NamedXContentRegistry xContentRegistry, DetectorIndices detectorIndices, CorrelationIndices correlationIndices, LogTypeService logTypeService, ClusterService clusterService, Settings settings, ActionFilters actionFilters) {
        super("cluster:admin/opensearch/alerting/findings/subscribe", transportService, actionFilters, PublishFindingsRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.detectorIndices = detectorIndices;
        this.correlationIndices = correlationIndices;
        this.logTypeService = logTypeService;
        this.clusterService = clusterService;
        this.settings = settings;
        this.threadPool = this.detectorIndices.getThreadPool();
        this.indexTimeout = (TimeValue)SecurityAnalyticsSettings.INDEX_TIMEOUT.get(this.settings);
        this.corrTimeWindow = ((TimeValue)SecurityAnalyticsSettings.CORRELATION_TIME_WINDOW.get(this.settings)).getMillis();
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.INDEX_TIMEOUT, it -> {
            this.indexTimeout = it;
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.CORRELATION_TIME_WINDOW, it -> {
            this.corrTimeWindow = it.getMillis();
        });
        this.setupTimestamp = System.currentTimeMillis();
    }

    protected void doExecute(final Task task, ActionRequest request, final ActionListener<SubscribeFindingsResponse> actionListener) {
        try {
            final PublishFindingsRequest transformedRequest = this.transformRequest(request);
            if (!this.correlationIndices.correlationIndexExists()) {
                try {
                    this.correlationIndices.initCorrelationIndex(new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse response) {
                            if (response.isAcknowledged()) {
                                IndexUtils.correlationIndexUpdated();
                                TransportCorrelateFindingAction.this.correlationIndices.setupCorrelationIndex(TransportCorrelateFindingAction.this.indexTimeout, TransportCorrelateFindingAction.this.setupTimestamp, new ActionListener<BulkResponse>(){

                                    public void onResponse(BulkResponse response) {
                                        if (response.hasFailures()) {
                                            log.error((Object)new OpenSearchStatusException(response.toString(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                        }
                                        AsyncCorrelateFindingAction correlateFindingAction = new AsyncCorrelateFindingAction(task, transformedRequest, (ActionListener<SubscribeFindingsResponse>)actionListener);
                                        correlateFindingAction.start();
                                    }

                                    public void onFailure(Exception e) {
                                        log.error((Object)e);
                                    }
                                });
                            } else {
                                log.error((Object)new OpenSearchStatusException("Failed to create correlation Index", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                            }
                        }

                        public void onFailure(Exception e) {
                            log.error((Object)e);
                        }
                    });
                }
                catch (IOException ex) {
                    log.error((Object)ex);
                }
            } else {
                AsyncCorrelateFindingAction correlateFindingAction = new AsyncCorrelateFindingAction(task, transformedRequest, actionListener);
                correlateFindingAction.start();
            }
        }
        catch (IOException e) {
            throw new SecurityAnalyticsException("Unknown exception occurred", RestStatus.INTERNAL_SERVER_ERROR, e);
        }
    }

    private PublishFindingsRequest transformRequest(ActionRequest request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamStreamOutput osso = new OutputStreamStreamOutput((OutputStream)baos);
        request.writeTo((StreamOutput)osso);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStreamStreamInput issi = new InputStreamStreamInput((InputStream)bais);
        return new PublishFindingsRequest((StreamInput)issi);
    }

    public class AsyncCorrelateFindingAction {
        private final PublishFindingsRequest request;
        private final JoinEngine joinEngine;
        private final VectorEmbeddingsEngine vectorEmbeddingsEngine;
        private final ActionListener<SubscribeFindingsResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final Task task;

        AsyncCorrelateFindingAction(Task task, PublishFindingsRequest request, ActionListener<SubscribeFindingsResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
            this.joinEngine = new JoinEngine(TransportCorrelateFindingAction.this.client, request, TransportCorrelateFindingAction.this.xContentRegistry, TransportCorrelateFindingAction.this.corrTimeWindow, this, TransportCorrelateFindingAction.this.logTypeService);
            this.vectorEmbeddingsEngine = new VectorEmbeddingsEngine(TransportCorrelateFindingAction.this.client, TransportCorrelateFindingAction.this.indexTimeout, TransportCorrelateFindingAction.this.corrTimeWindow, this);
        }

        void start() {
            TransportCorrelateFindingAction.this.threadPool.getThreadContext().stashContext();
            String monitorId = this.request.getMonitorId();
            final Finding finding = this.request.getFinding();
            if (TransportCorrelateFindingAction.this.detectorIndices.detectorIndexExists()) {
                NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"detector", (QueryBuilder)QueryBuilders.matchQuery((String)"detector.monitor_id", (Object)monitorId), (ScoreMode)ScoreMode.None);
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                searchSourceBuilder.query((QueryBuilder)queryBuilder);
                searchSourceBuilder.fetchSource(true);
                searchSourceBuilder.size(1);
                SearchRequest searchRequest = new SearchRequest();
                searchRequest.indices(new String[]{".opensearch-sap-detectors-config"});
                searchRequest.source(searchSourceBuilder);
                searchRequest.preference(Preference.PRIMARY_FIRST.type());
                TransportCorrelateFindingAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse response) {
                        if (response.isTimedOut()) {
                            AsyncCorrelateFindingAction.this.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                        }
                        SearchHits hits = response.getHits();
                        if (hits.getTotalHits().value == 1L) {
                            try {
                                SearchHit hit = hits.getAt(0);
                                XContentParser xcp = XContentType.JSON.xContent().createParser(TransportCorrelateFindingAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                                Detector detector = Detector.docParse(xcp, hit.getId(), hit.getVersion());
                                AsyncCorrelateFindingAction.this.joinEngine.onSearchDetectorResponse(detector, finding);
                            }
                            catch (IOException e) {
                                AsyncCorrelateFindingAction.this.onFailures(e);
                            }
                        } else {
                            AsyncCorrelateFindingAction.this.onFailures((Exception)new OpenSearchStatusException("detector not found given monitor id", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                        }
                    }

                    public void onFailure(Exception e) {
                        AsyncCorrelateFindingAction.this.onFailures(e);
                    }
                });
            } else {
                this.onFailures((Exception)((Object)new SecurityAnalyticsException(String.format(Locale.getDefault(), "Detector index %s doesnt exist", ".opensearch-sap-detectors-config"), RestStatus.INTERNAL_SERVER_ERROR, new RuntimeException())));
            }
        }

        public void initCorrelationIndex(final String detectorType, final Map<String, List<String>> correlatedFindings, final List<String> correlationRules) {
            try {
                if (!IndexUtils.correlationIndexUpdated.booleanValue()) {
                    IndexUtils.updateIndexMapping(".opensearch-sap-correlation-history", CorrelationIndices.correlationMappings(), TransportCorrelateFindingAction.this.clusterService.state(), TransportCorrelateFindingAction.this.client.admin().indices(), new ActionListener<AcknowledgedResponse>(){

                        public void onResponse(AcknowledgedResponse response) {
                            if (response.isAcknowledged()) {
                                IndexUtils.correlationIndexUpdated();
                                AsyncCorrelateFindingAction.this.getTimestampFeature(detectorType, correlatedFindings, null, correlationRules);
                            } else {
                                AsyncCorrelateFindingAction.this.onFailures((Exception)new OpenSearchStatusException("Failed to create correlation Index", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                            }
                        }

                        public void onFailure(Exception e) {
                            AsyncCorrelateFindingAction.this.onFailures(e);
                        }
                    });
                } else {
                    this.getTimestampFeature(detectorType, correlatedFindings, null, correlationRules);
                }
            }
            catch (IOException ex) {
                this.onFailures(ex);
            }
        }

        public void getTimestampFeature(final String detectorType, final Map<String, List<String>> correlatedFindings, final Finding orphanFinding, final List<String> correlationRules) {
            final long findingTimestamp = this.request.getFinding().getTimestamp().toEpochMilli();
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"scoreTimestamp", (long)0L));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(true);
            searchSourceBuilder.size(1);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{".opensearch-sap-correlation-history"});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            TransportCorrelateFindingAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    String id = response.getHits().getHits()[0].getId();
                    Map hitSource = response.getHits().getHits()[0].getSourceAsMap();
                    long scoreTimestamp = (Long)hitSource.get("scoreTimestamp");
                    if (findingTimestamp - 1728000000L > scoreTimestamp) {
                        try {
                            XContentBuilder scoreBuilder = XContentFactory.jsonBuilder().startObject();
                            scoreBuilder.field("scoreTimestamp", findingTimestamp - 1728000000L);
                            scoreBuilder.field("root", false);
                            scoreBuilder.endObject();
                            IndexRequest scoreIndexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-history").id(id).source(scoreBuilder).timeout(TransportCorrelateFindingAction.this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                            TransportCorrelateFindingAction.this.client.index(scoreIndexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                                public void onResponse(IndexResponse response) {
                                    BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"source"));
                                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                                    searchSourceBuilder.query((QueryBuilder)queryBuilder);
                                    searchSourceBuilder.fetchSource(true);
                                    searchSourceBuilder.size(10000);
                                    SearchRequest searchRequest = new SearchRequest();
                                    searchRequest.indices(new String[]{".opensearch-sap-log-types-config"});
                                    searchRequest.source(searchSourceBuilder);
                                    TransportCorrelateFindingAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                                        public void onResponse(SearchResponse response) {
                                            if (response.isTimedOut()) {
                                                AsyncCorrelateFindingAction.this.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                            }
                                            SearchHit[] hits = response.getHits().getHits();
                                            HashMap<String, CustomLogType> logTypes = new HashMap<String, CustomLogType>();
                                            for (SearchHit hit : hits) {
                                                Map sourceMap = hit.getSourceAsMap();
                                                logTypes.put(sourceMap.get("name").toString(), new CustomLogType(sourceMap));
                                            }
                                            if (correlatedFindings != null) {
                                                if (correlatedFindings.isEmpty()) {
                                                    AsyncCorrelateFindingAction.this.vectorEmbeddingsEngine.insertOrphanFindings(detectorType, AsyncCorrelateFindingAction.this.request.getFinding(), Long.valueOf(1728000L).floatValue(), logTypes);
                                                }
                                                for (Map.Entry entry : correlatedFindings.entrySet()) {
                                                    AsyncCorrelateFindingAction.this.vectorEmbeddingsEngine.insertCorrelatedFindings(detectorType, AsyncCorrelateFindingAction.this.request.getFinding(), (String)entry.getKey(), (List)entry.getValue(), Long.valueOf(1728000L).floatValue(), correlationRules, logTypes);
                                                }
                                            } else {
                                                AsyncCorrelateFindingAction.this.vectorEmbeddingsEngine.insertOrphanFindings(detectorType, orphanFinding, Long.valueOf(1728000L).floatValue(), logTypes);
                                            }
                                        }

                                        public void onFailure(Exception e) {
                                            AsyncCorrelateFindingAction.this.onFailures(e);
                                        }
                                    });
                                }

                                public void onFailure(Exception e) {
                                    AsyncCorrelateFindingAction.this.onFailures(e);
                                }
                            });
                        }
                        catch (Exception ex) {
                            AsyncCorrelateFindingAction.this.onFailures(ex);
                        }
                    } else {
                        final float timestampFeature = Long.valueOf((findingTimestamp - scoreTimestamp) / 1000L).floatValue();
                        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"source"));
                        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                        searchSourceBuilder.query((QueryBuilder)queryBuilder);
                        searchSourceBuilder.fetchSource(true);
                        searchSourceBuilder.size(10000);
                        SearchRequest searchRequest = new SearchRequest();
                        searchRequest.indices(new String[]{".opensearch-sap-log-types-config"});
                        searchRequest.source(searchSourceBuilder);
                        TransportCorrelateFindingAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                            public void onResponse(SearchResponse response) {
                                if (response.isTimedOut()) {
                                    AsyncCorrelateFindingAction.this.onFailures((Exception)new OpenSearchStatusException(response.toString(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                }
                                SearchHit[] hits = response.getHits().getHits();
                                HashMap<String, CustomLogType> logTypes = new HashMap<String, CustomLogType>();
                                for (SearchHit hit : hits) {
                                    Map sourceMap = hit.getSourceAsMap();
                                    logTypes.put(sourceMap.get("name").toString(), new CustomLogType(sourceMap));
                                }
                                if (correlatedFindings != null) {
                                    if (correlatedFindings.isEmpty()) {
                                        AsyncCorrelateFindingAction.this.vectorEmbeddingsEngine.insertOrphanFindings(detectorType, AsyncCorrelateFindingAction.this.request.getFinding(), timestampFeature, logTypes);
                                    }
                                    for (Map.Entry entry : correlatedFindings.entrySet()) {
                                        AsyncCorrelateFindingAction.this.vectorEmbeddingsEngine.insertCorrelatedFindings(detectorType, AsyncCorrelateFindingAction.this.request.getFinding(), (String)entry.getKey(), (List)entry.getValue(), timestampFeature, correlationRules, logTypes);
                                    }
                                } else {
                                    AsyncCorrelateFindingAction.this.vectorEmbeddingsEngine.insertOrphanFindings(detectorType, orphanFinding, timestampFeature, logTypes);
                                }
                            }

                            public void onFailure(Exception e) {
                                AsyncCorrelateFindingAction.this.onFailures(e);
                            }
                        });
                    }
                }

                public void onFailure(Exception e) {
                    AsyncCorrelateFindingAction.this.onFailures(e);
                }
            });
        }

        public void onOperation() {
            this.response.set(RestStatus.OK);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null);
            }
        }

        public void onFailures(Exception t) {
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(t);
            }
        }

        private void finishHim(Exception t) {
            TransportCorrelateFindingAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    if (t instanceof OpenSearchStatusException) {
                        throw t;
                    }
                    throw SecurityAnalyticsException.wrap(t);
                }
                return new SubscribeFindingsResponse(RestStatus.OK);
            }));
        }
    }
}

